/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.runtime.internal.engine;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XExpression;
import org.openhab.core.model.core.ModelParser;
import org.openhab.core.model.script.ScriptServiceUtil;
import org.openhab.core.model.script.ScriptStandaloneSetup;
import org.openhab.core.model.script.engine.Script;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.openhab.core.model.script.engine.ScriptExecutionException;
import org.openhab.core.model.script.engine.ScriptParsingException;
import org.openhab.core.model.script.runtime.ScriptRuntime;
import org.openhab.core.model.script.runtime.internal.engine.ScriptImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ScriptEngineImpl
implements ScriptEngine,
ModelParser {
    protected XtextResourceSet resourceSet;
    private final Logger logger = LoggerFactory.getLogger(ScriptEngineImpl.class);
    private ScriptServiceUtil scriptServiceUtil;

    @Activate
    public void activate() {
        ScriptStandaloneSetup.doSetup((ScriptServiceUtil)this.scriptServiceUtil, (ScriptEngine)this);
        this.logger.debug("Registered 'script' configuration parser");
    }

    private XtextResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = (XtextResourceSet)ScriptStandaloneSetup.getInjector().getInstance(XtextResourceSet.class);
            this.resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
        }
        return this.resourceSet;
    }

    @Deactivate
    public void deactivate() {
        this.resourceSet = null;
        ScriptStandaloneSetup.unregister();
    }

    protected void setScriptRuntime(ScriptRuntime scriptRuntime) {
    }

    protected void unsetScriptRuntime(ScriptRuntime scriptRuntime) {
    }

    @Reference
    protected void setScriptServiceUtil(ScriptServiceUtil scriptServiceUtil) {
        this.scriptServiceUtil = scriptServiceUtil;
        scriptServiceUtil.setScriptEngine((ScriptEngine)this);
    }

    protected void unsetScriptServiceUtil(ScriptServiceUtil scriptServiceUtil) {
        scriptServiceUtil.unsetScriptEngine((ScriptEngine)this);
        this.scriptServiceUtil = null;
    }

    public Script newScriptFromString(String scriptAsString) throws ScriptParsingException {
        return this.newScriptFromXExpression(this.parseScriptIntoXTextEObject(scriptAsString));
    }

    public Script newScriptFromXExpression(XExpression expression) {
        ScriptImpl script = (ScriptImpl)ScriptStandaloneSetup.getInjector().getInstance(ScriptImpl.class);
        script.setXExpression(expression);
        return script;
    }

    public Object executeScript(String scriptAsString) throws ScriptParsingException, ScriptExecutionException {
        return this.newScriptFromString(scriptAsString).execute();
    }

    private XExpression parseScriptIntoXTextEObject(String scriptAsString) throws ScriptParsingException {
        XtextResourceSet resourceSet = this.getResourceSet();
        Resource resource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet));
        try {
            resource.load((InputStream)new StringInputStream(scriptAsString, StandardCharsets.UTF_8.name()), resourceSet.getLoadOptions());
        }
        catch (IOException e) {
            throw new ScriptParsingException("Unexpected IOException; from close() of a String-based ByteArrayInputStream, no real I/O; how is that possible???", scriptAsString, (Throwable)e);
        }
        EList errors = resource.getErrors();
        if (!errors.isEmpty()) {
            this.deleteResource(resource);
            throw new ScriptParsingException("Failed to parse expression (due to managed SyntaxError/s)", scriptAsString).addDiagnosticErrors((List)errors);
        }
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            Iterable<Issue> validationErrors = this.getValidationErrors((EObject)contents.get(0));
            if (!validationErrors.iterator().hasNext()) {
                return (XExpression)contents.get(0);
            }
            this.deleteResource(resource);
            throw new ScriptParsingException("Failed to parse expression (due to managed ValidationError/s)", scriptAsString).addValidationIssues(validationErrors);
        }
        this.deleteResource(resource);
        return null;
    }

    protected URI computeUnusedUri(ResourceSet resourceSet) {
        String name = "__synthetic";
        int MAX_TRIES = 1000;
        int i = 0;
        while (i < 1000) {
            URI syntheticUri = URI.createURI((String)(name + Math.random() + ".script"));
            if (resourceSet.getResource(syntheticUri, false) == null) {
                return syntheticUri;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected List<Issue> validate(EObject model) {
        IResourceValidator validator = ((XtextResource)model.eResource()).getResourceServiceProvider().getResourceValidator();
        return validator.validate(model.eResource(), CheckMode.ALL, CancelIndicator.NullImpl);
    }

    protected Iterable<Issue> getValidationErrors(EObject model) {
        List<Issue> validate = this.validate(model);
        return validate.stream().filter(input -> Severity.ERROR == input.getSeverity()).toList();
    }

    public String getExtension() {
        return "script";
    }

    private void deleteResource(Resource resource) {
        try {
            resource.delete(Map.of());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

