/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal.webaudio;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioHTTPServer;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSinkAsync;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.StreamServed;
import org.openhab.core.audio.UnsupportedAudioFormatException;
import org.openhab.core.audio.UnsupportedAudioStreamException;
import org.openhab.core.audio.internal.webaudio.PlayURLEvent;
import org.openhab.core.audio.internal.webaudio.WebAudioEventFactory;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.library.types.PercentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AudioSink.class}, immediate=true)
public class WebAudioAudioSink
extends AudioSinkAsync {
    private final Logger logger = LoggerFactory.getLogger(WebAudioAudioSink.class);
    private static final Set<AudioFormat> SUPPORTED_AUDIO_FORMATS = Set.of(AudioFormat.MP3, AudioFormat.WAV);
    private static final Set<Class<? extends AudioStream>> SUPPORTED_AUDIO_STREAMS = Set.of(AudioStream.class);
    private AudioHTTPServer audioHTTPServer;
    private EventPublisher eventPublisher;

    @Activate
    public WebAudioAudioSink(@Reference AudioHTTPServer audioHTTPServer, @Reference EventPublisher eventPublisher) {
        this.audioHTTPServer = audioHTTPServer;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void processAsynchronously(@Nullable AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        if (audioStream == null) {
            this.sendEvent("");
            return;
        }
        this.logger.debug("Received audio stream of format {}", (Object)audioStream.getFormat());
        try {
            StreamServed servedStream = this.audioHTTPServer.serve(audioStream, 10, true);
            servedStream.playEnd().thenRun(() -> this.playbackFinished(audioStream));
            this.sendEvent(servedStream.url());
        }
        catch (IOException e) {
            this.logger.warn("Cannot precache the audio stream to serve it", (Throwable)e);
        }
    }

    private void sendEvent(String url) {
        PlayURLEvent event = WebAudioEventFactory.createPlayURLEvent(url);
        this.eventPublisher.post((Event)event);
    }

    @Override
    public Set<AudioFormat> getSupportedFormats() {
        return SUPPORTED_AUDIO_FORMATS;
    }

    @Override
    public Set<Class<? extends AudioStream>> getSupportedStreams() {
        return SUPPORTED_AUDIO_STREAMS;
    }

    @Override
    public String getId() {
        return "webaudio";
    }

    @Override
    public @Nullable String getLabel(@Nullable Locale locale) {
        return "Web Audio";
    }

    @Override
    public PercentType getVolume() throws IOException {
        return PercentType.HUNDRED;
    }

    @Override
    public void setVolume(PercentType volume) throws IOException {
        throw new IOException("Web Audio sink does not support volume level changes.");
    }
}

