/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.util.Objects;
import java.util.function.BinaryOperator;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.quantity.Quantities;
import tech.uom.lib.common.function.QuantityFunctions;

public class QuantitySummaryStatistics<Q extends Quantity<Q>> {
    private final Quantity<Q> empty;
    private long count;
    private Quantity<Q> min;
    private Quantity<Q> max;
    private Quantity<Q> sum;
    private Quantity<Q> average;
    private final BinaryOperator<Quantity<Q>> minFunctions = QuantityFunctions.min();
    private final BinaryOperator<Quantity<Q>> maxFunctions = QuantityFunctions.max();

    QuantitySummaryStatistics(Unit<Q> unit) {
        this.empty = Quantities.getQuantity(0, unit);
        this.setQuantity(this.empty);
    }

    public void accept(Quantity<Q> quantity) {
        Objects.requireNonNull(quantity);
        if (this.isEmpty()) {
            this.setQuantity(quantity.to(this.empty.getUnit()));
            ++this.count;
        } else {
            this.doSummary(quantity.to(this.empty.getUnit()));
        }
    }

    public QuantitySummaryStatistics<Q> combine(QuantitySummaryStatistics<Q> quantitySummary) {
        Objects.requireNonNull(quantitySummary);
        if (!this.equals(quantitySummary)) {
            return this;
        }
        this.min = (Quantity)this.minFunctions.apply(this.min, quantitySummary.min.to(this.empty.getUnit()));
        this.max = (Quantity)this.maxFunctions.apply(this.max, quantitySummary.max.to(this.empty.getUnit()));
        this.sum = this.sum.add(quantitySummary.sum);
        this.count += quantitySummary.count;
        this.average = this.sum.divide((Number)this.count);
        return this;
    }

    private void doSummary(Quantity<Q> moneraty) {
        this.min = (Quantity)this.minFunctions.apply(this.min, moneraty);
        this.max = (Quantity)this.maxFunctions.apply(this.max, moneraty);
        this.sum = this.sum.add(moneraty);
        this.average = this.sum.divide((Number)(++this.count));
    }

    private boolean isEmpty() {
        return this.count == 0L;
    }

    private void setQuantity(Quantity<Q> quantity) {
        this.min = quantity;
        this.max = quantity;
        this.sum = quantity;
        this.average = quantity;
    }

    public long getCount() {
        return this.count;
    }

    public Quantity<Q> getMin() {
        return this.min;
    }

    public Quantity<Q> getMin(Unit<Q> unit) {
        return this.min.to(unit);
    }

    public Quantity<Q> getMax() {
        return this.max;
    }

    public Quantity<Q> getMax(Unit<Q> unit) {
        return this.max.to(unit);
    }

    public Quantity<Q> getSum() {
        return this.sum;
    }

    public Quantity<Q> getSum(Unit<Q> unit) {
        return this.sum.to(unit);
    }

    public Quantity<Q> getAverage() {
        return this.average;
    }

    public Quantity<Q> getAverage(Unit<Q> unit) {
        return this.average.to(unit);
    }

    public QuantitySummaryStatistics<Q> to(Unit<Q> unit) {
        QuantitySummaryStatistics<Q> summary = new QuantitySummaryStatistics<Q>(unit);
        summary.average = this.average.to(unit);
        summary.count = this.count;
        summary.max = this.max.to(unit);
        summary.min = this.min.to(unit);
        summary.sum = this.sum.to(unit);
        return summary;
    }

    public boolean equals(Object obj) {
        if (QuantitySummaryStatistics.class.isInstance(obj)) {
            QuantitySummaryStatistics other = (QuantitySummaryStatistics)QuantitySummaryStatistics.class.cast(obj);
            return Objects.equals(this.empty.getUnit(), other.empty.getUnit());
        }
        return false;
    }

    public int hashCode() {
        return this.empty.getUnit().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[unit: ").append(this.empty.getUnit()).append(",");
        sb.append("count:").append(this.count).append(",");
        sb.append("min:").append(this.min).append(",");
        sb.append("max:").append(this.max).append(",");
        sb.append("sum:").append(this.sum).append(",");
        sb.append("average:").append(this.average).append("]");
        return sb.toString();
    }
}

