/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.bracketmatching;

import com.google.common.base.Preconditions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class BracePair {
    private final String leftBrace;
    private final String rightBrace;
    private final boolean structural;

    public BracePair(String leftBrace, String rightBrace, boolean structural) {
        Preconditions.checkArgument((leftBrace.length() == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((rightBrace.length() == 1 ? 1 : 0) != 0);
        this.leftBrace = leftBrace;
        this.rightBrace = rightBrace;
        this.structural = structural;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftBrace == null ? 0 : this.leftBrace.hashCode());
        result = 31 * result + (this.rightBrace == null ? 0 : this.rightBrace.hashCode());
        result = 31 * result + (this.structural ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BracePair other = (BracePair)obj;
        if (this.leftBrace == null ? other.leftBrace != null : !this.leftBrace.equals(other.leftBrace)) {
            return false;
        }
        if (this.rightBrace == null ? other.rightBrace != null : !this.rightBrace.equals(other.rightBrace)) {
            return false;
        }
        return this.structural == other.structural;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("leftBrace", (Object)this.leftBrace);
        b.add("rightBrace", (Object)this.rightBrace);
        b.add("structural", (Object)this.structural);
        return b.toString();
    }

    public String getLeftBrace() {
        return this.leftBrace;
    }

    public String getRightBrace() {
        return this.rightBrace;
    }

    public boolean isStructural() {
        return this.structural;
    }
}

