/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt3.Mqtt3MessageEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttStatefulConnect;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.mqtt.mqtt3.message.Mqtt3MessageType;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt3ConnectEncoder
extends Mqtt3MessageEncoder<MqttStatefulConnect> {
    private static final int FIXED_HEADER = Mqtt3MessageType.CONNECT.getCode() << 4;
    private static final int VARIABLE_HEADER_FIXED_LENGTH = 10;
    private static final byte PROTOCOL_VERSION = 4;

    @Inject
    Mqtt3ConnectEncoder() {
    }

    @Override
    int remainingLength(@NotNull MqttStatefulConnect message) {
        MqttWillPublish willPublish;
        MqttConnect stateless = (MqttConnect)message.stateless();
        int remainingLength = 10;
        remainingLength += message.getClientIdentifier().encodedLength();
        MqttSimpleAuth simpleAuth = stateless.getRawSimpleAuth();
        if (simpleAuth != null) {
            remainingLength += MqttMessageEncoderUtil.nullableEncodedLength(simpleAuth.getRawUsername());
            remainingLength += MqttMessageEncoderUtil.nullableEncodedLength(simpleAuth.getRawPassword());
        }
        if ((willPublish = stateless.getRawWillPublish()) != null) {
            remainingLength += willPublish.getTopic().encodedLength();
            remainingLength += MqttMessageEncoderUtil.encodedOrEmptyLength(willPublish.getRawPayload());
        }
        return remainingLength;
    }

    @Override
    void encode(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out, int remainingLength) {
        this.encodeFixedHeader(out, remainingLength);
        this.encodeVariableHeader(message, out);
        this.encodePayload(message, out);
    }

    private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out) {
        MqttWillPublish willPublish;
        MqttConnect stateless = (MqttConnect)message.stateless();
        MqttUtf8StringImpl.PROTOCOL_NAME.encode(out);
        out.writeByte(4);
        int connectFlags = 0;
        MqttSimpleAuth simpleAuth = stateless.getRawSimpleAuth();
        if (simpleAuth != null) {
            if (simpleAuth.getRawUsername() != null) {
                connectFlags |= 0x80;
            }
            if (simpleAuth.getRawPassword() != null) {
                connectFlags |= 0x40;
            }
        }
        if ((willPublish = stateless.getRawWillPublish()) != null) {
            connectFlags |= 4;
            connectFlags |= willPublish.getQos().getCode() << 3;
            if (willPublish.isRetain()) {
                connectFlags |= 0x20;
            }
        }
        if (stateless.isCleanStart()) {
            connectFlags |= 2;
        }
        out.writeByte(connectFlags);
        out.writeShort(stateless.getKeepAlive());
    }

    private void encodePayload(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out) {
        message.getClientIdentifier().encode(out);
        this.encodeWillPublish(message, out);
        MqttSimpleAuth simpleAuth = ((MqttConnect)message.stateless()).getRawSimpleAuth();
        if (simpleAuth != null) {
            MqttMessageEncoderUtil.encodeNullable(simpleAuth.getRawUsername(), out);
            MqttMessageEncoderUtil.encodeNullable(simpleAuth.getRawPassword(), out);
        }
    }

    private void encodeWillPublish(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out) {
        MqttWillPublish willPublish = ((MqttConnect)message.stateless()).getRawWillPublish();
        if (willPublish != null) {
            willPublish.getTopic().encode(out);
            MqttMessageEncoderUtil.encodeNullable(willPublish.getRawPayload(), out);
        }
    }
}

