/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ArrayTypeSignature;
import aQute.bnd.signatures.BaseType;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.SimpleClassTypeSignature;
import aQute.bnd.signatures.TypeArgument;
import aQute.bnd.signatures.TypeVariableSignature;
import aQute.lib.stringrover.StringRover;
import java.util.Set;

class Signatures {
    static final JavaTypeSignature[] EMPTY_JavaTypeSignature = new JavaTypeSignature[0];
    static final ReferenceTypeSignature[] EMPTY_ReferenceTypeSignature = new ReferenceTypeSignature[0];

    private Signatures() {
    }

    static JavaTypeSignature parseJavaTypeSignature(StringRover signature) {
        switch (signature.charAt(0)) {
            case 'B': {
                signature.increment();
                return BaseType.B;
            }
            case 'C': {
                signature.increment();
                return BaseType.C;
            }
            case 'D': {
                signature.increment();
                return BaseType.D;
            }
            case 'F': {
                signature.increment();
                return BaseType.F;
            }
            case 'I': {
                signature.increment();
                return BaseType.I;
            }
            case 'J': {
                signature.increment();
                return BaseType.J;
            }
            case 'S': {
                signature.increment();
                return BaseType.S;
            }
            case 'Z': {
                signature.increment();
                return BaseType.Z;
            }
        }
        return Signatures.parseReferenceTypeSignature(signature);
    }

    static ReferenceTypeSignature parseReferenceTypeSignature(StringRover signature) {
        switch (signature.charAt(0)) {
            case 'T': {
                return TypeVariableSignature.parseTypeVariableSignature(signature);
            }
            case 'L': {
                return ClassTypeSignature.parseClassTypeSignature(signature);
            }
            case '[': {
                return ArrayTypeSignature.parseArrayTypeSignature(signature);
            }
        }
        throw new IllegalArgumentException("invalid signature: " + signature);
    }

    static void erasedBinaryReferences(JavaTypeSignature sig, Set<String> references) {
        while (sig instanceof ArrayTypeSignature) {
            sig = ((ArrayTypeSignature)sig).component;
        }
        if (sig instanceof ClassTypeSignature) {
            ClassTypeSignature type = (ClassTypeSignature)sig;
            references.add(type.binary);
            TypeArgument.erasedBinaryReferences(type.classType.typeArguments, references);
            for (SimpleClassTypeSignature innerType : type.innerTypes) {
                TypeArgument.erasedBinaryReferences(innerType.typeArguments, references);
            }
        }
    }

    static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    static String intern(String s) {
        return s.intern();
    }
}

