/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

@NoPublicAPI
public final class SupportedEllipticCurvesExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 16;
    private static final int CURVE_BITS = 16;
    private final List<XECDHECryptography.SupportedGroup> supportedGroups;

    public SupportedEllipticCurvesExtension(List<XECDHECryptography.SupportedGroup> supportedGroups) {
        super(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
        this.supportedGroups = supportedGroups;
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        int listLength = this.supportedGroups.size() * 2;
        writer.write(listLength + 2, 16);
        writer.write(listLength, 16);
        for (XECDHECryptography.SupportedGroup group : this.supportedGroups) {
            writer.write(group.getId(), 16);
        }
    }

    public static HelloExtension fromExtensionDataReader(DatagramReader extensionDataReader) {
        ArrayList<XECDHECryptography.SupportedGroup> groups = new ArrayList<XECDHECryptography.SupportedGroup>();
        int listLength = extensionDataReader.read(16);
        DatagramReader rangeReader = extensionDataReader.createRangeReader(listLength);
        while (rangeReader.bytesAvailable()) {
            int id = rangeReader.read(16);
            XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromId(id);
            if (group == null) continue;
            groups.add(group);
        }
        return new SupportedEllipticCurvesExtension(Collections.unmodifiableList(groups));
    }

    @Override
    public int getLength() {
        return 6 + this.supportedGroups.size() * 2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\t\t\tLength: ").append(this.getLength() - 4);
        sb.append(StringUtil.lineSeparator()).append("\t\t\t\tElliptic Curves Length: ").append(this.getLength() - 6);
        sb.append(StringUtil.lineSeparator()).append("\t\t\t\tElliptic Curves (").append(this.supportedGroups.size()).append(" curves):");
        for (XECDHECryptography.SupportedGroup group : this.supportedGroups) {
            sb.append(StringUtil.lineSeparator()).append("\t\t\t\t\tElliptic Curve: ");
            sb.append(group.name()).append(" (").append(group.getId()).append(")");
        }
        return sb.toString();
    }

    public List<XECDHECryptography.SupportedGroup> getSupportedGroups() {
        return this.supportedGroups;
    }
}

