/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sitemap.internal;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.io.rest.core.item.EnrichedItemDTOMapper;
import org.openhab.core.io.rest.sitemap.SitemapSubscriptionService;
import org.openhab.core.io.rest.sitemap.internal.ServerAliveEvent;
import org.openhab.core.io.rest.sitemap.internal.SitemapChangedEvent;
import org.openhab.core.io.rest.sitemap.internal.SitemapEvent;
import org.openhab.core.io.rest.sitemap.internal.SitemapResource;
import org.openhab.core.io.rest.sitemap.internal.SitemapWidgetEvent;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.events.GroupStateUpdatedEvent;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.model.sitemap.sitemap.Button;
import org.openhab.core.model.sitemap.sitemap.Buttongrid;
import org.openhab.core.model.sitemap.sitemap.Chart;
import org.openhab.core.model.sitemap.sitemap.Condition;
import org.openhab.core.model.sitemap.sitemap.Frame;
import org.openhab.core.model.sitemap.sitemap.IconRule;
import org.openhab.core.model.sitemap.sitemap.LinkableWidget;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.types.State;
import org.openhab.core.ui.items.ItemUIRegistry;

public class WidgetsChangeListener
implements EventSubscriber {
    private static final int REVERT_INTERVAL = 300;
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final String sitemapName;
    private final String pageId;
    private final ItemUIRegistry itemUIRegistry;
    private final TimeZoneProvider timeZoneProvider;
    private EList<Widget> widgets;
    private Set<Item> items;
    private final HashSet<String> filterItems = new HashSet();
    private final List<SitemapSubscriptionService.SitemapSubscriptionCallback> callbacks = Collections.synchronizedList(new ArrayList());
    private Set<SitemapSubscriptionService.SitemapSubscriptionCallback> distinctCallbacks = Set.of();

    public WidgetsChangeListener(String sitemapName, String pageId, ItemUIRegistry itemUIRegistry, TimeZoneProvider timeZoneProvider, EList<Widget> widgets) {
        this.sitemapName = sitemapName;
        this.pageId = pageId;
        this.itemUIRegistry = itemUIRegistry;
        this.timeZoneProvider = timeZoneProvider;
        this.updateItemsAndWidgets(widgets);
    }

    private void updateItemsAndWidgets(EList<Widget> widgets) {
        this.widgets = widgets;
        this.items = this.getAllItems(widgets);
        this.filterItems.clear();
        this.filterItems.addAll(this.items.stream().map(Item::getName).collect(Collectors.toSet()));
    }

    public String getSitemapName() {
        return this.sitemapName;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void addCallback(SitemapSubscriptionService.SitemapSubscriptionCallback callback) {
        this.callbacks.add(callback);
        this.distinctCallbacks = new HashSet<SitemapSubscriptionService.SitemapSubscriptionCallback>(this.callbacks);
    }

    public void removeCallback(SitemapSubscriptionService.SitemapSubscriptionCallback callback) {
        this.callbacks.remove(callback);
        this.distinctCallbacks = new HashSet<SitemapSubscriptionService.SitemapSubscriptionCallback>(this.callbacks);
    }

    /*
     * WARNING - void declaration
     */
    private Set<Item> getAllItems(EList<Widget> widgets) {
        HashSet<Item> items = new HashSet<Item>();
        if (this.itemUIRegistry != null) {
            for (Widget widget : widgets) {
                this.addItemWithName(items, widget.getItem());
                Widget widget2 = widget;
                if (widget2 instanceof Frame) {
                    void frame;
                    Frame cfr_ignored_0 = (Frame)widget2;
                    Frame cfr_ignored_1 = (Frame)widget2;
                    items.addAll(this.getAllItems((EList<Widget>)frame.getChildren()));
                } else {
                    Widget widget3 = widget;
                    if (widget3 instanceof Buttongrid) {
                        void grid;
                        Buttongrid cfr_ignored_2 = (Buttongrid)widget3;
                        Buttongrid cfr_ignored_3 = (Buttongrid)widget3;
                        items.addAll(this.getAllItems((EList<Widget>)grid.getChildren()));
                    }
                }
                for (IconRule rule : widget.getIconRules()) {
                    this.addItemsFromConditions(items, (EList<Condition>)rule.getConditions());
                }
                for (IconRule rule : widget.getVisibility()) {
                    this.addItemsFromConditions(items, (EList<Condition>)rule.getConditions());
                }
                for (IconRule rule : widget.getLabelColor()) {
                    this.addItemsFromConditions(items, (EList<Condition>)rule.getConditions());
                }
                for (IconRule rule : widget.getValueColor()) {
                    this.addItemsFromConditions(items, (EList<Condition>)rule.getConditions());
                }
                for (IconRule rule : widget.getIconColor()) {
                    this.addItemsFromConditions(items, (EList<Condition>)rule.getConditions());
                }
            }
        }
        return items;
    }

    private void addItemsFromConditions(Set<Item> items, @Nullable EList<Condition> conditions) {
        if (conditions != null) {
            for (Condition condition : conditions) {
                this.addItemWithName(items, condition.getItem());
            }
        }
    }

    private void addItemWithName(Set<Item> items, String itemName) {
        if (itemName != null) {
            try {
                Item item = this.itemUIRegistry.getItem(itemName);
                items.add(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    private void constructAndSendEvents(Item item, State newState) {
        Set<SitemapEvent> events = this.constructSitemapEvents(item, newState, (List<Widget>)this.widgets);
        for (SitemapEvent event : events) {
            for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
                callback.onEvent(event);
            }
        }
    }

    public void keepCurrentState(Item item) {
        this.scheduler.schedule(() -> this.constructAndSendEvents(item, item.getState()), 300L, TimeUnit.MILLISECONDS);
    }

    public void changeStateTo(Item item, State state) {
        this.constructAndSendEvents(item, state);
    }

    /*
     * WARNING - void declaration
     */
    private Set<SitemapEvent> constructSitemapEvents(Item item, State state, List<Widget> widgets) {
        HashSet<SitemapEvent> events = new HashSet<SitemapEvent>();
        for (Widget w : widgets) {
            Widget widget;
            boolean skipWidget;
            Widget widget2 = w;
            if (widget2 instanceof Frame) {
                void frame;
                Frame cfr_ignored_0 = (Frame)widget2;
                Frame cfr_ignored_1 = (Frame)widget2;
                events.addAll(this.constructSitemapEvents(item, state, (List<Widget>)this.itemUIRegistry.getChildren((LinkableWidget)frame)));
            } else {
                Widget widget3 = w;
                if (widget3 instanceof Buttongrid) {
                    void grid;
                    Buttongrid cfr_ignored_2 = (Buttongrid)widget3;
                    Buttongrid cfr_ignored_3 = (Buttongrid)widget3;
                    events.addAll(this.constructSitemapEvents(item, state, (List<Widget>)this.itemUIRegistry.getChildren((LinkableWidget)grid)));
                }
            }
            boolean itemBelongsToWidget = w.getItem() != null && w.getItem().equals(item.getName());
            boolean bl = skipWidget = !itemBelongsToWidget;
            if (!skipWidget && (widget = w) instanceof Chart) {
                void chartWidget;
                Chart cfr_ignored_4 = (Chart)widget;
                Chart cfr_ignored_5 = (Chart)widget;
                boolean bl2 = skipWidget = chartWidget.getRefresh() > 0;
            }
            if (skipWidget && !this.definesVisibilityOrColorOrIcon(w, item.getName())) continue;
            SitemapWidgetEvent event = this.constructSitemapEventForWidget(item, state, w);
            events.add(event);
        }
        return events;
    }

    /*
     * WARNING - void declaration
     */
    private SitemapWidgetEvent constructSitemapEventForWidget(Item item, State state, Widget widget) {
        SitemapWidgetEvent event = new SitemapWidgetEvent();
        event.sitemapName = this.sitemapName;
        event.pageId = this.pageId;
        event.label = this.itemUIRegistry.getLabel(widget);
        event.labelSource = this.itemUIRegistry.getLabelSource(widget).toString();
        event.widgetId = this.itemUIRegistry.getWidgetId(widget);
        event.icon = this.itemUIRegistry.getCategory(widget);
        event.reloadIcon = widget.getStaticIcon() == null;
        Widget widget2 = widget;
        if (widget2 instanceof Button) {
            void buttonWidget;
            Button button = (Button)widget2;
            Button cfr_ignored_0 = (Button)widget2;
            if (widget.getIcon() == null && widget.getStaticIcon() == null && widget.getIconRules().isEmpty()) {
                event.icon = null;
                event.reloadIcon = false;
            }
            event.label = widget.getLabel() != null ? widget.getLabel() : buttonWidget.getCmd();
            event.labelSource = ItemUIRegistry.WidgetLabelSource.SITEMAP_WIDGET.toString();
        }
        event.visibility = this.itemUIRegistry.getVisiblity(widget);
        event.descriptionChanged = false;
        boolean itemBelongsToWidget = widget.getItem() != null && widget.getItem().equals(item.getName());
        Item itemToBeSent = itemBelongsToWidget ? item : this.getItemForWidget(widget);
        State stateToBeSent = null;
        if (itemToBeSent != null) {
            String widgetTypeName = widget.eClass().getInstanceTypeName().substring(widget.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
            boolean drillDown = "mapview".equalsIgnoreCase(widgetTypeName);
            Predicate<Item> itemFilter = i -> "Location".equals(i.getType());
            event.item = EnrichedItemDTOMapper.map((Item)itemToBeSent, (boolean)drillDown, itemFilter, null, null, (ZoneId)this.timeZoneProvider.getTimeZone());
            stateToBeSent = itemBelongsToWidget ? state : itemToBeSent.getState();
            event.state = this.itemUIRegistry.convertState(widget, itemToBeSent, stateToBeSent).toFullString();
            if (event.state != null && event.state.equals(event.item.state)) {
                event.state = null;
            }
        }
        event.labelcolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getLabelColor(widget), stateToBeSent);
        event.valuecolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getValueColor(widget), stateToBeSent);
        event.iconcolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getIconColor(widget), stateToBeSent);
        return event;
    }

    private Item getItemForWidget(Widget w) {
        String itemName = w.getItem();
        if (itemName != null) {
            try {
                return this.itemUIRegistry.getItem(itemName);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean definesVisibilityOrColorOrIcon(Widget w, String name) {
        return w.getVisibility().stream().anyMatch(r -> this.conditionsDependsOnItem((EList<Condition>)r.getConditions(), name)) || w.getLabelColor().stream().anyMatch(r -> this.conditionsDependsOnItem((EList<Condition>)r.getConditions(), name)) || w.getValueColor().stream().anyMatch(r -> this.conditionsDependsOnItem((EList<Condition>)r.getConditions(), name)) || w.getIconColor().stream().anyMatch(r -> this.conditionsDependsOnItem((EList<Condition>)r.getConditions(), name)) || w.getIconRules().stream().anyMatch(r -> this.conditionsDependsOnItem((EList<Condition>)r.getConditions(), name));
    }

    private boolean conditionsDependsOnItem(@Nullable EList<Condition> conditions, String name) {
        return conditions != null && conditions.stream().anyMatch(c -> name.equals(c.getItem()));
    }

    public void sitemapContentChanged(EList<Widget> widgets) {
        this.updateItemsAndWidgets(widgets);
        SitemapChangedEvent changeEvent = new SitemapChangedEvent();
        changeEvent.pageId = this.pageId;
        changeEvent.sitemapName = this.sitemapName;
        for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
            callback.onEvent(changeEvent);
        }
    }

    public void sendAliveEvent() {
        ServerAliveEvent aliveEvent = new ServerAliveEvent();
        aliveEvent.pageId = this.pageId;
        aliveEvent.sitemapName = this.sitemapName;
        for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
            callback.onEvent(aliveEvent);
        }
    }

    public void descriptionChanged(String itemName) {
        try {
            Item item = this.itemUIRegistry.getItem(itemName);
            Set<SitemapEvent> events = this.constructSitemapEventsForUpdatedDescr(item, (List<Widget>)this.widgets);
            for (SitemapEvent event : events) {
                for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
                    callback.onEvent(event);
                }
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<SitemapEvent> constructSitemapEventsForUpdatedDescr(Item item, List<Widget> widgets) {
        HashSet<SitemapEvent> events = new HashSet<SitemapEvent>();
        for (Widget w : widgets) {
            boolean itemBelongsToWidget;
            Widget widget = w;
            if (widget instanceof Frame) {
                void frame;
                Frame cfr_ignored_0 = (Frame)widget;
                Frame cfr_ignored_1 = (Frame)widget;
                events.addAll(this.constructSitemapEventsForUpdatedDescr(item, (List<Widget>)this.itemUIRegistry.getChildren((LinkableWidget)frame)));
            } else {
                Widget widget2 = w;
                if (widget2 instanceof Buttongrid) {
                    void grid;
                    Buttongrid cfr_ignored_2 = (Buttongrid)widget2;
                    Buttongrid cfr_ignored_3 = (Buttongrid)widget2;
                    events.addAll(this.constructSitemapEventsForUpdatedDescr(item, (List<Widget>)this.itemUIRegistry.getChildren((LinkableWidget)grid)));
                }
            }
            boolean bl = itemBelongsToWidget = w.getItem() != null && w.getItem().equals(item.getName());
            if (!itemBelongsToWidget) continue;
            SitemapWidgetEvent event = this.constructSitemapEventForWidget(item, item.getState(), w);
            event.descriptionChanged = true;
            events.add(event);
        }
        return events;
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ItemStateChangedEvent.TYPE, GroupStateUpdatedEvent.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ItemEvent) {
            void itemEvent;
            ItemEvent itemEvent2 = (ItemEvent)event2;
            ItemEvent cfr_ignored_0 = (ItemEvent)event2;
            if (this.filterItems.contains(itemEvent.getItemName())) {
                Item item = (Item)this.itemUIRegistry.get((Object)itemEvent.getItemName());
                if (item == null) {
                    return;
                }
                Event event3 = event;
                if (event3 instanceof GroupStateUpdatedEvent) {
                    void groupStateUpdatedEvent;
                    GroupStateUpdatedEvent groupStateUpdatedEvent2 = (GroupStateUpdatedEvent)event3;
                    GroupStateUpdatedEvent cfr_ignored_1 = (GroupStateUpdatedEvent)event3;
                    this.constructAndSendEvents(item, groupStateUpdatedEvent.getItemState());
                } else {
                    Event event4 = event;
                    if (event4 instanceof ItemStateChangedEvent) {
                        void itemStateChangedEvent;
                        ItemStateChangedEvent itemStateChangedEvent2 = (ItemStateChangedEvent)event4;
                        ItemStateChangedEvent cfr_ignored_2 = (ItemStateChangedEvent)event4;
                        this.constructAndSendEvents(item, itemStateChangedEvent.getItemState());
                    }
                }
            }
        }
    }
}

