/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.util;

import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.util.HexUtils;

@NonNullByDefault
public class UIDUtils {
    public static String encode(String value) {
        if (value.isEmpty()) {
            return value;
        }
        byte[] in = value.getBytes(StandardCharsets.UTF_8);
        byte[] out = new byte[in.length * 3];
        int opos = 0;
        int ipos = 0;
        while (ipos < in.length) {
            byte cur = in[ipos];
            if (cur >= 48 && cur <= 57 || cur >= 65 && cur <= 90 || cur >= 97 && cur <= 122) {
                out[opos] = cur;
            } else {
                out[opos++] = 95;
                byte[] hex = HexUtils.byteToHex(cur);
                out[opos++] = hex[0];
                out[opos] = hex[1];
            }
            ++ipos;
            ++opos;
        }
        return new String(out, 0, opos, StandardCharsets.UTF_8);
    }

    public static String decode(String value) {
        if (value.isEmpty()) {
            return value;
        }
        byte[] in = value.getBytes(StandardCharsets.UTF_8);
        byte[] out = new byte[in.length];
        int opos = 0;
        int ipos = 0;
        while (ipos < in.length) {
            byte cur = in[ipos];
            if (cur >= 48 && cur <= 57 || cur >= 65 && cur <= 90 || cur >= 97 && cur <= 122) {
                out[opos] = cur;
            } else if (cur == 95) {
                byte curHigh = in[++ipos];
                byte curLow = in[++ipos];
                out[opos] = HexUtils.hexToByte(curHigh, curLow);
            } else {
                throw new IllegalArgumentException("Invalid input");
            }
            ++ipos;
            ++opos;
        }
        return new String(out, 0, opos, StandardCharsets.UTF_8);
    }
}

