/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import de.escape.quincunx.gimmicks.BasicPaperFormat;
import de.escape.quincunx.gimmicks.LengthUnit;
import de.escape.quincunx.gimmicks.PaperFormat;
import de.escape.quincunx.gimmicks.PhysicalLength;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;

public class PostScriptGraphics
extends Graphics {
    public static final double DPI_RESOLUTION = 1200.0;
    public static final LengthUnit INTERNAL_DPI = new LengthUnit(LengthUnit.INCH.unitToMeter(8.333333333333334E-4), "internal DPI", "DPI");
    public static final double POSTSCRIPT_RESOLUTION = 72.0;
    public static final LengthUnit POSTSCRIPT_DOTS = new LengthUnit(LengthUnit.INCH.meterToUnit(0.013888888888888888), "Postscript dots", "dots");
    private static final String STDOUT_PATH = "-";
    private Paper paper;
    private PrintStream out;
    private boolean writingEPS;
    private String path;
    private Point insert;
    private Color color;
    private PostScriptGraphics parent;
    private boolean needsReInit;
    private Rectangle userClip;

    public static Rectangle getDrawingAreaOfPaper(PaperFormat paper) {
        return new Paper(paper).getDrawArea();
    }

    private PostScriptGraphics(PostScriptGraphics g) {
        this.parent = g;
        this.paper = g.paper;
        this.out = g.out;
        this.path = g.path;
        this.insert = new Point(g.insert.x, g.insert.y);
        this.color = g.color;
    }

    public PostScriptGraphics(String name, PrintStream outStream, PaperFormat paper) throws IOException {
        this(name, outStream, paper, null);
    }

    public PostScriptGraphics(String name, PrintStream outStream, PaperFormat paper, Rectangle bounds) throws IOException {
        this.paper = new Paper(paper);
        this.insert = new Point(0, 0);
        this.out = outStream;
        this.writingEPS = bounds != null;
        this.writePreamble(name, bounds);
    }

    public PostScriptGraphics(String name, String path, PaperFormat paper) throws IOException {
        this(name, path, paper, null);
    }

    public PostScriptGraphics(String name, String path, PaperFormat paper, Rectangle bounds) throws IOException {
        this(name, STDOUT_PATH.equals(path) ? System.out : new PrintStream(new FileOutputStream(path)), paper, bounds);
        this.path = path;
    }

    public PostScriptGraphics(String name, OutputStream outStream, PaperFormat paper) throws IOException {
        this(name, outStream, paper, null);
    }

    public PostScriptGraphics(String name, OutputStream outStream, PaperFormat paper, Rectangle bounds) throws IOException {
        this(name, new PrintStream(outStream, true), paper, bounds);
    }

    private void reinit() {
        this.needsReInit = true;
        if (this.parent != null) {
            this.parent.reinit();
        }
    }

    private void writePreamble(String name, Rectangle bounds) {
        if (bounds != null) {
            this.out.println("%!PS-Adobe-3.0 EPSF-3.0");
        } else {
            this.out.println("%!PS-Adobe-3.0");
        }
        this.out.println("%%Creator: PostScriptGraphics by rammi@caff.de");
        this.out.println("%%Title: (" + name + ")");
        if (bounds != null) {
            this.out.println("%%Pages: 1");
            this.out.println("%%BoundingBox: " + POSTSCRIPT_DOTS.otherToUnit(bounds.x, INTERNAL_DPI) + " " + POSTSCRIPT_DOTS.otherToUnit(bounds.y, INTERNAL_DPI) + " " + POSTSCRIPT_DOTS.otherToUnit(bounds.width, INTERNAL_DPI) + " " + POSTSCRIPT_DOTS.otherToUnit(bounds.height, INTERNAL_DPI));
            this.out.println("%%EndComments");
        } else {
            this.out.println("%%Page: 1");
        }
        this.print("initgraphics");
        Dimension dim = this.paper.getSize();
        Rectangle clip = this.paper.getDrawArea();
        double scaling = 0.06;
        this.out.println(scaling + " " + -scaling + " scale");
        this.print("translate", 0, -dim.height);
        this.print("initclip");
        this.print("newpath");
        this.print("moveto", clip.x, clip.y);
        this.print("lineto", clip.x + clip.width, clip.y);
        this.print("lineto", clip.x + clip.width, clip.y + clip.height);
        this.print("lineto", clip.x, clip.y + clip.height);
        this.print("closepath");
        this.print("clip");
        this.print("translate", clip.x, clip.y);
    }

    private void print(String cmd, int[] parameters) {
        if (this.needsReInit) {
            this.needsReInit = false;
            this.print("setrgbcolor", this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        }
        if (parameters != null) {
            int p = 0;
            while (p < parameters.length) {
                this.out.print(Integer.toString(parameters[p]));
                this.out.print(" ");
                ++p;
            }
        }
        this.out.println(cmd);
    }

    private void print(String cmd) {
        this.print(cmd, null);
    }

    private void print(String cmd, int param1) {
        this.print(cmd, new int[]{param1});
    }

    private void print(String cmd, int param1, int param2) {
        this.print(cmd, new int[]{param1, param2});
    }

    private void print(String cmd, int param1, int param2, int param3) {
        this.print(cmd, new int[]{param1, param2, param3});
    }

    private void print(String cmd, int param1, int param2, int param3, int param4) {
        this.print(cmd, new int[]{param1, param2, param3, param4});
    }

    public Graphics create() {
        return new PostScriptGraphics(this);
    }

    public void translate(int x, int y) {
        this.insert.x += x;
        this.insert.y += y;
    }

    public Color getColor() {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public void setColor(Color c) {
        if (c != null && !c.equals(this.color)) {
            this.color = new Color(c.getRed(), c.getGreen(), c.getBlue());
            if (this.parent != null) {
                this.parent.reinit();
            }
            this.print("setrgbcolor", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public Font getFont() {
        throw new RuntimeException("Fonts are not supported.");
    }

    public void setFont(Font font) {
        throw new RuntimeException("Fonts are not supported.");
    }

    public FontMetrics getFontMetrics(Font f) {
        throw new RuntimeException("Fonts are not supported.");
    }

    private void moveto(int px, int py) {
        this.print("moveto", px + this.insert.x, py + this.insert.y);
    }

    private void lineto(int px, int py) {
        this.print("lineto", px + this.insert.x, py + this.insert.y);
    }

    private void dotAt(int px, int py) {
        this.print("newpath");
        this.moveto(px, py);
        this.lineto(px + 1, py);
        this.lineto(px + 1, py + 1);
        this.lineto(px, py + 1);
        this.print("closepath");
        this.print("fill");
    }

    public Rectangle getClipBounds() {
        return this.userClip != null ? new Rectangle(this.userClip) : null;
    }

    public void clipRect(int x, int y, int width, int height) {
        if (this.userClip == null) {
            this.userClip = new Rectangle(x, y, width, height);
        } else {
            int xmin = Math.max(x, this.userClip.x);
            int ymin = Math.max(y, this.userClip.y);
            int xmax = Math.min(x + width, this.userClip.x + this.userClip.width);
            int ymax = Math.min(y + height, this.userClip.y + this.userClip.height);
            this.userClip = xmax <= xmin || ymax <= ymin ? new Rectangle(xmin, ymin, 0, 0) : new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        }
    }

    public void setClip(int x, int y, int width, int height) {
        this.userClip = new Rectangle(x, y, width, height);
    }

    public Shape getClip() {
        return this.userClip != null ? new Rectangle(this.userClip) : null;
    }

    public void setClip(Shape clip) {
        if (!(clip instanceof Rectangle)) {
            throw new RuntimeException("Arbitrary shapes are not supported for clipping");
        }
        Rectangle r = (Rectangle)clip;
        this.userClip = new Rectangle(r.x, r.y, r.width, r.height);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new RuntimeException("Area copying not supported");
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            this.dotAt(x1, y1);
        } else {
            this.print("newpath");
            this.moveto(x1, y1);
            this.lineto(x2, y2);
            this.print("stroke");
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        this.print("newpath");
        this.moveto(x, y);
        this.lineto(x + width, y);
        this.lineto(x + width, y + height);
        this.lineto(x, y + height);
        this.lineto(x, y);
        this.print("fill");
    }

    public void clearRect(int x, int y, int width, int height) {
        this.print("setrgbcolor", 255, 255, 255);
        this.print("newpath");
        this.moveto(x, y);
        this.lineto(x + width, y);
        this.lineto(x + width, y + height);
        this.lineto(x, y + height);
        this.lineto(x, y);
        this.print("fill");
        this.print("setrgbcolor", this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new RuntimeException("Round rectangles are not supported");
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new RuntimeException("Round rectangles are not supported");
    }

    public void drawOval(int x, int y, int width, int height) {
        throw new RuntimeException("Ovals are not supported");
    }

    public void fillOval(int x, int y, int width, int height) {
        throw new RuntimeException("Ovals are not supported");
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new RuntimeException("Arcs are not supported");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new RuntimeException("Arcs are not supported");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            this.print("newpath");
            if (nPoints == 1) {
                this.moveto(xPoints[0], yPoints[0]);
                this.lineto(xPoints[0], yPoints[0]);
            } else {
                this.moveto(xPoints[0], yPoints[0]);
                int p = 1;
                while (p < nPoints) {
                    this.lineto(xPoints[p], yPoints[p]);
                    ++p;
                }
            }
            this.print("stroke");
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            this.print("newpath");
            if (nPoints == 1) {
                this.moveto(xPoints[0], yPoints[0]);
                this.lineto(xPoints[0], yPoints[0]);
            } else {
                this.moveto(xPoints[0], yPoints[0]);
                int p = 1;
                while (p < nPoints) {
                    this.lineto(xPoints[p], yPoints[p]);
                    ++p;
                }
                this.lineto(xPoints[0], yPoints[0]);
            }
            this.print("stroke");
        }
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            this.print("newpath");
            if (nPoints == 1) {
                this.moveto(xPoints[0], yPoints[0]);
                this.lineto(xPoints[0], yPoints[0]);
            } else {
                this.moveto(xPoints[0], yPoints[0]);
                int p = 1;
                while (p < nPoints) {
                    this.lineto(xPoints[p], yPoints[p]);
                    ++p;
                }
                this.lineto(xPoints[0], yPoints[0]);
            }
            this.print("fill");
        }
    }

    public void drawString(String str, int x, int y) {
        throw new RuntimeException("String drawing not supported.");
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        throw new RuntimeException("Image drawing not supported.");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        throw new RuntimeException("Image drawing not supported.");
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("Image drawing not supported.");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("Image drawing not supported.");
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        throw new RuntimeException("Image drawing not supported.");
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("Image drawing not supported.");
    }

    public void dispose() {
        if (!this.writingEPS) {
            this.print("showpage");
        }
        this.out.close();
    }

    public static void main(String[] args) throws Exception {
        PostScriptGraphics g = new PostScriptGraphics("TEST", "test.ps", (PaperFormat)BasicPaperFormat.A4_PAPER_PORTRAIT);
        g.setColor(Color.yellow);
        Rectangle rect = g.paper.getDrawArea();
        g.fillRect(0, 0, rect.width, rect.height);
        g.setColor(Color.black);
        g.drawRect(0, 0, rect.width, rect.height);
        g.setColor(Color.blue);
        g.drawRect(1000, 1000, 1000, 1000);
        g.setColor(Color.red);
        g.fillRect(1250, 1250, 500, 500);
        int[] x = new int[]{2000, 3000, 2500, 3000, 3000};
        int[] y = new int[]{2000, 3000, 3000, 2500, 3000};
        g.setColor(Color.black);
        g.drawPolyline(x, y, x.length);
        g.dispose();
    }

    public Dimension getPageDimension() {
        Rectangle bounds = this.paper.getDrawArea();
        return new Dimension(bounds.width, bounds.height);
    }

    public int getPageResolution() {
        return 1200;
    }

    public Rectangle getDrawArea() {
        return this.paper.getDrawArea();
    }

    public static class Paper
    implements Serializable,
    PaperFormat {
        private int width;
        private int height;
        private int leftMargin;
        private int rightMargin;
        private int topMargin;
        private int bottomMargin;

        public Paper(PhysicalLength width, PhysicalLength height, PhysicalLength margin) {
            this(Paper.physicalLengthToInternal(width), Paper.physicalLengthToInternal(height), Paper.physicalLengthToInternal(margin));
        }

        public Paper(int width, int height, int margin) {
            this(width, height, margin, margin, margin, margin);
        }

        public Paper(PhysicalLength width, PhysicalLength height, PhysicalLength leftMargin, PhysicalLength rightMargin, PhysicalLength topMargin, PhysicalLength bottomMargin) {
            this(Paper.physicalLengthToInternal(width), Paper.physicalLengthToInternal(height), Paper.physicalLengthToInternal(leftMargin), Paper.physicalLengthToInternal(rightMargin), Paper.physicalLengthToInternal(topMargin), Paper.physicalLengthToInternal(bottomMargin));
        }

        public Paper(int width, int height, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
            this.width = width;
            this.height = height;
            this.setMargins(leftMargin, rightMargin, topMargin, bottomMargin);
        }

        public Paper(Paper paper) {
            this(paper.width, paper.height, paper.leftMargin, paper.rightMargin, paper.topMargin, paper.bottomMargin);
        }

        public Paper(PaperFormat pf) {
            this(pf.getWidth(), pf.getHeight(), pf.getLeftMargin(), pf.getRightMargin(), pf.getTopMargin(), pf.getBottomMargin());
        }

        private static int physicalLengthToInternal(PhysicalLength length) {
            return (int)(length.getLength(INTERNAL_DPI) + 0.5);
        }

        public void setMargins(PhysicalLength margin) {
            this.setMargins(Paper.physicalLengthToInternal(margin));
        }

        public void setMargins(int margin) {
            this.topMargin = this.bottomMargin = margin;
            this.rightMargin = this.bottomMargin;
            this.leftMargin = this.bottomMargin;
        }

        public void setMargins(PhysicalLength leftMargin, PhysicalLength rightMargin, PhysicalLength topMargin, PhysicalLength bottomMargin) {
            this.setMargins(Paper.physicalLengthToInternal(leftMargin), Paper.physicalLengthToInternal(rightMargin), Paper.physicalLengthToInternal(topMargin), Paper.physicalLengthToInternal(bottomMargin));
        }

        public void setMargins(int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
            this.leftMargin = leftMargin;
            this.rightMargin = rightMargin;
            this.topMargin = topMargin;
            this.bottomMargin = bottomMargin;
        }

        public Dimension getSize() {
            return new Dimension(this.width, this.height);
        }

        public Rectangle getDrawArea() {
            return new Rectangle(this.leftMargin, this.topMargin, this.width - this.leftMargin - this.rightMargin, this.height - this.topMargin - this.bottomMargin);
        }

        public PhysicalLength getWidth() {
            return new PhysicalLength(this.width, INTERNAL_DPI);
        }

        public PhysicalLength getHeight() {
            return new PhysicalLength(this.height, INTERNAL_DPI);
        }

        public PhysicalLength getLeftMargin() {
            return new PhysicalLength(this.leftMargin, INTERNAL_DPI);
        }

        public PhysicalLength getRightMargin() {
            return new PhysicalLength(this.rightMargin, INTERNAL_DPI);
        }

        public PhysicalLength getTopMargin() {
            return new PhysicalLength(this.topMargin, INTERNAL_DPI);
        }

        public PhysicalLength getBottomMargin() {
            return new PhysicalLength(this.bottomMargin, INTERNAL_DPI);
        }

        public String getName() {
            return null;
        }
    }
}

