/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.app.tools.android.BadSDKException;
import processing.core.PApplet;

class AndroidSDK {
    private final File sdk;
    private final File tools;
    private final File androidTool;
    private static final String ANDROID_SDK_PRIMARY = "Is the Android SDK installed?";
    private static final String ANDROID_SDK_SECONDARY = "The Android SDK does not appear to be installed, <br>because the ANDROID_SDK variable is not set. <br>If it is installed, click \u201cYes\u201d to select the <br>location of the SDK, or \u201cNo\u201d to visit the SDK<br>download site at http://developer.android.com/sdk.";
    private static final String SELECT_ANDROID_SDK_FOLDER = "Choose the location of the Android SDK";
    private static final String NOT_ANDROID_SDK = "The selected folder does not appear to contain an Android SDK.";
    private static final String ANDROID_SDK_URL = "http://developer.android.com/sdk/";
    private static final String ADB_DAEMON_MSG_1 = "daemon not running";
    private static final String ADB_DAEMON_MSG_2 = "daemon started successfully";

    public AndroidSDK(String string) throws BadSDKException, IOException {
        this.sdk = new File(string);
        if (!this.sdk.exists()) {
            throw new BadSDKException(this.sdk + " does not exist");
        }
        this.tools = new File(this.sdk, "tools");
        if (!this.tools.exists()) {
            throw new BadSDKException("There is no tools folder in " + this.sdk);
        }
        this.androidTool = AndroidSDK.findAndroidTool(this.tools);
        Platform platform = Base.getPlatform();
        String string2 = platform.getenv("PATH");
        platform.setenv("ANDROID_SDK", this.sdk.getCanonicalPath());
        string2 = this.tools.getCanonicalPath() + File.pathSeparator + string2;
        String string3 = System.getProperty("java.home");
        if (string3 == null) {
            throw new RuntimeException("I don't know how to deal with a null java.home proprty, to be quite frank.");
        }
        File file = new File(string3).getCanonicalFile();
        platform.setenv("JAVA_HOME", file.getCanonicalPath());
        string2 = new File(file, "bin").getCanonicalPath() + File.pathSeparator + string2;
        platform.setenv("PATH", string2);
    }

    public File getAndroidTool() {
        return this.androidTool;
    }

    public String getAndroidToolPath() {
        return this.androidTool.getAbsolutePath();
    }

    public File getSdkFolder() {
        return this.sdk;
    }

    public File getToolsFolder() {
        return this.tools;
    }

    private static File findAndroidTool(File file) throws BadSDKException {
        if (new File(file, "android.exe").exists()) {
            return new File(file, "android.exe");
        }
        if (new File(file, "android.bat").exists()) {
            return new File(file, "android.bat");
        }
        if (new File(file, "android").exists()) {
            return new File(file, "android");
        }
        throw new BadSDKException("Cannot find the android tool in " + file);
    }

    public static AndroidSDK find(Frame frame) throws BadSDKException, IOException {
        int n;
        String string;
        Platform platform = Base.getPlatform();
        String string2 = platform.getenv("ANDROID_SDK");
        if (string2 != null) {
            try {
                AndroidSDK androidSDK = new AndroidSDK(string2);
                Preferences.set("android.sdk.path", string2);
                return androidSDK;
            }
            catch (BadSDKException badSDKException) {
                // empty catch block
            }
        }
        if ((string = Preferences.get("android.sdk.path")) != null) {
            try {
                AndroidSDK androidSDK = new AndroidSDK(string);
                Preferences.set("android.sdk.path", string);
                return androidSDK;
            }
            catch (BadSDKException badSDKException) {
                Preferences.unset("android.sdk.path");
            }
        }
        if ((n = Base.showYesNoQuestion(frame, "Android SDK", ANDROID_SDK_PRIMARY, ANDROID_SDK_SECONDARY)) == 2) {
            throw new BadSDKException("User cancelled attempt to find SDK.");
        }
        if (n == 1) {
            Base.openURL(ANDROID_SDK_URL);
            throw new BadSDKException("No SDK installed.");
        }
        while (true) {
            File file;
            if ((file = Base.selectFolder(SELECT_ANDROID_SDK_FOLDER, null, frame)) == null) {
                throw new BadSDKException("User cancelled attempt to find SDK.");
            }
            String string3 = file.getAbsolutePath();
            try {
                AndroidSDK androidSDK = new AndroidSDK(string3);
                Preferences.set("android.sdk.path", string3);
                return androidSDK;
            }
            catch (BadSDKException badSDKException) {
                JOptionPane.showMessageDialog(frame, NOT_ANDROID_SDK);
                continue;
            }
            break;
        }
    }

    public static ProcessResult runADB(String ... stringArray) throws InterruptedException, IOException {
        String[] stringArray2 = !stringArray[0].equals("adb") ? PApplet.splice((String[])stringArray, (String)"adb", (int)0) : stringArray;
        ProcessResult processResult = new ProcessHelper(stringArray2).execute();
        String string = processResult.getStdout();
        if (string.contains(ADB_DAEMON_MSG_1) && string.contains(ADB_DAEMON_MSG_2)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : string.split("\n")) {
                if (string.contains(ADB_DAEMON_MSG_1) || string.contains(ADB_DAEMON_MSG_2)) continue;
                stringBuilder.append(string2).append("\n");
            }
            return new ProcessResult(processResult.getCmd(), processResult.getResult(), stringBuilder.toString(), processResult.getStderr(), processResult.getTime());
        }
        return processResult;
    }
}

