# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("certpoleng.dll")
prototypes = \
    {
        #
        'PstGetTrustAnchors': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CERT_SELECT_CRITERIA_TYPE"), "cPara": SimTypeInt(signed=False, label="UInt32"), "ppPara": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CERT_SELECT_CRITERIA", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimStruct({"aIssuers": SimTypePointer(SimTypeBottom(label="CRYPTOAPI_BLOB"), offset=0), "cIssuers": SimTypeInt(signed=False, label="UInt32")}, name="SecPkgContext_IssuerListInfoEx", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTargetName", "cCriteria", "rgpCriteria", "ppTrustedIssuers"]),
        #
        'PstGetTrustAnchorsEx': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CERT_SELECT_CRITERIA_TYPE"), "cPara": SimTypeInt(signed=False, label="UInt32"), "ppPara": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CERT_SELECT_CRITERIA", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"aIssuers": SimTypePointer(SimTypeBottom(label="CRYPTOAPI_BLOB"), offset=0), "cIssuers": SimTypeInt(signed=False, label="UInt32")}, name="SecPkgContext_IssuerListInfoEx", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTargetName", "cCriteria", "rgpCriteria", "pCertContext", "ppTrustedIssuers"]),
        #
        'PstGetCertificateChain': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"aIssuers": SimTypePointer(SimTypeBottom(label="CRYPTOAPI_BLOB"), offset=0), "cIssuers": SimTypeInt(signed=False, label="UInt32")}, name="SecPkgContext_IssuerListInfoEx", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert", "pTrustedIssuers", "ppCertChainContext"]),
        #
        'PstGetCertificates': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="CERT_SELECT_CRITERIA_TYPE"), "cPara": SimTypeInt(signed=False, label="UInt32"), "ppPara": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="CERT_SELECT_CRITERIA", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTargetName", "cCriteria", "rgpCriteria", "bIsClient", "pdwCertChainContextCount", "ppCertChainContexts"]),
        #
        'PstAcquirePrivateKey': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert"]),
        #
        'PstValidate': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Usage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None)}, name="CERT_USAGE_MATCH", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pTargetName", "bIsClient", "pRequestedIssuancePolicy", "phAdditionalCertStore", "pCert", "pProvGUID"]),
        #
        'PstMapCertificate': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="LSA_TOKEN_INFORMATION_TYPE"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCert", "pTokenInformationType", "ppTokenInformation"]),
        #
        'PstGetUserNameForCertificate': SimTypeFunction([SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCertContext", "UserName"]),
    }

lib.set_prototypes(prototypes)
