# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("traffic.dll")
prototypes = \
    {
        #
        'TcRegisterClient': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ClNotifyHandler": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ClRegCtx", "ClIfcCtx", "Event", "SubCode", "BufSize", "Buffer"]), offset=0), "ClAddFlowCompleteHandler": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ClFlowCtx", "Status"]), offset=0), "ClModifyFlowCompleteHandler": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ClFlowCtx", "Status"]), offset=0), "ClDeleteFlowCompleteHandler": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ClFlowCtx", "Status"]), offset=0)}, name="TCI_CLIENT_FUNC_LIST", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TciVersion", "ClRegCtx", "ClientHandlerList", "pClientHandle"]),
        #
        'TcEnumerateInterfaces': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "pInterfaceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pInterfaceID": SimTypePointer(SimTypeChar(label="Char"), offset=0), "AddressListDesc": SimStruct({"MediaType": SimTypeInt(signed=False, label="UInt32"), "AddressList": SimStruct({"AddressCount": SimTypeInt(signed=True, label="Int32"), "AddressType": SimTypeShort(signed=False, label="UInt16"), "Address": SimTypePointer(SimStruct({"AddressLength": SimTypeShort(signed=False, label="UInt16"), "AddressType": SimTypeShort(signed=False, label="UInt16"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="NETWORK_ADDRESS", pack=False, align=None), offset=0)}, name="NETWORK_ADDRESS_LIST", pack=False, align=None)}, name="ADDRESS_LIST_DESCRIPTOR", pack=False, align=None)}, name="TC_IFC_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ClientHandle", "pBufferSize", "InterfaceBuffer"]),
        #
        'TcOpenInterfaceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterfaceName", "ClientHandle", "ClIfcCtx", "pIfcHandle"]),
        #
        'TcOpenInterfaceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInterfaceName", "ClientHandle", "ClIfcCtx", "pIfcHandle"]),
        #
        'TcCloseInterface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["IfcHandle"]),
        #
        'TcQueryInterface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["IfcHandle", "pGuidParam", "NotifyChange", "pBufferSize", "Buffer"]),
        #
        'TcSetInterface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["IfcHandle", "pGuidParam", "BufferSize", "Buffer"]),
        #
        'TcQueryFlowA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pFlowName", "pGuidParam", "pBufferSize", "Buffer"]),
        #
        'TcQueryFlowW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pFlowName", "pGuidParam", "pBufferSize", "Buffer"]),
        #
        'TcSetFlowA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pFlowName", "pGuidParam", "BufferSize", "Buffer"]),
        #
        'TcSetFlowW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pFlowName", "pGuidParam", "BufferSize", "Buffer"]),
        #
        'TcAddFlow': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "TcObjectsLength": SimTypeInt(signed=False, label="UInt32"), "TcObjects": SimTypePointer(SimStruct({"ObjectType": SimTypeInt(signed=False, label="UInt32"), "ObjectLength": SimTypeInt(signed=False, label="UInt32")}, name="QOS_OBJECT_HDR", pack=False, align=None), offset=0)}, name="TC_GEN_FLOW", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["IfcHandle", "ClFlowCtx", "Flags", "pGenericFlow", "pFlowHandle"]),
        #
        'TcGetFlowNameA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["FlowHandle", "StrSize", "pFlowName"]),
        #
        'TcGetFlowNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["FlowHandle", "StrSize", "pFlowName"]),
        #
        'TcModifyFlow': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "TcObjectsLength": SimTypeInt(signed=False, label="UInt32"), "TcObjects": SimTypePointer(SimStruct({"ObjectType": SimTypeInt(signed=False, label="UInt32"), "ObjectLength": SimTypeInt(signed=False, label="UInt32")}, name="QOS_OBJECT_HDR", pack=False, align=None), offset=0)}, name="TC_GEN_FLOW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["FlowHandle", "pGenericFlow"]),
        #
        'TcAddFilter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"AddressType": SimTypeShort(signed=False, label="UInt16"), "PatternSize": SimTypeInt(signed=False, label="UInt32"), "Pattern": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Mask": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="TC_GEN_FILTER", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["FlowHandle", "pGenericFilter", "pFilterHandle"]),
        #
        'TcDeregisterClient': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ClientHandle"]),
        #
        'TcDeleteFlow': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["FlowHandle"]),
        #
        'TcDeleteFilter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["FilterHandle"]),
        #
        'TcEnumerateFlows': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "OwnerProcessId": SimTypeInt(signed=False, label="UInt32"), "FlowNameLength": SimTypeShort(signed=False, label="UInt16"), "FlowName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "pFlow": SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "TcObjectsLength": SimTypeInt(signed=False, label="UInt32"), "TcObjects": SimTypePointer(SimStruct({"ObjectType": SimTypeInt(signed=False, label="UInt32"), "ObjectLength": SimTypeInt(signed=False, label="UInt32")}, name="QOS_OBJECT_HDR", pack=False, align=None), offset=0)}, name="TC_GEN_FLOW", pack=False, align=None), offset=0), "NumberOfFilters": SimTypeInt(signed=False, label="UInt32"), "GenericFilter": SimTypePointer(SimStruct({"AddressType": SimTypeShort(signed=False, label="UInt16"), "PatternSize": SimTypeInt(signed=False, label="UInt32"), "Pattern": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Mask": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="TC_GEN_FILTER", pack=False, align=None), offset=0)}, name="ENUMERATION_BUFFER", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["IfcHandle", "pEnumHandle", "pFlowCount", "pBufSize", "Buffer"]),
    }

lib.set_prototypes(prototypes)
