# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class DBRPCreate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'org': 'str',
        'org_id': 'str',
        'bucket_id': 'str',
        'database': 'str',
        'retention_policy': 'str',
        'default': 'bool'
    }

    attribute_map = {
        'org': 'org',
        'org_id': 'orgID',
        'bucket_id': 'bucketID',
        'database': 'database',
        'retention_policy': 'retention_policy',
        'default': 'default'
    }

    def __init__(self, org=None, org_id=None, bucket_id=None, database=None, retention_policy=None, default=None):  # noqa: E501,D401,D403
        """DBRPCreate - a model defined in OpenAPI."""  # noqa: E501
        self._org = None
        self._org_id = None
        self._bucket_id = None
        self._database = None
        self._retention_policy = None
        self._default = None
        self.discriminator = None

        if org is not None:
            self.org = org
        if org_id is not None:
            self.org_id = org_id
        self.bucket_id = bucket_id
        self.database = database
        self.retention_policy = retention_policy
        if default is not None:
            self.default = default

    @property
    def org(self):
        """Get the org of this DBRPCreate.

        An organization name. Identifies the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) that owns the mapping.

        :return: The org of this DBRPCreate.
        :rtype: str
        """  # noqa: E501
        return self._org

    @org.setter
    def org(self, org):
        """Set the org of this DBRPCreate.

        An organization name. Identifies the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) that owns the mapping.

        :param org: The org of this DBRPCreate.
        :type: str
        """  # noqa: E501
        self._org = org

    @property
    def org_id(self):
        """Get the org_id of this DBRPCreate.

        An organization ID. Identifies the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) that owns the mapping.

        :return: The org_id of this DBRPCreate.
        :rtype: str
        """  # noqa: E501
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Set the org_id of this DBRPCreate.

        An organization ID. Identifies the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) that owns the mapping.

        :param org_id: The org_id of this DBRPCreate.
        :type: str
        """  # noqa: E501
        self._org_id = org_id

    @property
    def bucket_id(self):
        """Get the bucket_id of this DBRPCreate.

        A bucket ID. Identifies the bucket used as the target for the translation.

        :return: The bucket_id of this DBRPCreate.
        :rtype: str
        """  # noqa: E501
        return self._bucket_id

    @bucket_id.setter
    def bucket_id(self, bucket_id):
        """Set the bucket_id of this DBRPCreate.

        A bucket ID. Identifies the bucket used as the target for the translation.

        :param bucket_id: The bucket_id of this DBRPCreate.
        :type: str
        """  # noqa: E501
        if bucket_id is None:
            raise ValueError("Invalid value for `bucket_id`, must not be `None`")  # noqa: E501
        self._bucket_id = bucket_id

    @property
    def database(self):
        """Get the database of this DBRPCreate.

        A database name. Identifies the InfluxDB v1 database.

        :return: The database of this DBRPCreate.
        :rtype: str
        """  # noqa: E501
        return self._database

    @database.setter
    def database(self, database):
        """Set the database of this DBRPCreate.

        A database name. Identifies the InfluxDB v1 database.

        :param database: The database of this DBRPCreate.
        :type: str
        """  # noqa: E501
        if database is None:
            raise ValueError("Invalid value for `database`, must not be `None`")  # noqa: E501
        self._database = database

    @property
    def retention_policy(self):
        """Get the retention_policy of this DBRPCreate.

        A [retention policy](https://docs.influxdata.com/influxdb/v1.8/concepts/glossary/#retention-policy-rp) name. Identifies the InfluxDB v1 retention policy mapping.

        :return: The retention_policy of this DBRPCreate.
        :rtype: str
        """  # noqa: E501
        return self._retention_policy

    @retention_policy.setter
    def retention_policy(self, retention_policy):
        """Set the retention_policy of this DBRPCreate.

        A [retention policy](https://docs.influxdata.com/influxdb/v1.8/concepts/glossary/#retention-policy-rp) name. Identifies the InfluxDB v1 retention policy mapping.

        :param retention_policy: The retention_policy of this DBRPCreate.
        :type: str
        """  # noqa: E501
        if retention_policy is None:
            raise ValueError("Invalid value for `retention_policy`, must not be `None`")  # noqa: E501
        self._retention_policy = retention_policy

    @property
    def default(self):
        """Get the default of this DBRPCreate.

        Set to `true` to use this DBRP mapping as the default retention policy for the database (specified by the `database` property's value).

        :return: The default of this DBRPCreate.
        :rtype: bool
        """  # noqa: E501
        return self._default

    @default.setter
    def default(self, default):
        """Set the default of this DBRPCreate.

        Set to `true` to use this DBRP mapping as the default retention policy for the database (specified by the `database` property's value).

        :param default: The default of this DBRPCreate.
        :type: bool
        """  # noqa: E501
        self._default = default

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, DBRPCreate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
