'''OpenGL extension SGIX.igloo_interface

This module customises the behaviour of the 
OpenGL.raw.GL.SGIX.igloo_interface to provide a more 
Python-friendly API

Overview (from the spec)
	
	This is an SGI internal (e.g. not documented or intended to be used
	directly by applications) extension used only to help support
	emulation of IrisGL through OpenGL.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/igloo_interface.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.SGIX.igloo_interface import *
from OpenGL.raw.GL.SGIX.igloo_interface import _EXTENSION_NAME

def glInitIglooInterfaceSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glIglooInterfaceSGIX.params size not checked against 'pname'
glIglooInterfaceSGIX=wrapper.wrapper(glIglooInterfaceSGIX).setInputArraySize(
    'params', None
)
### END AUTOGENERATED SECTION