'''OpenGL extension QCOM.ycbcr_degamma

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.ycbcr_degamma to provide a more 
Python-friendly API

Overview (from the spec)
	
	The OpenGL ES extensions OES_EGL_image_external and EXT_EGL_image_storage provide a mechanism for creating
	GL textures sharing storage with EGLImage objects which can encapsulate an external YCbCr buffer.
	The YCbCr data is stored according to the colorspace standards like ITU BT.601, BT.709, or BT.2020,
	and a transfer function like ITU OETF or sRGB EOTF, which translates the YCbCr data into non-linear space Y'CbCr.
	When sampling a Y'CbCr texture containing texels encoded, the conversion back to linear RGB requires
	conversion from non-linear RGB space to linear RGB space using an inverse transfer function.
	This operation of applying the inverse transfer function is also called "degamma".
	Currently, degamma operation is not executed as part of texture sampling, and instead
	application's shader code is expected to perform it separately. This computation can be somewhat expensive in the shader.
	
	This extension allows implementations to use "sRGB EOTF" inverse transform function defined in Khronos
	data format 1.3 specification, for degamma operation. The degamma is performed during texture filtering,
	allowing texture filtering to operate in a linear space. The extension provides this functionality by
	selectively enabling degamma for both the luminance{Y} and/or chrominance {CbCr} components of any
	8 bit YCbCr format.
	This new functionality is layered on top of the OES_EGL_image_external and EXT_EGL_image_storage
	extensions.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/ycbcr_degamma.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.ycbcr_degamma import *
from OpenGL.raw.GLES2.QCOM.ycbcr_degamma import _EXTENSION_NAME

def glInitYcbcrDegammaQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION