/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.Graphics2DImagePainter;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.java2d.FontMetricsMapper;
import org.apache.fop.render.java2d.FontSetup;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.fop.render.pcl.PCLGenerator;
import org.apache.fop.render.pcl.PCLGraphics2DAdapter;
import org.apache.fop.render.pcl.PCLPageDefinition;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.util.QName;
import org.apache.fop.util.UnitConv;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;

public class PCLRenderer
extends PrintRenderer {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$pcl$PCLRenderer == null ? (class$org$apache$fop$render$pcl$PCLRenderer = PCLRenderer.class$("org.apache.fop.render.pcl.PCLRenderer")) : class$org$apache$fop$render$pcl$PCLRenderer));
    public static final String MIME_TYPE = "application/vnd.hp-PCL";
    private static final QName CONV_MODE = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "conversion-mode");
    private static final QName SRC_TRANSPARENCY = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "source-transparency");
    protected OutputStream out;
    protected PCLGenerator gen;
    private boolean ioTrouble = false;
    private Stack graphicContextStack = new Stack();
    private GraphicContext graphicContext = new GraphicContext();
    private PCLPageDefinition currentPageDefinition;
    private int currentPrintDirection = 0;
    private GeneralPath currentPath = null;
    private Color currentFillColor = null;
    private boolean qualityBeforeSpeed = false;
    private boolean allTextAsBitmaps = false;
    static /* synthetic */ Class class$org$apache$fop$render$pcl$PCLRenderer;

    public void configure(Configuration cfg) throws ConfigurationException {
        super.configure(cfg);
        String rendering = cfg.getChild("rendering").getValue(null);
        if ("quality".equalsIgnoreCase(rendering)) {
            this.qualityBeforeSpeed = true;
        } else if ("speed".equalsIgnoreCase(rendering)) {
            this.qualityBeforeSpeed = false;
        } else if (rendering != null) {
            throw new ConfigurationException("Valid values for 'rendering' are 'quality' and 'speed'. Value found: " + rendering);
        }
        String textRendering = cfg.getChild("text-rendering").getValue(null);
        if ("bitmap".equalsIgnoreCase(textRendering)) {
            this.allTextAsBitmaps = true;
        } else if ("auto".equalsIgnoreCase(textRendering)) {
            this.allTextAsBitmaps = false;
        } else if (textRendering != null) {
            throw new ConfigurationException("Valid values for 'text-rendering' are 'auto' and 'bitmap'. Value found: " + textRendering);
        }
    }

    public void setupFontInfo(FontInfo inFontInfo) {
        this.fontInfo = inFontInfo;
        BufferedImage fontImage = new BufferedImage(100, 100, 1);
        Graphics2D g = fontImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontSetup.setup(this.fontInfo, g);
    }

    protected void handleIOTrouble(IOException ioe) {
        if (!this.ioTrouble) {
            log.error((Object)"Error while writing to target file", (Throwable)ioe);
            this.ioTrouble = true;
        }
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new PCLGraphics2DAdapter();
    }

    public GraphicContext getGraphicContext() {
        return this.graphicContext;
    }

    protected int getResolution() {
        int resolution = Math.round(this.userAgent.getTargetResolution());
        if (resolution <= 300) {
            return 300;
        }
        return 600;
    }

    public boolean setFont(String name, float size, String text) throws IOException {
        byte[] encoded = text.getBytes("ISO-8859-1");
        int c = encoded.length;
        for (int i = 0; i < c; ++i) {
            if (encoded[i] != 63 || text.charAt(i) == '?') continue;
            return false;
        }
        int fontcode = 0;
        if (name.length() > 1 && name.charAt(0) == 'F') {
            try {
                fontcode = Integer.parseInt(name.substring(1));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        String formattedSize = this.gen.formatDouble2(size / 1000.0f);
        switch (fontcode) {
            case 1: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v0s0b16602T");
                break;
            }
            case 2: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v1s0b16602T");
                break;
            }
            case 3: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v0s3b16602T");
                break;
            }
            case 4: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v1s3b16602T");
                break;
            }
            case 5: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v0s0b16901T");
                break;
            }
            case 6: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v1s0b16901T");
                break;
            }
            case 7: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v0s3b16901T");
                break;
            }
            case 8: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s1p" + formattedSize + "v1s3b16901T");
                break;
            }
            case 9: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s0p" + this.gen.formatDouble2(120.01f / (size / 1000.0f)) + "h0s0b4099T");
                break;
            }
            case 10: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s0p" + this.gen.formatDouble2(120.01f / (size / 1000.0f)) + "h1s0b4099T");
                break;
            }
            case 11: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s0p" + this.gen.formatDouble2(120.01f / (size / 1000.0f)) + "h0s3b4099T");
                break;
            }
            case 12: {
                this.gen.writeCommand("(0N");
                this.gen.writeCommand("(s0p" + this.gen.formatDouble2(120.01f / (size / 1000.0f)) + "h1s3b4099T");
                break;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.debug((Object)"Rendering areas to PCL...");
        this.out = outputStream;
        this.gen = new PCLGenerator(this.out, this.getResolution());
        this.gen.universalEndOfLanguage();
        this.gen.writeText("@PJL COMMENT Produced by " + this.userAgent.getProducer() + "\n");
        if (this.userAgent.getTitle() != null) {
            this.gen.writeText("@PJL JOB NAME = \"" + this.userAgent.getTitle() + "\"\n");
        }
        this.gen.writeText("@PJL SET RESOLUTION = " + this.getResolution() + "\n");
        this.gen.writeText("@PJL ENTER LANGUAGE = PCL\n");
        this.gen.resetPrinter();
        this.gen.setUnitOfMeasure(this.getResolution());
        this.gen.setRasterGraphicsResolution(this.getResolution());
    }

    public void stopRenderer() throws IOException {
        this.gen.separateJobs();
        this.gen.resetPrinter();
        this.gen.universalEndOfLanguage();
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        this.saveGraphicsState();
        String paperSource = page.getForeignAttributeValue(new QName("http://xmlgraphics.apache.org/fop/extensions/pcl", null, "paper-source"));
        if (paperSource != null) {
            this.gen.selectPaperSource(Integer.parseInt(paperSource));
        }
        long pagewidth = Math.round(page.getViewArea().getWidth());
        long pageheight = Math.round(page.getViewArea().getHeight());
        this.selectPageFormat(pagewidth, pageheight);
        super.renderPage(page);
        this.gen.formFeed();
        this.restoreGraphicsState();
    }

    private void selectPageFormat(long pagewidth, long pageheight) throws IOException {
        this.currentPageDefinition = PCLPageDefinition.getPageDefinition(pagewidth, pageheight, 1000);
        if (this.currentPageDefinition == null) {
            this.currentPageDefinition = PCLPageDefinition.getDefaultPageDefinition();
            log.warn((Object)("Paper type could not be determined. Falling back to: " + this.currentPageDefinition.getName()));
        }
        log.debug((Object)("page size: " + this.currentPageDefinition.getPhysicalPageSize()));
        log.debug((Object)("logical page: " + this.currentPageDefinition.getLogicalPageRect()));
        if (this.currentPageDefinition.isLandscapeFormat()) {
            this.gen.writeCommand("&l1O");
        } else {
            this.gen.writeCommand("&l0O");
        }
        this.gen.selectPageSize(this.currentPageDefinition.getSelector());
        this.gen.clearHorizontalMargins();
        this.gen.setTopMargin(0);
    }

    protected void saveGraphicsState() {
        this.graphicContextStack.push(this.graphicContext);
        this.graphicContext = (GraphicContext)this.graphicContext.clone();
    }

    protected void restoreGraphicsState() {
        this.graphicContext = (GraphicContext)this.graphicContextStack.pop();
    }

    protected void clipRect(float x, float y, float width, float height) {
    }

    private Point2D transformedPoint(float x, float y) {
        return this.transformedPoint(Math.round(x), Math.round(y));
    }

    private Point2D transformedPoint(int x, int y) {
        AffineTransform at = this.graphicContext.getTransform();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Current transform: " + at));
        }
        Point2D.Float orgPoint = new Point2D.Float(x, y);
        Point2D.Float transPoint = new Point2D.Float();
        at.transform(orgPoint, transPoint);
        Dimension pageSize = this.currentPageDefinition.getPhysicalPageSize();
        Rectangle logRect = this.currentPageDefinition.getLogicalPageRect();
        switch (this.currentPrintDirection) {
            case 0: {
                transPoint.x -= (float)logRect.x;
                transPoint.y -= (float)logRect.y;
                break;
            }
            case 90: {
                float ty = transPoint.x;
                transPoint.x = (float)pageSize.height - transPoint.y;
                transPoint.y = ty;
                transPoint.x -= (float)logRect.y;
                transPoint.y -= (float)logRect.x;
                break;
            }
            case 180: {
                transPoint.x = (float)pageSize.width - transPoint.x;
                transPoint.y = (float)pageSize.height - transPoint.y;
                transPoint.x -= (float)(pageSize.width - logRect.x - logRect.width);
                transPoint.y -= (float)(pageSize.height - logRect.y - logRect.height);
                transPoint.y = (float)((double)transPoint.y - UnitConv.in2mpt(0.5));
                break;
            }
            case 270: {
                float tx = transPoint.y;
                transPoint.y = (float)pageSize.width - transPoint.x;
                transPoint.x = tx;
                transPoint.x -= (float)(pageSize.height - logRect.y - logRect.height);
                transPoint.y -= (float)(pageSize.width - logRect.x - logRect.width);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal print direction: " + this.currentPrintDirection);
            }
        }
        return transPoint;
    }

    private void changePrintDirection() {
        AffineTransform at = this.graphicContext.getTransform();
        try {
            int newDir = at.getScaleX() == 0.0 && at.getScaleY() == 0.0 && at.getShearX() == 1.0 && at.getShearY() == -1.0 ? 90 : (at.getScaleX() == -1.0 && at.getScaleY() == -1.0 && at.getShearX() == 0.0 && at.getShearY() == 0.0 ? 180 : (at.getScaleX() == 0.0 && at.getScaleY() == 0.0 && at.getShearX() == -1.0 && at.getShearY() == 1.0 ? 270 : 0));
            if (newDir != this.currentPrintDirection) {
                this.currentPrintDirection = newDir;
                this.gen.changePrintDirection(this.currentPrintDirection);
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
        this.saveGraphicsState();
        AffineTransform at = new AffineTransform(ctm.toArray());
        this.graphicContext.transform(at);
        this.changePrintDirection();
        if (log.isDebugEnabled()) {
            log.debug((Object)("startVPArea: " + at + " --> " + this.graphicContext.getTransform()));
        }
    }

    protected void endVParea() {
        this.restoreGraphicsState();
        this.changePrintDirection();
        if (log.isDebugEnabled()) {
            log.debug((Object)("endVPArea() --> " + this.graphicContext.getTransform()));
        }
    }

    protected void handleBlockTraits(Block block) {
        int borderPaddingStart = block.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = block.getBorderAndPaddingWidthBefore();
        float startx = (float)this.currentIPPosition / 1000.0f;
        float starty = (float)this.currentBPPosition / 1000.0f;
        float width = (float)block.getIPD() / 1000.0f;
        float height = (float)block.getBPD() / 1000.0f;
        startx += (float)block.getStartIndent() / 1000.0f;
        width += (float)borderPaddingStart / 1000.0f;
        height += (float)borderPaddingBefore / 1000.0f;
        this.drawBackAndBorders(block, startx -= (float)block.getBorderAndPaddingWidthStart() / 1000.0f, starty, width += (float)block.getBorderAndPaddingWidthEnd() / 1000.0f, height += (float)block.getBorderAndPaddingWidthAfter() / 1000.0f);
    }

    protected void renderText(final TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        String fontname = this.getInternalFontNameForArea(text);
        int fontsize = text.getTraitAsInteger(Trait.FONT_SIZE);
        int saveIP = this.currentIPPosition;
        int rx = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + text.getOffset() + text.getBaselineOffset();
        try {
            boolean pclFont;
            final Color col = (Color)text.getTrait(Trait.COLOR);
            boolean bl2 = pclFont = this.allTextAsBitmaps ? false : this.setFont(fontname, fontsize, text.getText());
            if (pclFont) {
                if (col != null) {
                    this.gen.setTransparencyMode(true, false);
                    this.gen.selectGrayscale(col);
                }
                this.saveGraphicsState();
                this.graphicContext.translate(rx, bl);
                this.setCursorPos(0.0f, 0.0f);
                this.gen.setTransparencyMode(true, true);
                super.renderText(text);
                this.restoreGraphicsState();
            } else {
                final Font font = this.getFontFromArea(text);
                final int baseline = text.getBaselineOffset();
                int extraWidth = font.getFontSize() / 3;
                final FontMetricsMapper mapper = (FontMetricsMapper)this.fontInfo.getMetricsFor(font.getFontName());
                int maxAscent = mapper.getMaxAscent(font.getFontSize()) / 1000;
                final int additionalBPD = maxAscent - baseline;
                Graphics2DAdapter g2a = this.getGraphics2DAdapter();
                final Rectangle paintRect = new Rectangle(rx, this.currentBPPosition + text.getOffset() - additionalBPD, text.getIPD() + extraWidth, text.getBPD() + additionalBPD);
                RendererContext rc = this.createRendererContext(paintRect.x, paintRect.y, paintRect.width, paintRect.height, null);
                HashMap<QName, String> atts = new HashMap<QName, String>();
                atts.put(CONV_MODE, "bitmap");
                atts.put(SRC_TRANSPARENCY, "true");
                rc.setProperty("foreign-attributes", atts);
                Graphics2DImagePainter painter = new Graphics2DImagePainter(){

                    public void paint(Graphics2D g2d, Rectangle2D area) {
                        g2d.setFont(mapper.getFont(font.getFontSize()));
                        g2d.translate(0, baseline + additionalBPD);
                        g2d.scale(1000.0, 1000.0);
                        g2d.setColor(col);
                        Java2DRenderer.renderText(text, g2d, font);
                    }

                    public Dimension getImageSize() {
                        return paintRect.getSize();
                    }
                };
                g2a.paintImage(painter, rc, paintRect.x, paintRect.y, paintRect.width, paintRect.height);
                this.currentIPPosition = saveIP + text.getAllocIPD();
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    void setCursorPos(float x, float y) {
        try {
            Point2D transPoint = this.transformedPoint(x, y);
            this.gen.setCursorPos(transPoint.getX(), transPoint.getY());
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void clip() {
        if (this.currentPath == null) {
            throw new IllegalStateException("No current path available!");
        }
        this.currentPath = null;
    }

    protected void closePath() {
        this.currentPath.closePath();
    }

    protected void lineTo(float x, float y) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.lineTo(x, y);
    }

    protected void moveTo(float x, float y) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.moveTo(x, y);
    }

    protected void fillRect(float x, float y, float width, float height) {
        try {
            this.setCursorPos(x * 1000.0f, y * 1000.0f);
            this.gen.fillRect((int)(width * 1000.0f), (int)(height * 1000.0f), this.currentFillColor);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void updateFillColor(Color color) {
        this.currentFillColor = color;
    }

    protected void renderWord(WordArea word) {
        String s = word.getWord();
        try {
            this.gen.writeText(s);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
        super.renderWord(word);
    }

    protected void renderSpace(SpaceArea space) {
        AbstractTextArea textArea = (AbstractTextArea)space.getParentArea();
        String s = space.getSpace();
        char sp = s.charAt(0);
        Font font = this.getFontFromArea(textArea);
        int tws = space.isAdjustable() ? textArea.getTextWordSpaceAdjust() + 2 * textArea.getTextLetterSpaceAdjust() : 0;
        double dx = (float)(font.getCharWidth(sp) + tws) / 100.0f;
        try {
            this.gen.writeCommand("&a+" + this.gen.formatDouble2(dx) + "H");
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
        super.renderSpace(space);
    }

    public void renderViewport(Viewport viewport) {
        float x = (float)this.currentIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + viewport.getOffset()) / 1000.0f;
        float width = (float)viewport.getIPD() / 1000.0f;
        float height = (float)viewport.getBPD() / 1000.0f;
        float borderPaddingStart = (float)viewport.getBorderAndPaddingWidthStart() / 1000.0f;
        float borderPaddingBefore = (float)viewport.getBorderAndPaddingWidthBefore() / 1000.0f;
        float bpwidth = borderPaddingStart + (float)viewport.getBorderAndPaddingWidthEnd() / 1000.0f;
        float bpheight = borderPaddingBefore + (float)viewport.getBorderAndPaddingWidthAfter() / 1000.0f;
        this.drawBackAndBorders(viewport, x, y, width + bpwidth, height + bpheight);
        if (viewport.getClip()) {
            this.saveGraphicsState();
            this.clipRect(x + borderPaddingStart, y + borderPaddingBefore, width, height);
        }
        super.renderViewport(viewport);
        if (viewport.getClip()) {
            this.restoreGraphicsState();
        }
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        CTM ctm = bv.getCTM();
        int borderPaddingStart = bv.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = bv.getBorderAndPaddingWidthBefore();
        float x = (float)(bv.getXOffset() + this.containingIPPosition) / 1000.0f;
        float y = (float)(bv.getYOffset() + this.containingBPPosition) / 1000.0f;
        float width = (float)bv.getIPD() / 1000.0f;
        float height = (float)bv.getBPD() / 1000.0f;
        if (bv.getPositioning() == 2 || bv.getPositioning() == 3) {
            this.currentIPPosition = bv.getXOffset();
            this.currentBPPosition = bv.getYOffset();
            List breakOutList = null;
            if (bv.getPositioning() == 3) {
                breakOutList = this.breakOutOfStateStack();
            }
            CTM tempctm = new CTM(this.containingIPPosition, this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            this.currentIPPosition += bv.getSpaceStart();
            this.currentBPPosition += bv.getSpaceBefore();
            float bpwidth = (float)(borderPaddingStart + bv.getBorderAndPaddingWidthEnd()) / 1000.0f;
            float bpheight = (float)(borderPaddingBefore + bv.getBorderAndPaddingWidthAfter()) / 1000.0f;
            this.drawBackAndBorders(bv, x += (float)bv.getSpaceStart() / 1000.0f, y += (float)bv.getSpaceBefore() / 1000.0f, width + bpwidth, height + bpheight);
            this.currentIPPosition += borderPaddingStart;
            this.currentBPPosition += borderPaddingBefore;
            Rectangle clippingRect = null;
            if (bv.getClip()) {
                clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            }
            this.startVParea(ctm, clippingRect);
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.endVParea();
            if (breakOutList != null) {
                this.restoreStateStackAfterBreakOut(breakOutList);
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            this.currentBPPosition += bv.getSpaceBefore();
            this.handleBlockTraits(bv);
            this.currentIPPosition += bv.getStartIndent();
            CTM tempctm = new CTM(this.containingIPPosition, this.currentBPPosition);
            ctm = tempctm.multiply(ctm);
            this.currentBPPosition += borderPaddingBefore;
            Rectangle clippingRect = null;
            if (bv.getClip()) {
                clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            }
            this.startVParea(ctm, clippingRect);
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.endVParea();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getAllocBPD();
        }
    }

    private List breakOutOfStateStack() {
        log.debug((Object)"Block.FIXED --> break out");
        ArrayList<GraphicContext> breakOutList = new ArrayList<GraphicContext>();
        while (!this.graphicContextStack.empty()) {
            breakOutList.add(0, this.graphicContext);
            this.restoreGraphicsState();
        }
        return breakOutList;
    }

    private void restoreStateStackAfterBreakOut(List breakOutList) {
        log.debug((Object)"Block.FIXED --> restoring context after break-out");
        int c = breakOutList.size();
        for (int i = 0; i < c; ++i) {
            this.saveGraphicsState();
            this.graphicContext = (GraphicContext)breakOutList.get(i);
        }
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.drawImage(image.getURL(), pos, image.getForeignAttributes());
    }

    protected void drawImage(String url, Rectangle2D pos, Map foreignAttributes) {
        url = ImageFactory.getURL(url);
        ImageFactory fact = this.userAgent.getFactory().getImageFactory();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        String mime = fopimage.getMimeType();
        if ("text/xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos, foreignAttributes);
        } else if ("image/svg+xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos, foreignAttributes);
        } else if (fopimage instanceof EPSImage) {
            log.warn((Object)"EPS images are not supported by this renderer");
        } else {
            if (!fopimage.load(4)) {
                log.error((Object)("Bitmap image could not be processed: " + fopimage));
                return;
            }
            byte[] imgmap = fopimage.getBitmaps();
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1004), new int[]{8, 8, 8}, false, false, 1, 0);
            int imgw = fopimage.getWidth();
            int imgh = fopimage.getHeight();
            PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(0, imgw, imgh, 3, imgw * 3, new int[]{0, 1, 2});
            DataBufferByte dbuf = new DataBufferByte(imgmap, imgw * imgh * 3);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
            BufferedImage img = new BufferedImage(cm, raster, false, null);
            try {
                this.setCursorPos(this.currentIPPosition + (int)pos.getX(), this.currentBPPosition + (int)pos.getY());
                this.gen.paintBitmap(img, new Dimension((int)pos.getWidth(), (int)pos.getHeight()), false);
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
        }
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos, fo.getForeignAttributes());
    }

    protected void renderInlineAreaBackAndBorders(InlineArea area) {
        float x = (float)this.currentIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float width = (float)area.getIPD() / 1000.0f;
        float height = (float)area.getBPD() / 1000.0f;
        float borderPaddingStart = (float)area.getBorderAndPaddingWidthStart() / 1000.0f;
        float borderPaddingBefore = (float)area.getBorderAndPaddingWidthBefore() / 1000.0f;
        float bpwidth = borderPaddingStart + (float)area.getBorderAndPaddingWidthEnd() / 1000.0f;
        float bpheight = borderPaddingBefore + (float)area.getBorderAndPaddingWidthAfter() / 1000.0f;
        if (height != 0.0f || bpheight != 0.0f && bpwidth != 0.0f) {
            this.drawBackAndBorders(area, x, y - borderPaddingBefore, width + bpwidth, height + bpheight);
        }
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        BorderProps bpsBefore = (BorderProps)area.getTrait(Trait.BORDER_BEFORE);
        BorderProps bpsAfter = (BorderProps)area.getTrait(Trait.BORDER_AFTER);
        BorderProps bpsStart = (BorderProps)area.getTrait(Trait.BORDER_START);
        BorderProps bpsEnd = (BorderProps)area.getTrait(Trait.BORDER_END);
        Trait.Background back = (Trait.Background)area.getTrait(Trait.BACKGROUND);
        if (back != null) {
            float sx = startx;
            float sy = starty;
            float paddRectWidth = width;
            float paddRectHeight = height;
            if (bpsStart != null) {
                sx += (float)bpsStart.width / 1000.0f;
                paddRectWidth -= (float)bpsStart.width / 1000.0f;
            }
            if (bpsBefore != null) {
                sy += (float)bpsBefore.width / 1000.0f;
                paddRectHeight -= (float)bpsBefore.width / 1000.0f;
            }
            if (bpsEnd != null) {
                paddRectWidth -= (float)bpsEnd.width / 1000.0f;
            }
            if (bpsAfter != null) {
                paddRectHeight -= (float)bpsAfter.width / 1000.0f;
            }
            if (back.getColor() != null) {
                this.updateFillColor(back.getColor());
                this.fillRect(sx, sy, paddRectWidth, paddRectHeight);
            }
            if (back.getFopImage() != null) {
                FopImage fopimage = back.getFopImage();
                if (fopimage != null && fopimage.load(1)) {
                    this.saveGraphicsState();
                    this.clipRect(sx, sy, paddRectWidth, paddRectHeight);
                    int horzCount = (int)(paddRectWidth * 1000.0f / (float)fopimage.getIntrinsicWidth() + 1.0f);
                    int vertCount = (int)(paddRectHeight * 1000.0f / (float)fopimage.getIntrinsicHeight() + 1.0f);
                    if (back.getRepeat() == 96) {
                        horzCount = 1;
                        vertCount = 1;
                    } else if (back.getRepeat() == 113) {
                        vertCount = 1;
                    } else if (back.getRepeat() == 114) {
                        horzCount = 1;
                    }
                    sx *= 1000.0f;
                    sy *= 1000.0f;
                    if (horzCount == 1) {
                        sx += (float)back.getHoriz();
                    }
                    if (vertCount == 1) {
                        sy += (float)back.getVertical();
                    }
                    for (int x = 0; x < horzCount; ++x) {
                        for (int y = 0; y < vertCount; ++y) {
                            Rectangle2D.Float pos = new Rectangle2D.Float(sx - (float)this.currentIPPosition + (float)(x * fopimage.getIntrinsicWidth()), sy - (float)this.currentBPPosition + (float)(y * fopimage.getIntrinsicHeight()), fopimage.getIntrinsicWidth(), fopimage.getIntrinsicHeight());
                            this.drawImage(back.getURL(), pos, null);
                        }
                    }
                    this.restoreGraphicsState();
                } else {
                    log.warn((Object)("Can't find background image: " + back.getURL()));
                }
            }
        }
        Rectangle2D.Float borderRect = new Rectangle2D.Float(startx, starty, width, height);
        this.drawBorders(borderRect, bpsBefore, bpsAfter, bpsStart, bpsEnd);
    }

    protected void drawBorders(Rectangle2D.Float borderRect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
        if (bpsBefore == null && bpsAfter == null && bpsStart == null && bpsEnd == null) {
            return;
        }
        if (this.qualityBeforeSpeed) {
            this.drawQualityBorders(borderRect, bpsBefore, bpsAfter, bpsStart, bpsEnd);
        } else {
            this.drawFastBorders(borderRect, bpsBefore, bpsAfter, bpsStart, bpsEnd);
        }
    }

    protected void drawFastBorders(Rectangle2D.Float borderRect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
        float borderWidth;
        float startx = borderRect.x;
        float starty = borderRect.y;
        float width = borderRect.width;
        float height = borderRect.height;
        if (bpsBefore != null) {
            borderWidth = (float)bpsBefore.width / 1000.0f;
            this.updateFillColor(bpsBefore.color);
            this.fillRect(startx, starty, width, borderWidth);
        }
        if (bpsAfter != null) {
            borderWidth = (float)bpsAfter.width / 1000.0f;
            this.updateFillColor(bpsAfter.color);
            this.fillRect(startx, starty + height - borderWidth, width, borderWidth);
        }
        if (bpsStart != null) {
            borderWidth = (float)bpsStart.width / 1000.0f;
            this.updateFillColor(bpsStart.color);
            this.fillRect(startx, starty, borderWidth, height);
        }
        if (bpsEnd != null) {
            borderWidth = (float)bpsEnd.width / 1000.0f;
            this.updateFillColor(bpsEnd.color);
            this.fillRect(startx + width - borderWidth, starty, borderWidth, height);
        }
    }

    protected void drawQualityBorders(Rectangle2D.Float borderRect, final BorderProps bpsBefore, final BorderProps bpsAfter, final BorderProps bpsStart, final BorderProps bpsEnd) {
        Graphics2DAdapter g2a = this.getGraphics2DAdapter();
        final Rectangle2D.Float effBorderRect = new Rectangle2D.Float(borderRect.x - (float)this.currentIPPosition / 1000.0f, borderRect.y - (float)this.currentBPPosition / 1000.0f, borderRect.width, borderRect.height);
        final Rectangle paintRect = new Rectangle(Math.round(borderRect.x * 1000.0f), Math.round(borderRect.y * 1000.0f), (int)Math.floor(borderRect.width * 1000.0f) + 1, (int)Math.floor(borderRect.height * 1000.0f) + 1);
        int pixelWidth = (int)Math.round(UnitConv.in2mpt(1.0) / (double)this.userAgent.getTargetResolution());
        final int xoffset = Math.round(-effBorderRect.x * 1000.0f) + pixelWidth;
        final int yoffset = pixelWidth;
        paintRect.x += xoffset;
        paintRect.y += yoffset;
        paintRect.width += 2 * pixelWidth;
        paintRect.height += 2 * pixelWidth;
        RendererContext rc = this.createRendererContext(paintRect.x, paintRect.y, paintRect.width, paintRect.height, null);
        HashMap<QName, String> atts = new HashMap<QName, String>();
        atts.put(CONV_MODE, "bitmap");
        atts.put(SRC_TRANSPARENCY, "true");
        rc.setProperty("foreign-attributes", atts);
        Graphics2DImagePainter painter = new Graphics2DImagePainter(){

            public void paint(Graphics2D g2d, Rectangle2D area) {
                float ey1a;
                float sy1a;
                float innerx;
                float clipx;
                float outerx;
                float ey2;
                float ey1;
                float sy2;
                float sy1;
                Rectangle2D.Float lineRect;
                float ex1a;
                float sx1a;
                Graphics2D g;
                float innery;
                float clipy;
                float outery;
                float ex2;
                float ex1;
                float sx2;
                float sx1;
                g2d.translate(xoffset, yoffset);
                g2d.scale(1000.0, 1000.0);
                float startx = effBorderRect.x;
                float starty = effBorderRect.y;
                float width = effBorderRect.width;
                float height = effBorderRect.height;
                boolean[] b = new boolean[]{bpsBefore != null, bpsEnd != null, bpsAfter != null, bpsStart != null};
                if (!(b[0] || b[1] || b[2] || b[3])) {
                    return;
                }
                float[] bw = new float[]{b[0] ? (float)bpsBefore.width / 1000.0f : 0.0f, b[1] ? (float)bpsEnd.width / 1000.0f : 0.0f, b[2] ? (float)bpsAfter.width / 1000.0f : 0.0f, b[3] ? (float)bpsStart.width / 1000.0f : 0.0f};
                float[] clipw = new float[]{(float)BorderProps.getClippedWidth(bpsBefore) / 1000.0f, (float)BorderProps.getClippedWidth(bpsEnd) / 1000.0f, (float)BorderProps.getClippedWidth(bpsAfter) / 1000.0f, (float)BorderProps.getClippedWidth(bpsStart) / 1000.0f};
                starty += clipw[0];
                height -= clipw[0];
                height -= clipw[2];
                startx += clipw[3];
                width -= clipw[3];
                width -= clipw[1];
                boolean[] slant = new boolean[]{b[3] && b[0], b[0] && b[1], b[1] && b[2], b[2] && b[3]};
                if (bpsBefore != null) {
                    sx1 = startx;
                    sx2 = slant[0] ? sx1 + bw[3] - clipw[3] : sx1;
                    ex1 = startx + width;
                    ex2 = slant[1] ? ex1 - bw[1] + clipw[1] : ex1;
                    outery = starty - clipw[0];
                    clipy = outery + clipw[0];
                    innery = outery + bw[0];
                    g = (Graphics2D)g2d.create();
                    PCLRenderer.this.moveTo(sx1, clipy);
                    sx1a = sx1;
                    ex1a = ex1;
                    if (bpsBefore.mode == 2) {
                        if (bpsStart != null && bpsStart.mode == 2) {
                            sx1a -= clipw[3];
                        }
                        if (bpsEnd != null && bpsEnd.mode == 2) {
                            ex1a += clipw[1];
                        }
                        PCLRenderer.this.lineTo(sx1a, outery);
                        PCLRenderer.this.lineTo(ex1a, outery);
                    }
                    PCLRenderer.this.lineTo(ex1, clipy);
                    PCLRenderer.this.lineTo(ex2, innery);
                    PCLRenderer.this.lineTo(sx2, innery);
                    PCLRenderer.this.closePath();
                    g.clip(PCLRenderer.this.currentPath);
                    PCLRenderer.this.currentPath = null;
                    lineRect = new Rectangle2D.Float(sx1a, outery, ex1a - sx1a, innery - outery);
                    Java2DRenderer.drawBorderLine(lineRect, true, true, bpsBefore.style, bpsBefore.color, g);
                }
                if (bpsEnd != null) {
                    sy1 = starty;
                    sy2 = slant[1] ? sy1 + bw[0] - clipw[0] : sy1;
                    ey1 = starty + height;
                    ey2 = slant[2] ? ey1 - bw[2] + clipw[2] : ey1;
                    outerx = startx + width + clipw[1];
                    clipx = outerx - clipw[1];
                    innerx = outerx - bw[1];
                    g = (Graphics2D)g2d.create();
                    PCLRenderer.this.moveTo(clipx, sy1);
                    sy1a = sy1;
                    ey1a = ey1;
                    if (bpsEnd.mode == 2) {
                        if (bpsBefore != null && bpsBefore.mode == 2) {
                            sy1a -= clipw[0];
                        }
                        if (bpsAfter != null && bpsAfter.mode == 2) {
                            ey1a += clipw[2];
                        }
                        PCLRenderer.this.lineTo(outerx, sy1a);
                        PCLRenderer.this.lineTo(outerx, ey1a);
                    }
                    PCLRenderer.this.lineTo(clipx, ey1);
                    PCLRenderer.this.lineTo(innerx, ey2);
                    PCLRenderer.this.lineTo(innerx, sy2);
                    PCLRenderer.this.closePath();
                    g.setClip(PCLRenderer.this.currentPath);
                    PCLRenderer.this.currentPath = null;
                    lineRect = new Rectangle2D.Float(innerx, sy1a, outerx - innerx, ey1a - sy1a);
                    Java2DRenderer.drawBorderLine(lineRect, false, false, bpsEnd.style, bpsEnd.color, g);
                }
                if (bpsAfter != null) {
                    sx1 = startx;
                    sx2 = slant[3] ? sx1 + bw[3] - clipw[3] : sx1;
                    ex1 = startx + width;
                    ex2 = slant[2] ? ex1 - bw[1] + clipw[1] : ex1;
                    outery = starty + height + clipw[2];
                    clipy = outery - clipw[2];
                    innery = outery - bw[2];
                    g = (Graphics2D)g2d.create();
                    PCLRenderer.this.moveTo(ex1, clipy);
                    sx1a = sx1;
                    ex1a = ex1;
                    if (bpsAfter.mode == 2) {
                        if (bpsStart != null && bpsStart.mode == 2) {
                            sx1a -= clipw[3];
                        }
                        if (bpsEnd != null && bpsEnd.mode == 2) {
                            ex1a += clipw[1];
                        }
                        PCLRenderer.this.lineTo(ex1a, outery);
                        PCLRenderer.this.lineTo(sx1a, outery);
                    }
                    PCLRenderer.this.lineTo(sx1, clipy);
                    PCLRenderer.this.lineTo(sx2, innery);
                    PCLRenderer.this.lineTo(ex2, innery);
                    PCLRenderer.this.closePath();
                    g.setClip(PCLRenderer.this.currentPath);
                    PCLRenderer.this.currentPath = null;
                    lineRect = new Rectangle2D.Float(sx1a, innery, ex1a - sx1a, outery - innery);
                    Java2DRenderer.drawBorderLine(lineRect, true, false, bpsAfter.style, bpsAfter.color, g);
                }
                if (bpsStart != null) {
                    sy1 = starty;
                    sy2 = slant[0] ? sy1 + bw[0] - clipw[0] : sy1;
                    ey1 = sy1 + height;
                    ey2 = slant[3] ? ey1 - bw[2] + clipw[2] : ey1;
                    outerx = startx - clipw[3];
                    clipx = outerx + clipw[3];
                    innerx = outerx + bw[3];
                    g = (Graphics2D)g2d.create();
                    PCLRenderer.this.moveTo(clipx, ey1);
                    sy1a = sy1;
                    ey1a = ey1;
                    if (bpsStart.mode == 2) {
                        if (bpsBefore != null && bpsBefore.mode == 2) {
                            sy1a -= clipw[0];
                        }
                        if (bpsAfter != null && bpsAfter.mode == 2) {
                            ey1a += clipw[2];
                        }
                        PCLRenderer.this.lineTo(outerx, ey1a);
                        PCLRenderer.this.lineTo(outerx, sy1a);
                    }
                    PCLRenderer.this.lineTo(clipx, sy1);
                    PCLRenderer.this.lineTo(innerx, sy2);
                    PCLRenderer.this.lineTo(innerx, ey2);
                    PCLRenderer.this.closePath();
                    g.setClip(PCLRenderer.this.currentPath);
                    PCLRenderer.this.currentPath = null;
                    lineRect = new Rectangle2D.Float(outerx, sy1a, innerx - outerx, ey1a - sy1a);
                    Java2DRenderer.drawBorderLine(lineRect, false, false, bpsStart.style, bpsStart.color, g);
                }
            }

            public Dimension getImageSize() {
                return paintRect.getSize();
            }
        };
        try {
            g2a.paintImage(painter, rc, paintRect.x - xoffset, paintRect.y, paintRect.width, paintRect.height);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

