/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RenameAction
extends NodeAction {
    protected boolean surviveFocusChange() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(RenameAction.class, (String)"Rename");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RenameAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        return nodeArray[0].canRename();
    }

    protected void performAction(Node[] nodeArray) {
        Node node = nodeArray[0];
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameAction.class, (String)"CTL_RenameLabel"), NbBundle.getMessage(RenameAction.class, (String)"CTL_RenameTitle"));
        inputLine.setInputText(node.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine))) {
            String string = null;
            try {
                string = inputLine.getInputText();
                if (!string.equals("")) {
                    node.setName(inputLine.getInputText());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                boolean bl;
                boolean bl2 = bl = Exceptions.findLocalizedMessage((Throwable)illegalArgumentException) == null;
                if (bl) {
                    Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)NbBundle.getMessage(RenameAction.class, (String)"MSG_BadFormat", (Object)node.getName(), (Object)string));
                }
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

