/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.reports.actions.doasap;

import au.com.trgtd.tr.reports.actions.doasap.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.view.JasperViewer;
import tr.extract.Extract;
import tr.extract.ExtractActions;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamContext;
import tr.extract.ParamList;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    private ParamList paramGroup;
    private ParamContext paramContext;
    private ParamBoolean paramSuccess;
    private ParamBoolean paramCriteria;
    private ParamBoolean paramProject;
    private ParamBoolean paramNotes;

    public String getID() {
        return "tr.reports.actions.doasap";
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        Vector<Param.Item> groupItems = new Vector<Param.Item>();
        groupItems.add(new Param.Item(this.getString("param-group-context-only"), "context-only"));
        groupItems.add(new Param.Item(this.getString("param-group-context-time"), "context-time"));
        groupItems.add(new Param.Item(this.getString("param-group-context-energy"), "context-energy"));
        groupItems.add(new Param.Item(this.getString("param-group-context-priority"), "context-priority"));
        this.paramGroup = new ParamList("group", this.getString("param-group"), groupItems);
        this.paramContext = new ParamContext("paramContext", this.getString("param-context"), Extract.FormatType.XML);
        this.paramCriteria = new ParamBoolean("paramCriteria", this.getString("param-criteria"));
        this.paramSuccess = new ParamBoolean("paramSuccess", this.getString("param-success"));
        this.paramProject = new ParamBoolean("paramProject", this.getString("param-project"));
        this.paramNotes = new ParamBoolean("paramNotes", this.getString("param-notes"));
        Vector<Param> params = new Vector<Param>();
        params.add((Param)this.paramGroup);
        params.add((Param)this.paramContext);
        params.add((Param)this.paramCriteria);
        params.add((Param)this.paramSuccess);
        params.add((Param)this.paramProject);
        params.add((Param)this.paramNotes);
        return params;
    }

    public void process(Data data) throws Exception {
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), this.getParams());
        if (dlg.showDialog() == 2) {
            return;
        }
        HashMap<String, Object> rparams = new HashMap<String, Object>();
        rparams.put("paramContext", this.paramContext.getValue());
        rparams.put("paramCriteria", Boolean.parseBoolean(this.paramCriteria.getValue()));
        rparams.put("paramSuccess", Boolean.parseBoolean(this.paramSuccess.getValue()));
        rparams.put("paramProject", Boolean.parseBoolean(this.paramProject.getValue()));
        rparams.put("paramNotes", Boolean.parseBoolean(this.paramNotes.getValue()));
        String groupBy = this.paramGroup.getValue();
        FileInputStream reportStream = groupBy.equals("context-time") ? new FileInputStream(Resources.FILE_DOASAP_BY_CONTEXT_AND_TIME) : (groupBy.equals("context-energy") ? new FileInputStream(Resources.FILE_DOASAP_BY_CONTEXT_AND_ENERGY) : (groupBy.equals("context-priority") ? new FileInputStream(Resources.FILE_DOASAP_BY_CONTEXT_AND_PRIORITY) : new FileInputStream(Resources.FILE_DOASAP_BY_CONTEXT)));
        File xmlfile = ReportImpl.getTmpFile((String)"Actions.xml");
        ExtractActions.process((Data)data, (File)xmlfile);
        JRXmlDataSource xmlDataSource = new JRXmlDataSource(xmlfile, "/data/actions/action");
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, rparams, (JRDataSource)xmlDataSource);
        JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
    }
}

