/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;

public class ApplePopupFactory
extends PopupFactory {
    private static final boolean APPLE_HEAVYWEIGHT = Boolean.getBoolean("nb.explorer.hw.completions");
    private static final boolean APPLE_COCOA_HACK = APPLE_HEAVYWEIGHT && Boolean.getBoolean("nb.explorer.hw.cocoahack");
    private static Set<Reference<JWindow>> windowPool = new HashSet<Reference<JWindow>>();
    private static int ct = 0;
    private static boolean hackBroken = false;
    private static boolean warned = false;

    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        assert (component instanceof JComponent);
        Dimension dimension = component2.getPreferredSize();
        Container container = ((JComponent)component).getTopLevelAncestor();
        if (container == null) {
            throw new IllegalArgumentException("Not onscreen: " + component);
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, container);
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        if (container.getBounds().contains(rectangle)) {
            return new LWPopup(component, component2, n, n2);
        }
        return APPLE_HEAVYWEIGHT ? new HWPopup(component, component2, n, n2) : new NullPopup();
    }

    private static JWindow checkOutWindow() {
        Object object;
        if (windowPool != null && !windowPool.isEmpty()) {
            object = windowPool.iterator();
            while (object.hasNext()) {
                Reference reference = (Reference)object.next();
                JWindow jWindow = (JWindow)reference.get();
                object.remove();
                if (jWindow == null) continue;
                assert (!jWindow.isShowing());
                jWindow.setBounds(0, 0, 1, 1);
                jWindow.getContentPane().removeAll();
                jWindow.setBackground(new Color(255, 255, 255, 0));
                return jWindow;
            }
        }
        object = APPLE_COCOA_HACK ? new HackedJWindow() : new JWindow();
        ((Window)object).setBackground(new Color(255, 255, 255, 0));
        return object;
    }

    private static void checkInWindow(JWindow jWindow) {
        if (!APPLE_COCOA_HACK) {
            jWindow.dispose();
        }
        windowPool.add(new SoftReference<JWindow>(jWindow));
    }

    static boolean broken() {
        return hackBroken;
    }

    private static class HWPopup
    extends OurPopup {
        private JWindow window = null;

        public HWPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
        }

        public boolean isShowing() {
            return this.window != null && this.window.isShowing();
        }

        void dispose() {
            if (this.window != null) {
                ApplePopupFactory.checkInWindow(this.window);
                this.window = null;
            }
            super.dispose();
        }

        protected void prepareResources() {
            this.window = ApplePopupFactory.checkOutWindow();
            this.window.getContentPane().add(this.contents);
            this.window.setLocation(new Point(this.x, this.y));
            this.window.pack();
            this.window.setBackground(new Color(255, 255, 255, 0));
        }

        protected void doShow() {
            this.window.setVisible(true);
        }

        protected void doHide() {
            if (this.window != null) {
                this.window.setVisible(false);
                this.window.getContentPane().remove(this.contents);
                this.dispose();
            }
        }
    }

    private static final class HackedJWindow
    extends JWindow {
        private String title = "none";

        HackedJWindow() {
        }

        public void addNotify() {
            super.addNotify();
            this.hackTitle();
            this.hackNativeWindow();
        }

        private void hackTitle() {
            if (!hackBroken) {
                try {
                    ComponentPeer componentPeer = this.getPeer();
                    if (componentPeer != null) {
                        Method method = componentPeer.getClass().getDeclaredMethod("setTitle", String.class);
                        method.setAccessible(true);
                        this.title = "hw popup" + ct++;
                        method.invoke((Object)componentPeer, this.title);
                    }
                }
                catch (Exception exception) {
                    this.warn(exception);
                }
            }
        }

        private void hackNativeWindow() {
            if (!hackBroken) {
                try {
                    Class<?> clazz = Class.forName("com.apple.cocoa.application.NSApplication");
                    Method method = clazz.getDeclaredMethod("sharedApplication", new Class[0]);
                    Object object = method.invoke(null, new Object[0]);
                    method = object.getClass().getMethod("windows", new Class[0]);
                    Object object2 = method.invoke(object, new Object[0]);
                    method = object2.getClass().getMethod("count", new Class[0]);
                    int n = (Integer)method.invoke(object2, new Object[0]);
                    Object[] objectArray = new Object[n];
                    method = object2.getClass().getMethod("getObjects", Object[].class);
                    method.invoke(object2, new Object[]{objectArray});
                    if (objectArray.length > 0) {
                        clazz = objectArray[0].getClass();
                        Method method2 = clazz.getMethod("title", new Class[0]);
                        Method method3 = clazz.getMethod("setHasShadow", Boolean.TYPE);
                        for (int i = 0; i < objectArray.length; ++i) {
                            String string = (String)method2.invoke(objectArray[i], new Object[0]);
                            if (!this.title.equals(string)) continue;
                            method3.invoke(objectArray[i], Boolean.FALSE);
                        }
                    }
                }
                catch (Exception exception) {
                    this.warn(exception);
                }
            }
        }

        private void warn(Exception exception) {
            hackBroken = true;
            if (!warned) {
                warned = true;
                ErrorManager.getDefault().log(1, "Cannot turn off popup drop shadow, reverting to standard swing popup factory");
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                exception.printStackTrace();
            }
        }
    }

    private static class LWPopup
    extends OurPopup {
        private Rectangle bounds = null;

        public LWPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
        }

        protected void prepareResources() {
            JComponent jComponent = (JComponent)this.owner;
            Container container = jComponent.getTopLevelAncestor();
            JComponent jComponent2 = null;
            if (container instanceof JFrame) {
                jComponent2 = (JComponent)((JFrame)container).getGlassPane();
            } else if (container instanceof JDialog) {
                jComponent2 = (JComponent)((JDialog)container).getGlassPane();
            } else if (container instanceof JWindow) {
                jComponent2 = (JComponent)((JWindow)container).getGlassPane();
            }
            if (container == null) {
                throw new IllegalArgumentException("Not a JFrame/JWindow/JDialog: " + this.owner);
            }
            Point point = new Point(this.x, this.y);
            SwingUtilities.convertPointFromScreen(point, jComponent2);
            if (jComponent2.getLayout() != null) {
                jComponent2.setLayout(null);
            }
            jComponent2.setVisible(true);
            this.contents.setVisible(false);
            Dimension dimension = this.contents.getPreferredSize();
            jComponent2.add(this.contents);
            this.bounds = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            this.contents.setBounds(point.x, point.y, dimension.width, dimension.height);
        }

        protected void doShow() {
            this.contents.setVisible(true);
        }

        public boolean isShowing() {
            return this.contents != null && this.contents.isShowing();
        }

        protected void doHide() {
            Container container = this.contents.getParent();
            if (container != null) {
                this.contents.getParent().remove(this.contents);
                container.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            }
            this.contents.setVisible(true);
        }
    }

    private static final class NullPopup
    extends Popup {
        private NullPopup() {
        }

        public void show() {
        }

        public void hide() {
        }
    }

    private static abstract class OurPopup
    extends Popup {
        protected Component owner = null;
        protected Component contents = null;
        protected int x = -1;
        protected int y = -1;
        private boolean canReuse = false;

        public OurPopup(Component component, Component component2, int n, int n2) {
            this.configure(component, component2, n, n2);
        }

        final void configure(Component component, Component component2, int n, int n2) {
            this.owner = component;
            this.contents = component2;
            this.x = n;
            this.y = n2;
        }

        protected abstract void prepareResources();

        protected abstract void doShow();

        public abstract boolean isShowing();

        protected abstract void doHide();

        public final void show() {
            this.prepareResources();
            this.doShow();
        }

        public final void hide() {
            this.doHide();
        }

        void dispose() {
            this.owner = null;
            this.contents = null;
            this.x = -1;
            this.y = -1;
        }

        public final void clear() {
            this.canReuse = true;
            this.dispose();
        }

        boolean isInUse() {
            return this.canReuse;
        }
    }
}

