/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class URLUtil {
    private static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(URLMapper.class));

    public static URL createExternalURL(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = URLUtil.getFullyRFC2396CompliantURL(uRL);
        if (URLUtil.isAcceptableProtocol(uRL2, bl)) {
            return uRL2;
        }
        String string = uRL2.getRef();
        String string2 = uRL2.toString();
        int n = string2.indexOf(35);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        try {
            URL uRL3;
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(string2));
            if (fileObject != null && (uRL3 = URLUtil.getURLOfAppropriateType(fileObject, bl)) != null) {
                string2 = uRL3.toString();
                if (n >= 0) {
                    string2 = string2 + "#" + string;
                }
                return new URL(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger("global").log(Level.INFO, null, malformedURLException);
        }
        return uRL2;
    }

    private static URL getFullyRFC2396CompliantURL(URL uRL) {
        String string = uRL.toString();
        int n = string.indexOf(35);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = uRL.getRef();
            try {
                String string4 = URLEncoder.encode(URLDecoder.decode(string3, "UTF8"), "UTF8");
                string4 = string4.replaceAll("\\+", "%20");
                if (!string3.equals(string4)) {
                    URL uRL2 = new URL(string2 + '#' + string4);
                    Logger.getLogger("global").warning("The URL:\n" + string + "\nis not fully RFC 2396 compliant and cannot " + "be used with Desktop.browse(). Instead using URL:" + uRL2);
                    return uRL2;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
        return uRL;
    }

    private static URL getURLOfAppropriateType(FileObject fileObject, boolean bl) {
        Object object;
        URL uRL = null;
        Iterator iterator = result.allInstances().iterator();
        while (iterator.hasNext()) {
            object = (URLMapper)iterator.next();
            URL uRL2 = object.getURL(fileObject, 1);
            if (uRL2 == null || !URLUtil.isAcceptableProtocol(uRL2, bl)) continue;
            String string = uRL2.getProtocol().toLowerCase();
            if ("file".equals(string) || "jar".equals(string)) {
                return uRL2;
            }
            uRL = uRL2;
        }
        if (uRL != null) {
            return uRL;
        }
        object = URLMapper.findURL((FileObject)fileObject, (int)2);
        if (object == null) {
            Logger.getLogger("global").log(Level.SEVERE, "URLMapper.findURL() failed for " + fileObject);
            return null;
        }
        return URLUtil.makeURLLocal((URL)object);
    }

    private static URL makeURLLocal(URL uRL) {
        String string = uRL.getHost();
        try {
            if (string.equals(InetAddress.getLocalHost().getHostName())) {
                string = "127.0.0.1";
                return new URL(uRL.getProtocol(), string, uRL.getPort(), uRL.getFile());
            }
            return uRL;
        }
        catch (UnknownHostException unknownHostException) {
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    private static boolean isAcceptableProtocol(URL uRL, boolean bl) {
        String string;
        String string2 = uRL.getProtocol().toLowerCase();
        if ("http".equals(string2) || "ftp".equals(string2) || "file".equals(string2)) {
            return true;
        }
        return bl && "jar".equals(string2) && !(string = uRL.toString()).toLowerCase().startsWith("jar:nbinst:");
    }

    public static boolean browserHandlesJarURLs(String string) {
        return "MOZILLA".equals(string) || "FIREFOX".equals(string);
    }
}

