/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.image.Raster;
import org.apache.batik.ext.awt.image.rendered.LRUCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public class TileGrid
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private int xSz;
    private int ySz;
    private int minTileX;
    private int minTileY;
    private TileLRUMember[][] rasters = null;
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;
    static /* synthetic */ Class class$org$apache$batik$ext$awt$image$rendered$TileGrid;

    public TileGrid(int n, int n2, int n3, int n4, TileGenerator tileGenerator, LRUCache lRUCache) {
        this.cache = lRUCache;
        this.source = tileGenerator;
        this.minTileX = n;
        this.minTileY = n2;
        this.xSz = n3;
        this.ySz = n4;
        this.rasters = new TileLRUMember[n4][];
    }

    public void setTile(int n, int n2, Raster raster) {
        TileLRUMember tileLRUMember;
        n2 -= this.minTileY;
        if ((n -= this.minTileX) < 0 || n >= this.xSz) {
            return;
        }
        if (n2 < 0 || n2 >= this.ySz) {
            return;
        }
        TileLRUMember[] tileLRUMemberArray = this.rasters[n2];
        if (raster == null) {
            if (tileLRUMemberArray == null) {
                return;
            }
            TileLRUMember tileLRUMember2 = tileLRUMemberArray[n];
            if (tileLRUMember2 == null) {
                return;
            }
            tileLRUMemberArray[n] = null;
            this.cache.remove(tileLRUMember2);
            return;
        }
        if (tileLRUMemberArray != null) {
            tileLRUMember = tileLRUMemberArray[n];
            if (tileLRUMember == null) {
                tileLRUMemberArray[n] = tileLRUMember = new TileLRUMember();
            }
        } else {
            tileLRUMemberArray = new TileLRUMember[this.xSz];
            tileLRUMemberArray[n] = tileLRUMember = new TileLRUMember();
            this.rasters[n2] = tileLRUMemberArray;
        }
        tileLRUMember.setRaster(raster);
        this.cache.add(tileLRUMember);
    }

    public Raster getTileNoCompute(int n, int n2) {
        n2 -= this.minTileY;
        if ((n -= this.minTileX) < 0 || n >= this.xSz) {
            return null;
        }
        if (n2 < 0 || n2 >= this.ySz) {
            return null;
        }
        TileLRUMember[] tileLRUMemberArray = this.rasters[n2];
        if (tileLRUMemberArray == null) {
            return null;
        }
        TileLRUMember tileLRUMember = tileLRUMemberArray[n];
        if (tileLRUMember == null) {
            return null;
        }
        Raster raster = tileLRUMember.retrieveRaster();
        if (raster != null) {
            this.cache.add(tileLRUMember);
        }
        return raster;
    }

    public Raster getTile(int n, int n2) {
        n2 -= this.minTileY;
        if ((n -= this.minTileX) < 0 || n >= this.xSz) {
            return null;
        }
        if (n2 < 0 || n2 >= this.ySz) {
            return null;
        }
        Raster raster = null;
        TileLRUMember[] tileLRUMemberArray = this.rasters[n2];
        TileLRUMember tileLRUMember = null;
        if (tileLRUMemberArray != null) {
            tileLRUMember = tileLRUMemberArray[n];
            if (tileLRUMember != null) {
                raster = tileLRUMember.retrieveRaster();
            } else {
                tileLRUMemberArray[n] = tileLRUMember = new TileLRUMember();
            }
        } else {
            tileLRUMemberArray = new TileLRUMember[this.xSz];
            this.rasters[n2] = tileLRUMemberArray;
            tileLRUMemberArray[n] = tileLRUMember = new TileLRUMember();
        }
        if (raster == null) {
            raster = this.source.genTile(n + this.minTileX, n2 + this.minTileY);
            if (HaltingThread.hasBeenHalted()) {
                return raster;
            }
            tileLRUMember.setRaster(raster);
        }
        this.cache.add(tileLRUMember);
        return raster;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

