/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.ext.awt.g2d.TransformStackElement;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.SVGAttribute;
import org.apache.batik.svggen.SVGAttributeMap;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Element;

public class DOMGroupManager
implements SVGSyntax,
ErrorConstants {
    public static final short DRAW = 1;
    public static final short FILL = 16;
    protected GraphicContext gc;
    protected DOMTreeManager domTreeManager;
    protected SVGGraphicContext groupGC;
    protected Element currentGroup;

    public DOMGroupManager(GraphicContext graphicContext, DOMTreeManager dOMTreeManager) {
        if (graphicContext == null) {
            throw new SVGGraphics2DRuntimeException("gc should not be null");
        }
        if (dOMTreeManager == null) {
            throw new SVGGraphics2DRuntimeException("domTreeManager should not be null");
        }
        this.gc = graphicContext;
        this.domTreeManager = dOMTreeManager;
        this.recycleCurrentGroup();
        this.groupGC = dOMTreeManager.gcConverter.toSVG(graphicContext);
    }

    void recycleCurrentGroup() {
        this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
    }

    public void addElement(Element element) {
        this.addElement(element, (short)17);
    }

    public void addElement(Element element, short s) {
        if (!this.currentGroup.hasChildNodes()) {
            this.currentGroup.appendChild(element);
            this.groupGC = this.domTreeManager.gcConverter.toSVG(this.gc);
            SVGGraphicContext sVGGraphicContext = this.processDeltaGC(this.groupGC, this.domTreeManager.defaultGC);
            this.domTreeManager.getStyleHandler().setStyle(this.currentGroup, sVGGraphicContext.getGroupContext(), this.domTreeManager.getGeneratorContext());
            if ((s & 1) == 0) {
                sVGGraphicContext.getGraphicElementContext().put("stroke", "none");
            }
            if ((s & 0x10) == 0) {
                sVGGraphicContext.getGraphicElementContext().put("fill", "none");
            }
            this.domTreeManager.getStyleHandler().setStyle(element, sVGGraphicContext.getGraphicElementContext(), this.domTreeManager.getGeneratorContext());
            this.setTransform(this.currentGroup, sVGGraphicContext.getTransformStack());
            this.domTreeManager.appendGroup(this.currentGroup, this);
        } else if (this.gc.isTransformStackValid()) {
            SVGGraphicContext sVGGraphicContext = this.domTreeManager.gcConverter.toSVG(this.gc);
            SVGGraphicContext sVGGraphicContext2 = this.processDeltaGC(sVGGraphicContext, this.groupGC);
            this.trimContextForElement(sVGGraphicContext2, element);
            if (this.countOverrides(sVGGraphicContext2) <= this.domTreeManager.maxGCOverrides) {
                this.currentGroup.appendChild(element);
                if ((s & 1) == 0) {
                    sVGGraphicContext2.getContext().put("stroke", "none");
                }
                if ((s & 0x10) == 0) {
                    sVGGraphicContext2.getContext().put("fill", "none");
                }
                this.domTreeManager.getStyleHandler().setStyle(element, sVGGraphicContext2.getContext(), this.domTreeManager.getGeneratorContext());
                this.setTransform(element, sVGGraphicContext2.getTransformStack());
            } else {
                this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
                this.addElement(element, s);
            }
        } else {
            this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
            this.gc.validateTransformStack();
            this.addElement(element, s);
        }
    }

    protected int countOverrides(SVGGraphicContext sVGGraphicContext) {
        return sVGGraphicContext.getGroupContext().size();
    }

    protected void trimContextForElement(SVGGraphicContext sVGGraphicContext, Element element) {
        String string = element.getTagName();
        Map map = sVGGraphicContext.getGroupContext();
        if (string != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                SVGAttribute sVGAttribute = SVGAttributeMap.get(string2);
                if (sVGAttribute == null || sVGAttribute.appliesTo(string)) continue;
                map.remove(string2);
            }
        }
    }

    protected void setTransform(Element element, TransformStackElement[] transformStackElementArray) {
        String string = this.domTreeManager.gcConverter.toSVG(transformStackElementArray).trim();
        if (string.length() > 0) {
            element.setAttributeNS(null, "transform", string);
        }
    }

    protected SVGGraphicContext processDeltaGC(SVGGraphicContext sVGGraphicContext, SVGGraphicContext sVGGraphicContext2) {
        Map map = this.processDeltaMap(sVGGraphicContext.getGroupContext(), sVGGraphicContext2.getGroupContext());
        Map map2 = sVGGraphicContext.getGraphicElementContext();
        TransformStackElement[] transformStackElementArray = sVGGraphicContext.getTransformStack();
        TransformStackElement[] transformStackElementArray2 = sVGGraphicContext2.getTransformStack();
        int n = transformStackElementArray.length - transformStackElementArray2.length;
        TransformStackElement[] transformStackElementArray3 = new TransformStackElement[n];
        System.arraycopy(transformStackElementArray, transformStackElementArray2.length, transformStackElementArray3, 0, n);
        SVGGraphicContext sVGGraphicContext3 = new SVGGraphicContext(map, map2, transformStackElementArray3);
        return sVGGraphicContext3;
    }

    protected Map processDeltaMap(Map map, Map map2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (string3.equals(string = (String)map2.get(string2))) continue;
            hashMap.put(string2, string3);
        }
        return hashMap;
    }
}

