/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Coverage;
import org.apache.batik.svggen.font.table.SingleSubst;

public class SingleSubstFormat2
extends SingleSubst {
    private int coverageOffset;
    private int glyphCount;
    private int[] substitutes;
    private Coverage coverage;

    protected SingleSubstFormat2(RandomAccessFile randomAccessFile, int n) throws IOException {
        this.coverageOffset = randomAccessFile.readUnsignedShort();
        this.glyphCount = randomAccessFile.readUnsignedShort();
        this.substitutes = new int[this.glyphCount];
        int n2 = 0;
        while (n2 < this.glyphCount) {
            this.substitutes[n2] = randomAccessFile.readUnsignedShort();
            ++n2;
        }
        randomAccessFile.seek(n + this.coverageOffset);
        this.coverage = Coverage.read(randomAccessFile);
    }

    public int getFormat() {
        return 2;
    }

    public int substitute(int n) {
        int n2 = this.coverage.findGlyph(n);
        if (n2 > -1) {
            return this.substitutes[n2];
        }
        return n;
    }
}

