/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSelection<E>
implements ListEventListener<E> {
    public static final int SINGLE_SELECTION = 0;
    public static final int SINGLE_INTERVAL_SELECTION = 1;
    public static final int MULTIPLE_INTERVAL_SELECTION = 2;
    public static final int MULTIPLE_INTERVAL_SELECTION_DEFENSIVE = 103;
    private static final Object SELECTED = Barcode.BLACK;
    private static final Object DESELECTED = Barcode.WHITE;
    private final EventList<E> source;
    private SelectedList<E> selectedList;
    private DeselectedList<E> deselectedList;
    private SelectionToggleList<E> selectedToggleList;
    private DeselectionToggleList<E> deselectedToggleList;
    private Barcode barcode = new Barcode();
    private int leadSelectionIndex = -1;
    private int anchorSelectionIndex = -1;
    private int selectionMode = 103;
    private final List<Listener> selectionListeners = new ArrayList<Listener>(1);

    public ListSelection(EventList<E> source) {
        this.source = source;
        this.barcode.add(0, DESELECTED, source.size());
        source.addListEventListener(this);
    }

    public ListSelection(EventList<E> source, int[] initialSelection) {
        this(source);
        this.select(initialSelection);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        int minSelectionIndexBefore = this.getMinSelectionIndex();
        int maxSelectionIndexBefore = this.getMaxSelectionIndex();
        boolean selectionChanged = false;
        if (listChanges.isReordering()) {
            this.beginSelected();
            int[] sourceReorderMap = listChanges.getReorderMap();
            int[] selectReorderMap = new int[this.barcode.colourSize(SELECTED)];
            int[] deselectReorderMap = new int[this.barcode.colourSize(DESELECTED)];
            Barcode previousBarcode = this.barcode;
            this.barcode = new Barcode();
            for (int c = 0; c < sourceReorderMap.length; ++c) {
                int currentIndex;
                int previousIndex;
                Object flag = previousBarcode.get(sourceReorderMap[c]);
                boolean wasSelected = flag != DESELECTED;
                this.barcode.add(c, flag, 1);
                if (wasSelected) {
                    previousIndex = previousBarcode.getColourIndex(sourceReorderMap[c], SELECTED);
                    currentIndex = this.barcode.getColourIndex(c, SELECTED);
                    selectReorderMap[currentIndex] = previousIndex;
                    continue;
                }
                previousIndex = previousBarcode.getColourIndex(sourceReorderMap[c], DESELECTED);
                currentIndex = this.barcode.getColourIndex(c, DESELECTED);
                deselectReorderMap[currentIndex] = previousIndex;
            }
            this.anchorSelectionIndex = -1;
            this.leadSelectionIndex = -1;
            this.addSelectedReorder(selectReorderMap);
            this.commitSelected();
            this.beginDeselected();
            this.addDeselectedReorder(deselectReorderMap);
            this.commitDeselected();
            selectionChanged = true;
        } else {
            this.beginAll();
            while (listChanges.next()) {
                int deselectedIndex;
                boolean previouslySelected;
                int index = listChanges.getIndex();
                int changeType = listChanges.getType();
                int previousSelectionIndex = this.barcode.getColourIndex(index, SELECTED);
                boolean bl = previouslySelected = previousSelectionIndex != -1;
                if (changeType == 0) {
                    if (index <= maxSelectionIndexBefore) {
                        selectionChanged = true;
                    }
                    if (previouslySelected) {
                        this.barcode.remove(index, 1);
                        this.addSelectedDelete(previousSelectionIndex, listChanges.getOldValue());
                    } else {
                        deselectedIndex = this.barcode.getColourIndex(index, DESELECTED);
                        this.addDeselectedDelete(deselectedIndex, listChanges.getOldValue());
                        this.barcode.remove(index, 1);
                    }
                } else if (changeType == 2) {
                    if (index <= maxSelectionIndexBefore) {
                        selectionChanged = true;
                    }
                    if (previouslySelected) {
                        if (this.selectionMode == 1 || this.selectionMode == 2) {
                            this.barcode.add(index, SELECTED, 1);
                            this.addSelectedInsert(previousSelectionIndex, listChanges.getNewValue());
                        } else {
                            this.barcode.add(index, DESELECTED, 1);
                            deselectedIndex = this.barcode.getColourIndex(index, DESELECTED);
                            this.addDeselectedInsert(deselectedIndex, listChanges.getNewValue());
                        }
                    } else {
                        this.barcode.add(index, DESELECTED, 1);
                        deselectedIndex = this.barcode.getColourIndex(index, DESELECTED);
                        this.addDeselectedInsert(deselectedIndex, listChanges.getNewValue());
                    }
                } else if (changeType == 1) {
                    if (previouslySelected) {
                        this.addSelectedUpdate(previousSelectionIndex, listChanges.getOldValue(), listChanges.getNewValue());
                    } else {
                        deselectedIndex = this.barcode.getColourIndex(index, DESELECTED);
                        this.addDeselectedUpdate(deselectedIndex, listChanges.getOldValue(), listChanges.getNewValue());
                    }
                }
                this.anchorSelectionIndex = this.adjustIndex(this.anchorSelectionIndex, changeType, index);
                this.leadSelectionIndex = this.adjustIndex(this.leadSelectionIndex, changeType, index);
            }
            this.commitAll();
        }
        if (minSelectionIndexBefore != -1 && maxSelectionIndexBefore != -1 && selectionChanged) {
            int minSelectionIndexAfter = this.getMinSelectionIndex();
            int maxSelectionIndexAfter = this.getMaxSelectionIndex();
            int changeStart = minSelectionIndexBefore;
            int changeFinish = maxSelectionIndexBefore;
            if (minSelectionIndexAfter != -1 && minSelectionIndexAfter < changeStart) {
                changeStart = minSelectionIndexAfter;
            }
            if (maxSelectionIndexAfter != -1 && maxSelectionIndexAfter > changeFinish) {
                changeFinish = maxSelectionIndexAfter;
            }
            this.fireSelectionChanged(changeStart, changeFinish);
        }
    }

    private int adjustIndex(int indexBefore, int changeType, int changeIndex) {
        if (indexBefore == -1) {
            return -1;
        }
        if (changeType == 0) {
            if (changeIndex < indexBefore) {
                return indexBefore - 1;
            }
            if (changeIndex == indexBefore) {
                return -1;
            }
            return indexBefore;
        }
        if (changeType == 1) {
            return indexBefore;
        }
        if (changeType == 2) {
            if (changeIndex <= indexBefore) {
                return indexBefore + 1;
            }
            return indexBefore;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getSelected() {
        List<Listener> list = this.selectionListeners;
        synchronized (list) {
            if (this.selectedList == null) {
                this.selectedList = new SelectedList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.selectedList, this);
            }
        }
        return this.selectedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingSelected() {
        List<Listener> list = this.selectionListeners;
        synchronized (list) {
            if (this.selectedToggleList == null) {
                this.selectedToggleList = new SelectionToggleList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.selectedToggleList, this);
            }
        }
        return this.selectedToggleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getDeselected() {
        List<Listener> list = this.selectionListeners;
        synchronized (list) {
            if (this.deselectedList == null) {
                this.deselectedList = new DeselectedList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.deselectedList, this);
            }
        }
        return this.deselectedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingDeselected() {
        List<Listener> list = this.selectionListeners;
        synchronized (list) {
            if (this.deselectedToggleList == null) {
                this.deselectedToggleList = new DeselectionToggleList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.deselectedToggleList, this);
            }
        }
        return this.deselectedToggleList;
    }

    public EventList<E> getSource() {
        return this.source;
    }

    public void invertSelection() {
        this.anchorSelectionIndex = -1;
        this.leadSelectionIndex = -1;
        this.beginAll();
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNext()) {
            int newIndex;
            Object color = i.next();
            Object value = this.source.get(i.getIndex());
            int originalIndex = i.getColourIndex(color);
            if (color == SELECTED) {
                i.set(DESELECTED);
                newIndex = i.getColourIndex(DESELECTED);
                this.addDeselectEvent(originalIndex, newIndex, value);
                continue;
            }
            i.set(SELECTED);
            newIndex = i.getColourIndex(SELECTED);
            this.addSelectEvent(newIndex, originalIndex, value);
        }
        this.commitAll();
        this.fireSelectionChanged(0, this.source.size() - 1);
    }

    public boolean isSelected(int sourceIndex) {
        if (sourceIndex < 0 || sourceIndex >= this.source.size()) {
            return false;
        }
        return this.barcode.getColourIndex(sourceIndex, SELECTED) != -1;
    }

    public void deselect(int index) {
        this.deselect(index, index);
    }

    public void deselect(int start, int end) {
        if (start == -1 || end == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            int selectedIndex = this.getMaxSelectionIndex();
            if (selectedIndex >= start && selectedIndex <= end) {
                this.deselectAll();
            }
            return;
        }
        if (this.selectionMode == 1 && start > this.getMinSelectionIndex()) {
            end = Math.max(end, this.getMaxSelectionIndex());
        }
        int oldAnchor = this.anchorSelectionIndex == start ? -1 : this.anchorSelectionIndex;
        int oldLead = this.leadSelectionIndex == end ? -1 : this.leadSelectionIndex;
        this.anchorSelectionIndex = start;
        this.leadSelectionIndex = end;
        this.setSubRangeOfRange(false, start, end, -1, -1, oldLead, oldAnchor);
    }

    public void deselect(int[] indices) {
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.beginAll();
        int currentIndex = 0;
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNext() && currentIndex != indices.length) {
            Object value = i.next();
            if (i.getIndex() != indices[currentIndex]) continue;
            if (value == SELECTED) {
                if (firstAffectedIndex == -1) {
                    firstAffectedIndex = i.getIndex();
                }
                lastAffectedIndex = i.getIndex();
                this.addDeselectEvent(i);
            }
            ++currentIndex;
        }
        this.commitAll();
        if (firstAffectedIndex > -1) {
            this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
        }
    }

    public void deselectAll() {
        this.setAllColor(DESELECTED);
    }

    private void setAllColor(Object color) {
        Object oppositeColor;
        Object object = oppositeColor = color == SELECTED ? DESELECTED : SELECTED;
        if (this.barcode.colourSize(oppositeColor) == 0) {
            return;
        }
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.beginAll();
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNextColour(oppositeColor)) {
            i.nextColour(oppositeColor);
            int index = i.getIndex();
            Object value = this.source.get(index);
            if (color == SELECTED) {
                this.addDeselectedDelete(0, value);
                this.addSelectedInsert(index, value);
            } else {
                this.addSelectedDelete(0, value);
                this.addDeselectedInsert(index, value);
            }
            if (firstAffectedIndex == -1) {
                firstAffectedIndex = index;
            }
            lastAffectedIndex = index;
        }
        this.barcode.clear();
        this.barcode.add(0, color, this.source.size());
        this.commitAll();
        this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
    }

    public void select(int index) {
        this.select(index, index);
    }

    public void select(int start, int end) {
        if (start == -1 || end == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelection(start);
            return;
        }
        if (this.selectionMode == 1) {
            boolean overlap = false;
            int minSelectedIndex = this.getMinSelectionIndex();
            int maxSelectedIndex = this.getMaxSelectionIndex();
            if (minSelectedIndex - 1 <= start && start <= maxSelectedIndex + 1) {
                overlap = true;
            }
            if (minSelectedIndex - 1 <= end && end <= maxSelectedIndex + 1) {
                overlap = true;
            }
            if (!overlap) {
                this.setSelection(start, end);
                return;
            }
        }
        int oldAnchor = this.anchorSelectionIndex == start ? -1 : this.anchorSelectionIndex;
        int oldLead = this.leadSelectionIndex == end ? -1 : this.leadSelectionIndex;
        this.anchorSelectionIndex = start;
        this.leadSelectionIndex = end;
        this.setSubRangeOfRange(true, start, end, -1, -1, oldLead, oldAnchor);
    }

    public void select(int[] indices) {
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.beginAll();
        int currentIndex = 0;
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNext() && currentIndex != indices.length) {
            Object value = i.next();
            if (i.getIndex() != indices[currentIndex]) continue;
            if (value != SELECTED) {
                if (firstAffectedIndex == -1) {
                    firstAffectedIndex = i.getIndex();
                }
                lastAffectedIndex = i.getIndex();
                this.addSelectEvent(i);
            }
            ++currentIndex;
        }
        this.commitAll();
        if (firstAffectedIndex > -1) {
            this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
        }
    }

    public int select(E value) {
        int index = this.source.indexOf(value);
        if (index != -1) {
            this.select(index);
        }
        return index;
    }

    public boolean select(Collection<E> values) {
        TreeSet<Integer> indicesToSelect = new TreeSet<Integer>();
        for (E value : values) {
            int index = this.source.indexOf(value);
            if (index == -1) continue;
            indicesToSelect.add(new Integer(index));
        }
        if (indicesToSelect.isEmpty()) {
            return false;
        }
        int[] indicesToSelectAsInts = new int[indicesToSelect.size()];
        int arrayIndex = 0;
        for (Integer selectIndex : indicesToSelect) {
            indicesToSelectAsInts[arrayIndex] = selectIndex;
            ++arrayIndex;
        }
        int selectionSizeBefore = this.getSelected().size();
        this.select(indicesToSelectAsInts);
        int selectionSizeAfter = this.getSelected().size();
        return selectionSizeAfter > selectionSizeBefore;
    }

    public void selectAll() {
        this.setAllColor(SELECTED);
    }

    public void setSelection(int index) {
        this.setSelection(index, index);
    }

    public void setSelection(int start, int end) {
        if (start == -1 || end == -1) {
            this.deselectAll();
            return;
        }
        if (this.selectionMode == 0) {
            end = start;
        }
        int oldAnchor = this.anchorSelectionIndex == start ? -1 : this.anchorSelectionIndex;
        int oldLead = this.leadSelectionIndex == end ? -1 : this.leadSelectionIndex;
        this.anchorSelectionIndex = start;
        this.leadSelectionIndex = end;
        this.setSubRangeOfRange(true, start, end, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), oldLead, oldAnchor);
    }

    public void setSelection(int[] indices) {
        if (indices.length == 0) {
            this.deselectAll();
            return;
        }
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.beginAll();
        int currentIndex = 0;
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (i.getIndex() == indices[currentIndex]) {
                if (value != SELECTED) {
                    if (firstAffectedIndex == -1) {
                        firstAffectedIndex = i.getIndex();
                    }
                    lastAffectedIndex = i.getIndex();
                    this.addSelectEvent(i);
                }
                if (currentIndex >= indices.length - 1) continue;
                ++currentIndex;
                continue;
            }
            if (value != SELECTED) continue;
            if (firstAffectedIndex == -1) {
                firstAffectedIndex = i.getIndex();
            }
            lastAffectedIndex = i.getIndex();
            this.addDeselectEvent(i);
        }
        this.commitAll();
        if (firstAffectedIndex > -1) {
            this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
        }
    }

    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    public void setAnchorSelectionIndex(int anchorSelectionIndex) {
        int oldAnchor = this.anchorSelectionIndex == anchorSelectionIndex ? -1 : anchorSelectionIndex;
        this.anchorSelectionIndex = anchorSelectionIndex;
        if (anchorSelectionIndex == -1 || this.leadSelectionIndex == -1) {
            this.deselectAll();
        } else if (this.selectionMode == 0) {
            this.setSubRangeOfRange(true, anchorSelectionIndex, anchorSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), -1, oldAnchor);
        } else if (this.selectionMode == 1) {
            this.setSubRangeOfRange(true, anchorSelectionIndex, this.leadSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), -1, oldAnchor);
        } else {
            this.setSubRangeOfRange(true, anchorSelectionIndex, this.leadSelectionIndex, -1, -1, -1, oldAnchor);
        }
    }

    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    public void setLeadSelectionIndex(int leadSelectionIndex) {
        int oldLead = this.leadSelectionIndex == leadSelectionIndex ? -1 : leadSelectionIndex;
        int originalLeadIndex = this.leadSelectionIndex;
        this.leadSelectionIndex = leadSelectionIndex;
        if (leadSelectionIndex == -1 || this.anchorSelectionIndex == -1) {
            this.deselectAll();
        } else if (this.selectionMode == 0) {
            this.setSubRangeOfRange(true, leadSelectionIndex, leadSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), oldLead, -1);
        } else if (this.selectionMode == 1) {
            this.setSubRangeOfRange(true, this.anchorSelectionIndex, leadSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), oldLead, -1);
        } else {
            this.setSubRangeOfRange(true, this.anchorSelectionIndex, leadSelectionIndex, this.anchorSelectionIndex, originalLeadIndex, oldLead, -1);
        }
    }

    private void addSelectedReorder(int[] selectReorderMap) {
        if (this.selectedList != null) {
            this.selectedList.updates().reorder(selectReorderMap);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().reorder(selectReorderMap);
        }
    }

    private void addDeselectedReorder(int[] deselectReorderMap) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().reorder(deselectReorderMap);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().reorder(deselectReorderMap);
        }
    }

    private void addSelectEvent(BarcodeIterator i) {
        Object value = this.source.get(i.getIndex());
        int deselectedIndex = i.getColourIndex(DESELECTED);
        int selectedIndex = i.set(SELECTED);
        this.addSelectEvent(selectedIndex, deselectedIndex, value);
    }

    private void addSelectEvent(int selectIndex, int deselectIndex, E value) {
        this.addDeselectedDelete(deselectIndex, value);
        this.addSelectedInsert(selectIndex, value);
    }

    private void addDeselectEvent(BarcodeIterator i) {
        Object value = this.source.get(i.getIndex());
        int selectedIndex = i.getColourIndex(SELECTED);
        int deselectedIndex = i.set(DESELECTED);
        this.addDeselectEvent(selectedIndex, deselectedIndex, value);
    }

    private void addDeselectEvent(int selectIndex, int deselectIndex, E value) {
        this.addSelectedDelete(selectIndex, value);
        this.addDeselectedInsert(deselectIndex, value);
    }

    private void addSelectedInsert(int index, E newValue) {
        if (this.selectedList != null) {
            this.selectedList.updates().elementInserted(index, newValue);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().elementInserted(index, newValue);
        }
    }

    private void addSelectedUpdate(int index, E oldValue, E newValue) {
        if (this.selectedList != null) {
            this.selectedList.updates().elementUpdated(index, oldValue, newValue);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().elementUpdated(index, oldValue, newValue);
        }
    }

    private void addSelectedDelete(int index, E oldValue) {
        if (this.selectedList != null) {
            this.selectedList.updates().elementDeleted(index, oldValue);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().elementDeleted(index, oldValue);
        }
    }

    private void addDeselectedInsert(int index, E value) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().elementInserted(index, value);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().elementInserted(index, value);
        }
    }

    private void addDeselectedDelete(int index, E oldValue) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().elementDeleted(index, oldValue);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().elementDeleted(index, oldValue);
        }
    }

    private void addDeselectedUpdate(int index, E oldValue, E newValue) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().elementUpdated(index, oldValue, newValue);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().elementUpdated(index, oldValue, newValue);
        }
    }

    private void beginAll() {
        this.beginSelected();
        this.beginDeselected();
    }

    private void commitAll() {
        this.commitSelected();
        this.commitDeselected();
    }

    private void beginSelected() {
        if (this.selectedList != null) {
            this.selectedList.updates().beginEvent();
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().beginEvent();
        }
    }

    private void commitSelected() {
        if (this.selectedList != null) {
            this.selectedList.updates().commitEvent();
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().commitEvent();
        }
    }

    private void beginDeselected() {
        if (this.deselectedList != null) {
            this.deselectedList.updates().beginEvent();
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().beginEvent();
        }
    }

    private void commitDeselected() {
        if (this.deselectedList != null) {
            this.deselectedList.updates().commitEvent();
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().commitEvent();
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        this.setSelection(this.getMinSelectionIndex(), this.getMaxSelectionIndex());
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public int getMinSelectionIndex() {
        if (this.barcode.colourSize(SELECTED) == 0) {
            return -1;
        }
        return this.barcode.getIndex(0, SELECTED);
    }

    public int getMaxSelectionIndex() {
        if (this.barcode.colourSize(SELECTED) == 0) {
            return -1;
        }
        return this.barcode.getIndex(this.barcode.colourSize(SELECTED) - 1, SELECTED);
    }

    private void setSubRangeOfRange(boolean select, int changeIndex0, int changeIndex1, int invertIndex0, int invertIndex1, int oldLead, int oldAnchor) {
        if (changeIndex0 >= this.source.size() || changeIndex1 >= this.source.size() || (changeIndex0 == -1 || changeIndex1 == -1) && changeIndex0 != changeIndex1) {
            throw new IndexOutOfBoundsException("Invalid range for selection: " + changeIndex0 + "-" + changeIndex1 + ", list size is " + this.source.size());
        }
        if (invertIndex0 >= this.source.size() || invertIndex1 >= this.source.size() || (invertIndex0 == -1 || invertIndex1 == -1) && invertIndex0 != invertIndex1) {
            throw new IndexOutOfBoundsException("Invalid range for invert selection: " + invertIndex0 + "-" + invertIndex1 + ", list size is " + this.source.size());
        }
        if (changeIndex0 == -1 && changeIndex1 == -1) {
            if (invertIndex0 == -1 && invertIndex1 == -1) {
                return;
            }
            changeIndex0 = invertIndex0;
            changeIndex1 = invertIndex1;
            boolean bl = select = !select;
        }
        if (invertIndex0 == -1 && invertIndex1 == -1) {
            invertIndex0 = changeIndex0;
            invertIndex1 = changeIndex1;
        }
        int minChangeIndex = Math.min(changeIndex0, changeIndex1);
        int maxChangeIndex = Math.max(changeIndex0, changeIndex1);
        int minInvertIndex = Math.min(invertIndex0, invertIndex1);
        int maxInvertIndex = Math.max(invertIndex0, invertIndex1);
        int minUnionIndex = Math.min(minChangeIndex, minInvertIndex);
        int maxUnionIndex = Math.max(maxChangeIndex, maxInvertIndex);
        int minChangedIndex = maxUnionIndex + 1;
        int maxChangedIndex = minUnionIndex - 1;
        this.beginAll();
        for (int i = minUnionIndex; i <= maxUnionIndex; ++i) {
            boolean selectedAfter;
            int selectionIndex = this.barcode.getColourIndex(i, SELECTED);
            boolean selectedBefore = selectionIndex != -1;
            boolean inChangeRange = i >= minChangeIndex && i <= maxChangeIndex;
            boolean bl = selectedAfter = inChangeRange == select;
            if (selectedBefore == selectedAfter) continue;
            Object value = this.source.get(i);
            if (i < minChangedIndex) {
                minChangedIndex = i;
            }
            if (i > maxChangedIndex) {
                maxChangedIndex = i;
            }
            if (selectedBefore) {
                this.barcode.set(i, DESELECTED, 1);
                this.addDeselectEvent(selectionIndex, i - selectionIndex, value);
                continue;
            }
            this.barcode.set(i, SELECTED, 1);
            int newSelectionIndex = this.barcode.getColourIndex(i, SELECTED);
            this.addSelectEvent(newSelectionIndex, i - newSelectionIndex, value);
        }
        this.commitAll();
        if (oldLead != -1) {
            minChangedIndex = Math.min(minChangedIndex, oldLead);
            maxChangedIndex = Math.max(maxChangedIndex, oldLead);
        }
        if (oldAnchor != -1) {
            minChangedIndex = Math.min(minChangedIndex, oldAnchor);
            maxChangedIndex = Math.max(maxChangedIndex, oldAnchor);
        }
        if (minChangedIndex <= maxChangedIndex) {
            this.fireSelectionChanged(minChangedIndex, maxChangedIndex);
        }
    }

    public void addSelectionListener(Listener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(Listener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    private void fireSelectionChanged(int start, int end) {
        Iterator<Listener> i = this.selectionListeners.iterator();
        while (i.hasNext()) {
            i.next().selectionChanged(start, end);
        }
    }

    public void dispose() {
        this.source.removeListEventListener(this);
        this.selectionListeners.clear();
        if (this.selectedList != null) {
            this.source.getPublisher().clearRelatedListener(this.selectedList, this);
        }
        if (this.deselectedList != null) {
            this.source.getPublisher().clearRelatedListener(this.deselectedList, this);
        }
        if (this.selectedToggleList != null) {
            this.source.getPublisher().clearRelatedListener(this.selectedToggleList, this);
        }
        if (this.deselectedToggleList != null) {
            this.source.getPublisher().clearRelatedListener(this.deselectedToggleList, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeselectionToggleList<E>
    extends DeselectedList<E> {
        DeselectionToggleList(EventList<E> source) {
            super(source);
        }

        @Override
        public E set(int index, E item) {
            throw new UnsupportedOperationException("Toggling lists don't support setting items");
        }

        @Override
        public void add(int index, E item) {
            index = this.source.indexOf(item);
            if (index == -1) {
                throw new IllegalArgumentException("Added item " + item + " must be in source list");
            }
            ListSelection.this.deselect(index);
        }

        @Override
        public E remove(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
            }
            int sourceIndex = this.getSourceIndex(index);
            ListSelection.this.select(sourceIndex);
            return this.source.get(sourceIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeselectedList<E>
    extends TransformedList<E, E> {
        DeselectedList(EventList<E> source) {
            super(source);
        }

        @Override
        public int size() {
            return ListSelection.this.barcode.colourSize(DESELECTED);
        }

        @Override
        protected int getSourceIndex(int mutationIndex) {
            return ListSelection.this.barcode.getIndex(mutationIndex, DESELECTED);
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
        }

        public ListEventAssembler<E> updates() {
            return this.updates;
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public void dispose() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionToggleList<E>
    extends SelectedList<E> {
        SelectionToggleList(EventList<E> source) {
            super(source);
        }

        @Override
        public E set(int index, E item) {
            throw new UnsupportedOperationException("Toggling lists don't support setting items");
        }

        @Override
        public void add(int index, E item) {
            index = this.source.indexOf(item);
            if (index == -1) {
                throw new IllegalArgumentException("Added item " + item + " must be in source list");
            }
            ListSelection.this.select(index);
        }

        @Override
        public E remove(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
            }
            int sourceIndex = this.getSourceIndex(index);
            ListSelection.this.deselect(sourceIndex);
            return this.source.get(sourceIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectedList<E>
    extends TransformedList<E, E> {
        SelectedList(EventList<E> source) {
            super(source);
        }

        @Override
        public int size() {
            return ListSelection.this.barcode.colourSize(SELECTED);
        }

        @Override
        protected int getSourceIndex(int mutationIndex) {
            return ListSelection.this.barcode.getIndex(mutationIndex, SELECTED);
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
        }

        public ListEventAssembler<E> updates() {
            return this.updates;
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public void dispose() {
        }
    }

    public static interface Listener {
        public void selectionChanged(int var1, int var2);
    }
}

