/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.jfreechart.TreePair;
import ca.odell.glazedlists.jfreechart.ValueSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventListCategoryDataset<R extends Comparable, C extends Comparable>
extends AbstractDataset
implements CategoryDataset,
ListEventListener<ValueSegment<C, R>> {
    private final DatasetChangeEvent immutableChangeEvent = new DatasetChangeEvent((Object)this, (Dataset)this);
    private final List<ValueSegment<C, R>> sourceCopy;
    private final EventList<ValueSegment<C, R>> source;
    protected List<? extends Comparable> rowKeys;
    protected List<? extends Comparable> columnKeys;
    private Map<R, TreePair<C>> valueToTreePairs = new HashMap<R, TreePair<C>>();

    public EventListCategoryDataset(EventList<ValueSegment<C, R>> source) {
        this.source = source;
        this.sourceCopy = new ArrayList<ValueSegment<C, R>>(source.size());
        this.sourceCopy.addAll(source);
        this.rebuildRowAndColumnKeyList();
        this.source.addListEventListener(this);
    }

    private void rebuildRowAndColumnKeyList() {
        this.columnKeys = this.createColumnKeyList();
        this.rowKeys = this.createRowKeyList();
    }

    protected List<? extends Comparable> createRowKeyList() {
        return new ArrayList();
    }

    protected List<? extends Comparable> createColumnKeyList() {
        return new ArrayList();
    }

    public Comparable getRowKey(int row) {
        return this.rowKeys.get(row);
    }

    public int getRowIndex(Comparable key) {
        return this.rowKeys.indexOf(key);
    }

    public List getRowKeys() {
        return this.rowKeys;
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public Comparable getColumnKey(int column) {
        return this.columnKeys.get(column);
    }

    public int getColumnIndex(Comparable key) {
        return this.columnKeys.indexOf(key);
    }

    public List getColumnKeys() {
        return this.columnKeys;
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(int row, int column) {
        return this.getValue(this.getRowKey(row), this.getColumnKey(column));
    }

    public abstract Number getValue(Comparable var1, Comparable var2);

    public void dispose() {
        this.source.removeListEventListener(this);
    }

    private void clear() {
        this.sourceCopy.clear();
        this.valueToTreePairs.clear();
        this.rowKeys.clear();
        this.rebuildRowAndColumnKeyList();
    }

    private TreePair<C> getTreePair(R rowKey) {
        return this.valueToTreePairs.get(rowKey);
    }

    public int getCount(R rowKey) {
        TreePair<C> treePair = this.getTreePair(rowKey);
        return treePair == null ? 0 : treePair.size();
    }

    public int getCount(R rowKey, C start, C end) {
        TreePair<C> treePair = this.getTreePair(rowKey);
        if (treePair == null) {
            throw new UnknownKeyException("unrecognized rowKey: " + rowKey);
        }
        return treePair.getCount(start, end);
    }

    protected void postInsert(ValueSegment<C, R> valueSegment) {
    }

    protected void postDelete(ValueSegment<C, R> valueSegment) {
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(this.immutableChangeEvent);
    }

    @Override
    public void listChanged(ListEvent<ValueSegment<C, R>> listChanges) {
        if (listChanges.getSourceList().isEmpty()) {
            this.clear();
        } else {
            while (listChanges.next()) {
                TreePair<Object> treePair;
                ValueSegment<C, R> segment;
                int type = listChanges.getType();
                int index = listChanges.getIndex();
                if (type == 2) {
                    segment = (ValueSegment<C, R>)listChanges.getSourceList().get(index);
                    treePair = this.getTreePair(segment.getValue());
                    if (treePair == null) {
                        treePair = new TreePair();
                        this.valueToTreePairs.put(segment.getValue(), treePair);
                    }
                    treePair.insert(segment);
                    this.sourceCopy.add(index, segment);
                    this.postInsert(segment);
                    continue;
                }
                if (type == 1) {
                    ValueSegment newSegment = (ValueSegment)listChanges.getSourceList().get(index);
                    ValueSegment oldSegment = this.sourceCopy.set(index, newSegment);
                    TreePair<C> oldTreePair = this.getTreePair(oldSegment.getValue());
                    TreePair<C> newTreePair = this.getTreePair(newSegment.getValue());
                    oldTreePair.delete(oldSegment);
                    this.postDelete(oldSegment);
                    newTreePair.insert(newSegment);
                    this.postInsert(newSegment);
                    continue;
                }
                if (type != 0) continue;
                segment = this.sourceCopy.remove(index);
                treePair = this.getTreePair(segment.getValue());
                treePair.delete(segment);
                this.postDelete(segment);
            }
        }
        this.fireDatasetChanged();
    }
}

