/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.TMUtil;

public interface Index
extends Node.Cookie {
    public int getNodesCount();

    public Node[] getNodes();

    public int indexOf(Node var1);

    public void reorder();

    public void reorder(int[] var1);

    public void move(int var1, int var2);

    public void exchange(int var1, int var2);

    public void moveUp(int var1);

    public void moveDown(int var1);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class KeysChildren<T>
    extends Children.Keys<T> {
        private Index support;
        protected final List<T> list;

        public KeysChildren(List<T> list) {
            this.list = list;
            this.update();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Index getIndex() {
            KeysChildren keysChildren = this;
            synchronized (keysChildren) {
                if (this.support == null) {
                    this.support = this.createIndex();
                }
                return this.support;
            }
        }

        protected Index createIndex() {
            return new Support(){

                public Node[] getNodes() {
                    List<Node> list = Arrays.asList(KeysChildren.this.getNodes());
                    if (KeysChildren.this.nodes != null) {
                        list.removeAll(KeysChildren.this.nodes);
                    }
                    return list.toArray(new Node[list.size()]);
                }

                public int getNodesCount() {
                    return KeysChildren.this.list.size();
                }

                public void reorder(int[] nArray) {
                    KeysChildren.this.reorder(nArray);
                    KeysChildren.this.update();
                    this.fireChangeEvent(new ChangeEvent(this));
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reorder(int[] nArray) {
            Object object = this.lock();
            synchronized (object) {
                ArrayList<T> arrayList = new ArrayList<T>(this.list);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.list.set(nArray[i], arrayList.get(i));
                }
            }
        }

        protected Object lock() {
            return this.list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void update() {
            ArrayList<T> arrayList;
            Object object = this.lock();
            synchronized (object) {
                arrayList = new ArrayList<T>(this.list);
            }
            super.setKeys(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayChildren
    extends Children.Array
    implements Index {
        protected Index support = new Support(){

            public Node[] getNodes() {
                return ArrayChildren.this.getNodes();
            }

            public int getNodesCount() {
                return ArrayChildren.this.getNodesCount();
            }

            public void reorder(int[] nArray) {
                ArrayChildren.this.reorder(nArray);
                this.fireChangeEvent(new ChangeEvent(ArrayChildren.this));
            }
        };

        public ArrayChildren() {
            this((List<Node>)null);
        }

        private ArrayChildren(List<Node> list) {
            super(list);
        }

        protected List<Node> initCollection() {
            return new ArrayList<Node>();
        }

        @Override
        public void reorder(final int[] nArray) {
            MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    Node[] nodeArray = ArrayChildren.this.nodes.toArray(new Node[ArrayChildren.this.nodes.size()]);
                    List list = (List)ArrayChildren.this.nodes;
                    for (int i = 0; i < nodeArray.length; ++i) {
                        list.set(nArray[i], nodeArray[i]);
                    }
                    ArrayChildren.this.refresh();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reorder() {
            try {
                PR.enterReadAccess();
                Support.showIndexedCustomizer(this);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                PR.exitReadAccess();
                throw throwable;
            }
            PR.exitReadAccess();
        }

        @Override
        public void move(int n, int n2) {
            this.support.move(n, n2);
        }

        @Override
        public void exchange(int n, int n2) {
            this.support.exchange(n, n2);
        }

        @Override
        public void moveUp(int n) {
            this.support.exchange(n, n - 1);
        }

        @Override
        public void moveDown(int n) {
            this.support.exchange(n, n + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Node node) {
            int n;
            try {
                PR.enterReadAccess();
                n = ((List)this.nodes).indexOf(node);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                PR.exitReadAccess();
                throw throwable;
            }
            PR.exitReadAccess();
            return n;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.support.addChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.support.removeChangeListener(changeListener);
        }
    }

    public static abstract class Support
    implements Index {
        private HashSet<ChangeListener> listeners;

        public void move(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            if (n == n2) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i < n && i < n2 || i > n && i > n2 ? i : (i > n && i < n2 ? i - 1 : i + 1);
            }
            nArray[n] = n2;
            nArray[n2] = n < n2 ? n2 - 1 : n2 + 1;
            this.reorder(nArray);
        }

        public void exchange(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            nArray[n] = n2;
            nArray[n2] = n;
            this.reorder(nArray);
        }

        public void moveUp(int n) {
            this.exchange(n, n - 1);
        }

        public void moveDown(int n) {
            this.exchange(n, n + 1);
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new HashSet();
            }
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireChangeEvent(ChangeEvent changeEvent) {
            HashSet hashSet;
            if (this.listeners == null) {
                return;
            }
            Object object = this;
            synchronized (object) {
                hashSet = (HashSet)this.listeners.clone();
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                ((ChangeListener)object.next()).stateChanged(changeEvent);
            }
        }

        public abstract Node[] getNodes();

        public int indexOf(Node node) {
            Node[] nodeArray = this.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!node.equals(nodeArray[i])) continue;
                return i;
            }
            return -1;
        }

        public void reorder() {
            Support.showIndexedCustomizer(this);
        }

        public static void showIndexedCustomizer(Index index) {
            TMUtil.showIndexedCustomizer(index);
        }

        public abstract int getNodesCount();

        public abstract void reorder(int[] var1);
    }
}

