/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.extract.Param;
import tr.extract.ParamFont;
import tr.view.actions.prefs.ActionsOptionsPanelController;
import tr.view.actions.prefs.ActionsPrefs;

final class ActionsPrefsPanel
extends JPanel {
    private final ActionsOptionsPanelController controller;
    private JLabel titleLabel;
    private JLabel fontLabel;
    private JComboBox fontCombo;
    private JCheckBox colourCheck;
    private JCheckBox strikeCheck;
    private Vector<Param.Item> items;

    ActionsPrefsPanel(ActionsOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    void load() {
        this.colourCheck.setSelected(ActionsPrefs.isReportUseColour());
        this.strikeCheck.setSelected(ActionsPrefs.isReportStrikeDone());
        this.items = (Vector)new ParamFont(null, null).getItems();
        this.fontCombo.setModel(new DefaultComboBoxModel<Param.Item>(this.items));
        String font = ActionsPrefs.getReportFont();
        for (Param.Item item : this.items) {
            if (!item.value.equals(font)) continue;
            this.fontCombo.setSelectedItem(item);
            break;
        }
    }

    void store() {
        ActionsPrefs.setReportUseColour(this.colourCheck.isSelected());
        ActionsPrefs.setReportStrikeDone(this.strikeCheck.isSelected());
        Param.Item item = (Param.Item)this.fontCombo.getSelectedItem();
        if (item != null) {
            ActionsPrefs.setReportFont(item.value);
        }
    }

    boolean valid() {
        return true;
    }

    private void initForm() {
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.titleLabel = new JLabel(this.getMsg("report.heading"));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.fontLabel = new JLabel(this.getMsg("report.font"));
        this.fontCombo = new JComboBox();
        this.fontCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsPrefsPanel.this.controller.changed();
            }
        });
        this.colourCheck = new JCheckBox(this.getMsg("use.color"));
        this.strikeCheck = new JCheckBox(this.getMsg("strike.done"));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]0", "0[]4[]2[]2[]0"));
        panel.add((Component)this.titleLabel, "align left, wrap");
        panel.add((Component)this.fontLabel, "align left, split 2");
        panel.add((Component)this.fontCombo, "align left, wrap");
        panel.add((Component)this.colourCheck, "align left, wrap");
        panel.add((Component)this.strikeCheck, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(ActionsPrefsPanel.class, (String)key);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

