/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.dnd.DragAndDropFeedbackVisualizer;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.SlideBar;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.openide.util.ChangeSupport;
import org.openide.windows.TopComponent;

public final class TabbedSlideAdapter
implements Tabbed {
    private TabDataModel dataModel;
    private SingleSelectionModel selModel;
    private SlideBar slideBar;
    private List<ActionListener> actionListeners;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    public TabbedSlideAdapter(String string) {
        this.dataModel = new SlideBarDataModel.Impl();
        this.setSide(string);
        this.selModel = new DefaultSingleSelectionModel();
        this.slideBar = new SlideBar(this, (SlideBarDataModel)this.dataModel, this.selModel);
    }

    public void requestAttention(TopComponent topComponent) {
        this.slideBar.setBlinking(topComponent, true);
    }

    public void cancelRequestAttention(TopComponent topComponent) {
        this.slideBar.setBlinking(topComponent, false);
    }

    private void setSide(String string) {
        int n = 2;
        if ("left".equals(string)) {
            n = 2;
        } else if ("right".equals(string)) {
            n = 1;
        } else if ("bottom".equals(string)) {
            n = 3;
        }
        ((SlideBarDataModel)this.dataModel).setOrientation(n);
    }

    public final synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(actionListener);
    }

    public final synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(actionListener);
            if (this.actionListeners.isEmpty()) {
                this.actionListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void postActionEvent(ActionEvent actionEvent) {
        List<ActionListener> list;
        TabbedSlideAdapter tabbedSlideAdapter = this;
        synchronized (tabbedSlideAdapter) {
            if (this.actionListeners == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListeners);
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).actionPerformed(actionEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    final void postSelectionEvent() {
        this.cs.fireChange();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.slideBar.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.slideBar.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addTopComponent(String string, Icon icon, TopComponent topComponent, String string2) {
        this.dataModel.addTab(this.dataModel.size(), new TabData((Object)topComponent, icon, string, string2));
    }

    public TopComponent getSelectedTopComponent() {
        int n = this.selModel.getSelectedIndex();
        return n < 0 ? null : (TopComponent)this.dataModel.getTab(n).getComponent();
    }

    public TopComponent getTopComponentAt(int n) {
        return (TopComponent)this.dataModel.getTab(n).getComponent();
    }

    public TopComponent[] getTopComponents() {
        int n = this.dataModel.size();
        TopComponent[] topComponentArray = new TopComponent[n];
        for (int i = 0; i < n; ++i) {
            topComponentArray[i] = (TopComponent)this.dataModel.getTab(i).getComponent();
        }
        return topComponentArray;
    }

    public void setActive(boolean bl) {
        this.slideBar.setActive(bl);
    }

    public void setIconAt(int n, Icon icon) {
        this.dataModel.setIcon(n, icon);
    }

    public void setTitleAt(int n, String string) {
        this.dataModel.setText(n, string);
    }

    public void setToolTipTextAt(int n, String string) {
    }

    public void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        TabData[] tabDataArray = new TabData[topComponentArray.length];
        int n = -1;
        for (int i = 0; i < topComponentArray.length; ++i) {
            TopComponent topComponent2 = topComponentArray[i];
            Image image = topComponent2.getIcon();
            String string = WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent2);
            tabDataArray[i] = new TabData((Object)topComponent2, (Icon)(image == null ? null : new ImageIcon(image)), string == null ? "" : string, topComponent2.getToolTipText());
            if (topComponent != topComponentArray[i]) continue;
            n = i;
        }
        this.dataModel.setTabs(tabDataArray);
        this.setSelectedComponent((Component)topComponent);
    }

    public int getTabCount() {
        return this.dataModel.size();
    }

    public int indexOf(Component component) {
        int n = this.dataModel.size();
        for (int i = 0; i < n; ++i) {
            if (component != this.dataModel.getTab(i).getComponent()) continue;
            return i;
        }
        return -1;
    }

    public void insertComponent(String string, Icon icon, Component component, String string2, int n) {
        this.dataModel.addTab(n, new TabData((Object)component, icon, string, string2));
    }

    public void removeComponent(Component component) {
        int n = this.indexOf(component);
        this.dataModel.removeTab(n);
    }

    public void setSelectedComponent(Component component) {
        int n = this.indexOf(component);
        if (this.selModel.getSelectedIndex() != n) {
            this.selModel.setSelectedIndex(n);
        }
        if (component instanceof TopComponent) {
            TopComponent topComponent = (TopComponent)component;
            topComponent.cancelRequestAttention();
        }
    }

    public int tabForCoordinate(Point point) {
        return this.slideBar.tabForCoordinate(point.x, point.y);
    }

    public Component getComponent() {
        return this.slideBar;
    }

    public Object getConstraintForLocation(Point point, boolean bl) {
        int n = this.slideBar.nextTabForCoordinate(point.x, point.y);
        return n;
    }

    public Shape getIndicationForLocation(Point point, TopComponent topComponent, Point point2, boolean bl) {
        int n = this.slideBar.nextTabForCoordinate(point.x, point.y);
        SlideBarDataModel slideBarDataModel = (SlideBarDataModel)this.dataModel;
        if (this.getTabCount() != 0) {
            if (n == 0) {
                Rectangle rectangle = this.getTabBounds(0);
                if (slideBarDataModel.getOrientation() == 3) {
                    rectangle.x = 0;
                    rectangle.width /= 2;
                } else {
                    rectangle.y = 0;
                    rectangle.height /= 2;
                }
                return rectangle;
            }
            if (n < this.getTabCount()) {
                Rectangle rectangle = this.getTabBounds(n - 1);
                Rectangle rectangle2 = this.getTabBounds(n);
                Rectangle rectangle3 = new Rectangle();
                if (slideBarDataModel.getOrientation() == 3) {
                    rectangle3.y = rectangle.y;
                    rectangle3.height = rectangle.height;
                    rectangle3.x = rectangle.x + rectangle.width / 2;
                    rectangle3.width = rectangle2.x + rectangle2.width / 2 - rectangle3.x;
                } else {
                    rectangle3.x = rectangle.x;
                    rectangle3.width = rectangle.width;
                    rectangle3.y = rectangle.y + rectangle.height / 2;
                    rectangle3.height = rectangle2.y + rectangle2.height / 2 - rectangle3.y;
                }
                return rectangle3;
            }
            if (n == this.getTabCount()) {
                Rectangle rectangle = this.getTabBounds(this.getTabCount() - 1);
                if (slideBarDataModel.getOrientation() == 3) {
                    rectangle.x += rectangle.width;
                } else {
                    rectangle.y += rectangle.height;
                }
                return rectangle;
            }
        }
        Rectangle rectangle = this.slideBar.getBounds();
        if (slideBarDataModel.getOrientation() == 3) {
            return new Rectangle(10, 0, 50, 20);
        }
        return new Rectangle(0, 10, 20, 50);
    }

    public Image createImageOfTab(int n) {
        TabData tabData = this.slideBar.getModel().getTab(n);
        if (tabData.getComponent() instanceof TopComponent) {
            DefaultTabDataModel defaultTabDataModel = new DefaultTabDataModel(new TabData[]{tabData});
            TabbedContainer tabbedContainer = new TabbedContainer((TabDataModel)defaultTabDataModel, 0);
            tabbedContainer.setSize(300, 300);
            return tabbedContainer.createImageOfTab(0);
        }
        return null;
    }

    public DragAndDropFeedbackVisualizer getDragAndDropFeedbackVisualizer(int n) {
        this.slideBar.getSelectionModel().setSelectedIndex(n);
        return new DragAndDropFeedbackVisualizer(this, n);
    }

    public Action[] getPopupActions(Action[] actionArray, int n) {
        boolean bl = WindowManagerImpl.getInstance().getEditorAreaState() == 0;
        Action[] actionArray2 = new Action[actionArray.length + (bl && Switches.isTopComponentSlidingEnabled() ? 2 : 0)];
        System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
        if (bl && Switches.isTopComponentSlidingEnabled()) {
            actionArray2[actionArray.length] = new ActionUtils.AutoHideWindowAction(this.slideBar, n, true);
            actionArray2[actionArray.length + 1] = new ActionUtils.ToggleWindowTransparencyAction(this.slideBar, n, this.slideBar.isSlidedTabTransparent() && n == this.slideBar.getSelectionModel().getSelectedIndex());
        }
        return actionArray2;
    }

    public Rectangle getTabBounds(int n) {
        return this.slideBar.getTabBounds(n);
    }

    public boolean isTransparent() {
        return false;
    }

    public void setTransparent(boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

