/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Arrays;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnfoldingReader
extends PushbackReader {
    private Log log = LogFactory.getLog((Class)UnfoldingReader.class);
    private static final char[] DEFAULT_FOLD_PATTERN = new char[]{'\r', '\n', ' '};
    private static final char[] RELAXED_FOLD_PATTERN_1 = new char[]{'\n', ' '};
    private static final char[] RELAXED_FOLD_PATTERN_2 = new char[]{'\r', '\n', '\t'};
    private static final char[] RELAXED_FOLD_PATTERN_3 = new char[]{'\n', '\t'};
    private char[][] patterns;
    private char[][] buffers;
    private int linesUnfolded;
    private int maxPatternLength = 0;

    public UnfoldingReader(Reader in) {
        this(in, DEFAULT_FOLD_PATTERN.length, CompatibilityHints.isHintEnabled("ical4j.unfolding.relaxed"));
    }

    public UnfoldingReader(Reader in, int size) {
        this(in, size, CompatibilityHints.isHintEnabled("ical4j.unfolding.relaxed"));
    }

    public UnfoldingReader(Reader in, boolean relaxed) {
        this(in, DEFAULT_FOLD_PATTERN.length, relaxed);
    }

    public UnfoldingReader(Reader in, int size, boolean relaxed) {
        super(in, size);
        if (relaxed) {
            this.patterns = new char[4][];
            this.patterns[0] = DEFAULT_FOLD_PATTERN;
            this.patterns[1] = RELAXED_FOLD_PATTERN_1;
            this.patterns[2] = RELAXED_FOLD_PATTERN_2;
            this.patterns[3] = RELAXED_FOLD_PATTERN_3;
        } else {
            this.patterns = new char[1][];
            this.patterns[0] = DEFAULT_FOLD_PATTERN;
        }
        this.buffers = new char[this.patterns.length][];
        for (int i = 0; i < this.patterns.length; ++i) {
            this.buffers[i] = new char[this.patterns[i].length];
            this.maxPatternLength = Math.max(this.maxPatternLength, this.patterns[i].length);
        }
    }

    public final int getLinesUnfolded() {
        return this.linesUnfolded;
    }

    public final int read() throws IOException {
        int c = super.read();
        boolean doUnfold = false;
        for (int i = 0; i < this.patterns.length; ++i) {
            if (c != this.patterns[i][0]) continue;
            doUnfold = true;
            break;
        }
        if (!doUnfold) {
            return c;
        }
        this.unread(c);
        this.unfold();
        return super.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        boolean doUnfold = false;
        for (int i = 0; i < this.patterns.length; ++i) {
            if (read > 0 && cbuf[0] == this.patterns[i][0]) {
                doUnfold = true;
                break;
            }
            for (int j = 0; j < read; ++j) {
                if (cbuf[j] != this.patterns[i][0]) continue;
                this.unread(cbuf, j, read - j);
                return j;
            }
        }
        if (!doUnfold) {
            return read;
        }
        this.unread(cbuf, off, read);
        this.unfold();
        return super.read(cbuf, off, this.maxPatternLength);
    }

    private void unfold() throws IOException {
        boolean didUnfold;
        do {
            didUnfold = false;
            for (int i = 0; i < this.buffers.length; ++i) {
                int read = super.read(this.buffers[i], 0, this.buffers[i].length);
                if (read <= 0) continue;
                if (!Arrays.equals(this.patterns[i], this.buffers[i])) {
                    this.unread(this.buffers[i], 0, read);
                    continue;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Unfolding...");
                }
                ++this.linesUnfolded;
                didUnfold = true;
            }
        } while (didUnfold);
    }
}

