/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.UserQuestionException;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class CloneableEditor
extends CloneableTopComponent
implements CloneableEditorSupport.Pane {
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    protected JEditorPane pane;
    private CloneableEditorSupport support;
    private boolean initialized;
    private int cursorPosition = -1;
    private Component customComponent;
    private JToolBar customToolbar;
    private DoInitialize doInitialize;
    private static final Logger LOG = Logger.getLogger("org.openide.text.CloneableEditor");
    static final Logger TIMER = Logger.getLogger("TIMER");

    public CloneableEditor() {
        this(null);
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport) {
        this.support = cloneableEditorSupport;
        this.updateName();
        this._setCloseOperation();
        this.setMinimumSize(new Dimension(10, 10));
    }

    private void _setCloseOperation() {
        this.setCloseOperation(0);
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx;
        EditorKit editorKit = this.support.cesKit();
        HelpCtx helpCtx2 = helpCtx = editorKit == null ? null : HelpCtx.findHelp((Object)editorKit);
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose() {
        boolean bl = super.canClose();
        return bl;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.initialize();
    }

    private void initialize() {
        if (this.initialized || this.discard()) {
            return;
        }
        QuietEditorPane quietEditorPane = new QuietEditorPane();
        quietEditorPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CloneableEditor.class, (String)"ACS_CloneableEditor_QuietEditorPane", (Object)this.getName()));
        quietEditorPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneableEditor.class, (String)"ACSD_CloneableEditor_QuietEditorPane", (Object)this.getAccessibleContext().getAccessibleDescription()));
        this.pane = quietEditorPane;
        this.initialized = true;
        this.doInitialize = new DoInitialize(quietEditorPane);
    }

    final boolean newInitialize() {
        if (Boolean.getBoolean("org.openide.text.CloneableEditor.oldInitialize")) {
            return false;
        }
        return !Boolean.TRUE.equals(this.getClientProperty("oldInitialize"));
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    protected void componentOpened() {
        super.componentOpened();
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
        }
    }

    protected void componentClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CloneableEditor.this.pane != null) {
                    CloneableEditor.this.pane.setEditorKit(null);
                }
                CloneableEditor.this.removeAll();
                CloneableEditor.this.customComponent = null;
                CloneableEditor.this.customToolbar = null;
                CloneableEditor.this.pane = null;
                CloneableEditor.this.initialized = false;
            }
        });
        super.componentClosed();
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
        }
    }

    public void open(Workspace workspace) {
        if (this.discard()) {
            Logger.getAnonymousLogger().warning("Can not open " + this + " component," + " its support environment is not valid" + " [support=" + (Object)((Object)this.support) + ", env=" + (this.support == null ? null : this.support.cesEnv()) + "]");
        } else {
            this.dockIfNeeded();
            super.open(workspace);
        }
    }

    protected boolean closeLast() {
        if (!this.support.canClose()) {
            return false;
        }
        this.support.notifyClosed();
        if (this.support.getLastSelected() == this) {
            this.support.setLastSelected(null);
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public Action[] getActions() {
        Action[] actionArray = super.getActions();
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Class<SystemAction> clazz = Class.forName("org.openide.actions.FileSystemAction", true, classLoader).asSubclass(SystemAction.class);
            SystemAction systemAction = (SystemAction)SystemAction.findObject(clazz, (boolean)true);
            Class<SystemAction> clazz2 = Class.forName("org.netbeans.modules.diff.DiffAction", true, classLoader).asSubclass(SystemAction.class);
            SystemAction systemAction2 = (SystemAction)SystemAction.findObject(clazz2, (boolean)true);
            Action[] actionArray2 = new Action[actionArray.length + 2];
            System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
            actionArray2[actionArray.length] = systemAction;
            actionArray2[actionArray.length + 1] = systemAction2;
            return actionArray2;
        }
        catch (Exception exception) {
            return actionArray;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                this.customComponent.requestFocus();
            } else {
                this.pane.requestFocus();
            }
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                return this.customComponent.requestFocusInWindow();
            }
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public boolean requestDefaultFocus() {
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(rectangle.width / 2, rectangle.height / 2);
    }

    private Action getAction(String string) {
        if (string == null) {
            return null;
        }
        EditorKit editorKit = this.support.cesKit();
        if (editorKit == null) {
            return null;
        }
        Action[] actionArray = editorKit.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!string.equals(actionArray[i].getValue("Name"))) continue;
            return actionArray[i];
        }
        return null;
    }

    protected void componentActivated() {
        this.support.setLastSelected(this);
    }

    public void updateName() {
        final CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    String string = cloneableEditorSupport.messageHtmlName();
                    CloneableEditor.this.setHtmlDisplayName(string);
                    string = cloneableEditorSupport.messageName();
                    CloneableEditor.this.setDisplayName(string);
                    CloneableEditor.this.setName(string);
                    CloneableEditor.this.setToolTipText(cloneableEditorSupport.messageToolTip());
                }
            });
        }
    }

    protected String preferredID() {
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.documentID();
        }
        return "";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.support != null ? this.support.cesEnv() : null);
        int n = 0;
        JEditorPane jEditorPane = this.pane;
        if (jEditorPane != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret != null) {
                n = caret.getDot();
            } else if (jEditorPane instanceof QuietEditorPane) {
                int n2 = ((QuietEditorPane)jEditorPane).getLastPosition();
                if (n2 == -1) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Pane=" + jEditorPane + "was not initialized yet!"));
                } else {
                    n = n2;
                }
            } else {
                StyledDocument styledDocument;
                StyledDocument styledDocument2 = styledDocument = this.support != null ? this.support.getDocument() : null;
                if (styledDocument != null) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Caret is null in editor pane=" + jEditorPane + "\nsupport=" + (Object)((Object)this.support) + "\ndoc=" + styledDocument));
                }
            }
        }
        objectOutput.writeObject(new Integer(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof CloneableOpenSupport.Env) {
            CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)object;
            CloneableOpenSupport cloneableOpenSupport = env.findCloneableOpenSupport();
            this.support = (CloneableEditorSupport)cloneableOpenSupport;
        }
        int n = (Integer)objectInput.readObject();
        if (!this.discard()) {
            this.cursorPosition = n;
        }
        this.updateName();
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.support.initializeCloneableEditor(this);
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.cesEnv().isValid();
    }

    private void dockIfNeeded() {
        Mode mode = WindowManager.getDefault().findMode((TopComponent)this);
        if (null == mode) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (null != topComponent) {
                mode = WindowManager.getDefault().findMode(topComponent);
                if (!WindowManager.getDefault().isEditorMode(mode)) {
                    mode = null;
                }
            }
            if (null == mode) {
                mode = WindowManager.getDefault().findMode("editor");
            }
            if (null != mode) {
                mode.dockInto((TopComponent)this);
            } else {
                Logger.getAnonymousLogger().warning("The window system cannot find the default editor mode.");
            }
        }
    }

    public CloneableTopComponent getComponent() {
        return this;
    }

    public JEditorPane getEditorPane() {
        assert (SwingUtilities.isEventDispatchThread());
        this.initialize();
        DoInitialize doInitialize = this.doInitialize;
        if (doInitialize != null && !Thread.holdsLock(this.support.getLock())) {
            doInitialize.initVisual();
        }
        return this.pane;
    }

    public void ensureVisible() {
        this.open();
        this.requestVisible();
    }

    class DoInitialize
    implements Runnable,
    ActionListener {
        private final QuietEditorPane tmp;
        private Document doc;
        private RequestProcessor.Task task;
        private int phase;
        private EditorKit kit;
        private JComponent tmpComp;
        private boolean initialized = false;
        private boolean isInInitVisual = false;

        public DoInitialize(QuietEditorPane quietEditorPane) {
            this.tmp = quietEditorPane;
            this.tmpComp = this.initLoading();
            new Timer(1000, this).start();
            if (CloneableEditor.this.newInitialize()) {
                this.task = CloneableEditorSupport.RP.create((Runnable)this);
                this.task.setPriority(3);
                this.task.schedule(0);
            } else {
                this.run();
            }
        }

        private JComponent initLoading() {
            CloneableEditor.this.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel(NbBundle.getMessage(CloneableEditor.class, (String)"LBL_EditorLoading"));
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(new EmptyBorder(new Insets(11, 11, 11, 11)));
            jLabel.setVisible(false);
            CloneableEditor.this.add(jLabel, "Center");
            return jLabel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tmpComp.setVisible(true);
            Timer timer = (Timer)actionEvent.getSource();
            timer.stop();
        }

        public void run() {
            long l = System.currentTimeMillis();
            int n = this.phase;
            switch (this.phase++) {
                case 0: {
                    this.initNonVisual();
                    if (CloneableEditor.this.newInitialize()) {
                        WindowManager.getDefault().invokeWhenUIReady((Runnable)this);
                        break;
                    }
                }
                case 1: {
                    if (CloneableEditor.this.pane != this.tmp) {
                        this.phase = Integer.MAX_VALUE;
                        break;
                    }
                    this.initVisual();
                    if (CloneableEditor.this.newInitialize()) {
                        this.task.schedule(1000);
                        break;
                    }
                }
                case 2: {
                    this.initRest();
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong phase: " + this.phase + " for " + (Object)((Object)CloneableEditor.this.support));
                }
            }
            long l2 = System.currentTimeMillis() - l;
            if (TIMER.isLoggable(Level.FINE)) {
                Object object;
                String string = SwingUtilities.isEventDispatchThread() ? "AWT" : "RP";
                Document document = this.doc;
                Object object2 = object = document == null ? null : document.getProperty("stream");
                if (object == null) {
                    object = CloneableEditor.this.support.messageName();
                }
                TIMER.log(Level.FINE, "Open Editor, phase " + n + ", " + string + " [ms]", new Object[]{object, l2});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initNonVisual() {
            ActionMap actionMap;
            Serializable serializable;
            Task task;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "DoInitialize.initNonVisual Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName());
            }
            if ((task = CloneableEditor.this.support.prepareDocument()) == null && (serializable = CloneableEditor.this.support.getPrepareDocumentRuntimeException()) instanceof CloneableEditorSupport.DelegateIOExc && "org.openide.text.DataEditorSupport$Env$ME".equals(((Throwable)serializable).getCause().getClass().getName()) && ((Throwable)serializable).getCause() instanceof UserQuestionException) {
                actionMap = (UserQuestionException)((Throwable)serializable).getCause();
                try {
                    actionMap.confirmed();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                task = CloneableEditor.this.support.prepareDocument();
            }
            if (task == null) {
                LOG.log(Level.WARNING, "Failed to get prepareTask");
                return;
            }
            task.waitFinished();
            serializable = CloneableEditor.this.getActionMap();
            actionMap = this.tmp.getActionMap();
            ((ActionMap)serializable).setParent(actionMap);
            actionMap.put("cut-to-clipboard", CloneableEditor.this.getAction("cut-to-clipboard"));
            actionMap.put("copy-to-clipboard", CloneableEditor.this.getAction("copy-to-clipboard"));
            actionMap.put("delete", CloneableEditor.this.getAction("delete-next"));
            actionMap.put("paste-from-clipboard", CloneableEditor.this.getAction("paste-from-clipboard"));
            EditorKit editorKit = CloneableEditor.this.support.cesKit();
            if (CloneableEditor.this.newInitialize() && editorKit instanceof Callable) {
                try {
                    ((Callable)((Object)editorKit)).call();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
            DoInitialize doInitialize = this;
            synchronized (doInitialize) {
                try {
                    this.doc = CloneableEditor.this.support.openDocument();
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, "Failed to open document", iOException);
                }
                this.kit = editorKit;
                this.initialized = true;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "DoInitialize.initNonVisual doc and kit are set Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + this.doc + " kit:" + this.kit);
                    LOG.log(Level.FINE, "DoInitialize.initNonVisual Call notifyAll Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " [" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " Name:" + CloneableEditor.this.getName());
                }
                this.notifyAll();
            }
        }

        private void initCustomEditor() {
            if (this.doc instanceof NbDocument.CustomEditor) {
                NbDocument.CustomEditor customEditor = (NbDocument.CustomEditor)this.doc;
                CloneableEditor.this.customComponent = customEditor.createEditor(this.tmp);
                if (CloneableEditor.this.customComponent == null) {
                    throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomEditor may not" + " return null component");
                }
            }
        }

        private void initDecoration() {
            if (this.doc instanceof NbDocument.CustomToolbar) {
                NbDocument.CustomToolbar customToolbar = (NbDocument.CustomToolbar)this.doc;
                CloneableEditor.this.customToolbar = customToolbar.createToolbar(this.tmp);
                if (CloneableEditor.this.customToolbar == null) {
                    throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomToolbar may not" + " return null toolbar");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean initDocument() {
            DoInitialize doInitialize = this;
            synchronized (doInitialize) {
                while (true) {
                    Document document = this.doc;
                    EditorKit editorKit = this.kit;
                    if (this.initialized) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var3_1
                        if (this.tmp.getDocument() == this.doc) break;
                        this.tmp.setEditorKit(this.kit);
                        this.tmp.setWorking(1);
                        this.tmp.setDocument(this.doc);
                        return true;
                    }
                    try {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "DoInitialize.initDocument Starting wait Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + this.doc + " kit:" + this.kit);
                        }
                        this.wait();
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, "DoInitialize.initDocument Wait finished Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + this.doc + " kit:" + this.kit);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
            }
            return false;
        }

        final void initVisual() {
            Object object;
            if (this.isInInitVisual) {
                return;
            }
            this.isInInitVisual = true;
            if (!this.initDocument()) {
                this.isInInitVisual = false;
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "DoInitialize.initVisual Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName());
            }
            this.initCustomEditor();
            if (CloneableEditor.this.customComponent != null) {
                CloneableEditor.this.add(CloneableEditor.this.support.wrapEditorComponent(CloneableEditor.this.customComponent), "Center");
            } else {
                object = new JScrollPane(this.tmp);
                this.tmp.setBorder(null);
                CloneableEditor.this.add(CloneableEditor.this.support.wrapEditorComponent((Component)object), "Center");
            }
            this.initDecoration();
            if (CloneableEditor.this.customToolbar != null) {
                object = (Border)UIManager.get("Nb.Editor.Toolbar.border");
                CloneableEditor.this.customToolbar.setBorder((Border)object);
                CloneableEditor.this.add(CloneableEditor.this.customToolbar, "North");
            }
            CloneableEditor.this.remove(this.tmpComp);
            this.tmp.setWorking(3);
            if (CloneableEditor.this.cursorPosition != -1 && (object = this.tmp.getCaret()) != null) {
                object.setDot(CloneableEditor.this.cursorPosition);
            }
            object = CloneableEditor.this.getActionMap().getParent();
            CloneableEditor.this.getActionMap().setParent(null);
            CloneableEditor.this.getActionMap().setParent((ActionMap)object);
            if (CloneableEditor.this.equals(TopComponent.getRegistry().getActivated())) {
                CloneableEditor.this.requestFocusInWindow();
            }
            this.isInInitVisual = false;
        }

        private void initRest() {
            CloneableEditor.this.support;
            CloneableEditorSupport.RPPostprocessing.post(new Runnable(){

                public void run() {
                    CloneableEditor.this.support.ensureAnnotationsLoaded();
                }
            });
        }
    }
}

