/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public final class DirectionalAnchor
extends Anchor {
    private AnchorFactory.DirectionalAnchorKind kind;
    private int gap;

    public DirectionalAnchor(Widget widget, AnchorFactory.DirectionalAnchorKind directionalAnchorKind, int n) {
        super(widget);
        this.kind = directionalAnchorKind;
        this.gap = n;
    }

    public Anchor.Result compute(Anchor.Entry entry) {
        Point point = this.getRelatedSceneLocation();
        Point point2 = this.getOppositeSceneLocation(entry);
        Widget widget = this.getRelatedWidget();
        Rectangle rectangle = widget.convertLocalToScene(widget.getBounds());
        Point point3 = GeomUtil.center(rectangle);
        switch (this.kind) {
            case HORIZONTAL: {
                if (point.x >= point2.x) {
                    return (Anchor)this.new Anchor.Result(new Point(rectangle.x - this.gap, point3.y), Anchor.Direction.LEFT);
                }
                return (Anchor)this.new Anchor.Result(new Point(rectangle.x + rectangle.width + this.gap, point3.y), Anchor.Direction.RIGHT);
            }
            case VERTICAL: {
                if (point.y >= point2.y) {
                    return (Anchor)this.new Anchor.Result(new Point(point3.x, rectangle.y - this.gap), Anchor.Direction.TOP);
                }
                return (Anchor)this.new Anchor.Result(new Point(point3.x, rectangle.y + rectangle.height + this.gap), Anchor.Direction.BOTTOM);
            }
        }
        return null;
    }
}

