/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.DualGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTPlanarizer {
    private final int DEFAULT_ITERATIONS = 1;
    private int maxIterations = 1;
    private boolean isRandom = false;
    private Random random = new Random();

    public Collection<EmbeddedPlanarGraph> planarize(MGraph mGraph) {
        Collection<EmbeddedPlanarGraph> collection = this.createPlanarSubgraphs(mGraph);
        return collection;
    }

    private Collection<EmbeddedPlanarGraph> createPlanarSubgraphs(MGraph mGraph) {
        ArrayList<MGraph.Vertex<Object>> arrayList;
        Collection<Object> collection;
        LinkedHashSet<Face> linkedHashSet2;
        int n;
        LinkedHashSet<Face> linkedHashSet3 = null;
        ArrayList<MGraph.Edge> linkedHashSet4 = null;
        Collection<Object> collection2 = null;
        ArrayList<MGraph.Vertex<Object>> arrayList2 = null;
        for (n = 0; n < this.maxIterations; ++n) {
            linkedHashSet2 = new ArrayList();
            ArrayList<MGraph.Edge> linkedHashSet5 = new ArrayList<MGraph.Edge>();
            collection = new ArrayList<MGraph.Edge>();
            arrayList = this.computeOrdering(mGraph.getVertices());
            this.computeLRB((ArrayList<MGraph.Edge>)((Object)linkedHashSet2), linkedHashSet5, (ArrayList<MGraph.Edge>)collection, (ArrayList<MGraph.Vertex>)arrayList);
            if (linkedHashSet3 != null && ((ArrayList)((Object)linkedHashSet2)).size() + linkedHashSet5.size() <= linkedHashSet3.size() + linkedHashSet4.size()) continue;
            linkedHashSet3 = linkedHashSet2;
            linkedHashSet4 = linkedHashSet5;
            collection2 = collection;
            arrayList2 = arrayList;
        }
        n = 0;
        for (MGraph.Vertex vertex : arrayList2) {
            vertex.setNumber(n++);
        }
        linkedHashSet2 = new LinkedHashSet<Face>();
        LinkedHashSet<Face> linkedHashSet = new LinkedHashSet<Face>();
        collection = this.createAllFaces(linkedHashSet3, linkedHashSet4, (ArrayList<MGraph.Vertex>)arrayList2, linkedHashSet2, linkedHashSet);
        arrayList = new ArrayList();
        for (ArrayList arrayList3 : collection) {
            EmbeddedPlanarGraph embeddedPlanarGraph = EmbeddedPlanarGraph.createGraph(mGraph);
            arrayList.add((MGraph.Vertex)((Object)embeddedPlanarGraph));
            embeddedPlanarGraph.addFaces(arrayList3);
        }
        this.insertRemainingEdges(arrayList, collection2, linkedHashSet, false, linkedHashSet2, new HashSet<Face>(linkedHashSet3));
        return arrayList;
    }

    private ArrayList<MGraph.Vertex> computeOrdering(Collection<MGraph.Vertex> collection) {
        ArrayList<MGraph.Vertex> arrayList = new ArrayList<MGraph.Vertex>();
        ArrayList<MGraph.Vertex> arrayList2 = new ArrayList<MGraph.Vertex>(collection);
        int n = 0;
        MGraph.Vertex vertex = this.getMinimumDegreeVertex(arrayList2);
        this.assignOrdering(arrayList, vertex, n++);
        arrayList2.remove(vertex);
        ArrayList<MGraph.Vertex> arrayList3 = new ArrayList<MGraph.Vertex>();
        while (!arrayList2.isEmpty()) {
            Collection<MGraph.Vertex> collection2 = vertex.getNeighbors();
            for (MGraph.Vertex vertex2 : collection2) {
                if (!arrayList2.contains(vertex2)) continue;
                arrayList3.add(vertex2);
            }
            vertex = this.getMinimumDegreeVertex(arrayList3);
            if (vertex == null) {
                vertex = arrayList2.get(0);
            }
            this.assignOrdering(arrayList, vertex, n++);
            arrayList2.remove(vertex);
            arrayList3.clear();
        }
        return arrayList;
    }

    private MGraph.Vertex getMinimumDegreeVertex(Collection<MGraph.Vertex> collection) {
        if (collection.size() == 0) {
            return null;
        }
        ArrayList<MGraph.Vertex> arrayList = new ArrayList<MGraph.Vertex>();
        int n = this.getMinimumDegree(collection);
        for (MGraph.Vertex vertex : collection) {
            if (vertex.getDegree() != n) continue;
            arrayList.add(vertex);
        }
        return this.pickVertex(arrayList);
    }

    private int getMinimumDegree(Collection<MGraph.Vertex> collection) {
        int n = Integer.MAX_VALUE;
        for (MGraph.Vertex vertex : collection) {
            int n2 = vertex.getDegree();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private MGraph.Vertex pickVertex(ArrayList<MGraph.Vertex> arrayList) {
        int n = 0;
        if (this.isRandom()) {
            n = this.random.nextInt(arrayList.size());
        }
        return arrayList.get(n);
    }

    private void computeLRB(ArrayList<MGraph.Edge> arrayList, ArrayList<MGraph.Edge> arrayList2, ArrayList<MGraph.Edge> arrayList3, ArrayList<MGraph.Vertex> arrayList4) {
        int n;
        int n2;
        int n3;
        MGraph.Edge edge;
        int n4;
        int n5;
        int n6;
        MGraph.Edge edge2;
        int n7;
        ArrayList<MGraph.Edge> arrayList5 = this.assignEdgeWeights(arrayList4);
        int n8 = arrayList5.size();
        for (n7 = 0; n7 < n8; ++n7) {
            edge2 = arrayList5.get(n7);
            if (arrayList2.contains(edge2)) continue;
            n6 = edge2.getV().getNumber();
            if (n6 > (n5 = edge2.getW().getNumber())) {
                n4 = n6;
                n6 = n5;
                n5 = n4;
            }
            arrayList.add(edge2);
            for (n4 = n7 + 1; n4 < n8; ++n4) {
                edge = arrayList5.get(n4);
                if (arrayList2.contains(edge)) continue;
                n3 = edge.getV().getNumber();
                if (n3 > (n2 = edge.getW().getNumber())) {
                    n = n3;
                    n3 = n2;
                    n2 = n;
                }
                if ((n6 >= n3 || n3 >= n5 || n5 >= n2) && (n3 >= n6 || n6 >= n2 || n2 >= n5)) continue;
                arrayList2.add(edge);
            }
        }
        n8 = arrayList2.size();
        for (n7 = 0; n7 < n8; ++n7) {
            edge2 = arrayList2.get(n7);
            if (arrayList3.contains(edge2)) continue;
            n6 = edge2.getV().getNumber();
            if (n6 > (n5 = edge2.getW().getNumber())) {
                n4 = n6;
                n6 = n5;
                n5 = n4;
            }
            for (n4 = n7 + 1; n4 < n8; ++n4) {
                edge = arrayList2.get(n4);
                if (arrayList3.contains(edge)) continue;
                n3 = edge.getV().getNumber();
                if (n3 > (n2 = edge.getW().getNumber())) {
                    n = n3;
                    n3 = n2;
                    n2 = n;
                }
                if ((n6 >= n3 || n3 >= n5 || n5 >= n2) && (n3 >= n6 || n6 >= n2 || n2 >= n5)) continue;
                arrayList3.add(edge);
            }
        }
        arrayList2.removeAll(arrayList3);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<MGraph.Edge> assignEdgeWeights(Collection<MGraph.Vertex> collection) {
        void var5_12;
        LinkedHashSet<MGraph.Edge> linkedHashSet = new LinkedHashSet<MGraph.Edge>();
        for (MGraph.Vertex arrayList2 : collection) {
            Collection<MGraph.Edge> collection2 = arrayList2.getEdges();
            for (MGraph.Edge edge : collection2) {
                linkedHashSet.add(edge);
            }
        }
        if (!this.isRandom) {
            return new ArrayList<MGraph.Edge>(linkedHashSet);
        }
        int n = linkedHashSet.size();
        for (MGraph.Edge edge : linkedHashSet) {
            edge.setWeight(0);
        }
        ArrayList<MGraph.Edge> arrayList = new ArrayList<MGraph.Edge>(linkedHashSet);
        boolean bl = false;
        while (var5_12 < n - 2) {
            Object object = arrayList.get((int)var5_12);
            for (void var7_15 = var5_12 + true; var7_15 < n - 1; ++var7_15) {
                MGraph.Edge edge = arrayList.get((int)var7_15);
                if (edge.getWeight() >= ((MGraph.Edge)object).getWeight()) continue;
                arrayList.set((int)var5_12, edge);
                arrayList.set((int)var7_15, (MGraph.Edge)object);
                object = edge;
            }
            ++var5_12;
        }
        return arrayList;
    }

    private void assignOrdering(ArrayList<MGraph.Vertex> arrayList, MGraph.Vertex vertex, int n) {
        arrayList.add(vertex);
        vertex.setNumber(n);
    }

    private Collection<ArrayList<Face>> createAllFaces(Collection<MGraph.Edge> collection, Collection<MGraph.Edge> collection2, ArrayList<MGraph.Vertex> arrayList, Collection<Face> collection3, Collection<Face> collection4) {
        ArrayList<Face> arrayList2 = new ArrayList<Face>();
        collection3.addAll(this.createFaces(collection, null, arrayList, false));
        collection4.addAll(this.createFaces(collection2, collection, arrayList, true));
        arrayList2.addAll(collection3);
        arrayList2.addAll(collection4);
        this.removeFaces(arrayList2);
        Collection<ArrayList<Face>> collection5 = this.computeFaceLists(arrayList2);
        for (ArrayList<Face> arrayList3 : collection5) {
            Face face = this.createOuterFace(arrayList3, collection, collection2);
            arrayList3.add(0, face);
            collection4.add(face);
            collection3.add(face);
        }
        return collection5;
    }

    private Collection<ArrayList<Face>> computeFaceLists(ArrayList<Face> arrayList) {
        ArrayList<ArrayList<Face>> arrayList2 = new ArrayList<ArrayList<Face>>();
        arrayList = new ArrayList<Face>(arrayList);
        while (!arrayList.isEmpty()) {
            ArrayList<Face> arrayList3 = new ArrayList<Face>();
            arrayList2.add(arrayList3);
            Face face = arrayList.remove(0);
            arrayList3.add(face);
            for (int i = 0; i < arrayList3.size(); ++i) {
                ArrayList<Face> arrayList4 = new ArrayList<Face>();
                Face face2 = (Face)arrayList3.get(i);
                for (int j = 0; j < arrayList.size(); ++j) {
                    Face face3 = arrayList.get(j);
                    if (!face2.connects(face3)) continue;
                    arrayList4.add(face3);
                }
                arrayList.removeAll(arrayList4);
                arrayList3.addAll(arrayList4);
            }
        }
        return arrayList2;
    }

    private Face createOuterFace(ArrayList<Face> arrayList, Collection<MGraph.Edge> collection, Collection<MGraph.Edge> collection2) {
        Object object;
        Object object2;
        Object object3;
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedHashSet<Face.Dart> linkedHashSet = new LinkedHashSet<Face.Dart>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        ArrayList<Face.Dart> arrayList2 = new ArrayList<Face.Dart>();
        HashSet<MGraph.Edge> hashSet3 = new HashSet<MGraph.Edge>();
        HashSet<MGraph.Edge> hashSet4 = new HashSet<MGraph.Edge>(collection);
        int n = arrayList.size();
        MGraph.Edge edge = null;
        for (int i = 0; i < n; ++i) {
            object3 = arrayList.get(i);
            for (Face.Dart dart : ((Face)object3).getDarts()) {
                object2 = dart.getEdge();
                boolean bl = false;
                if (hashSet.contains(object2)) continue;
                for (int j = i + 1; j < n; ++j) {
                    object = arrayList.get(j);
                    if (!((Face)object).containsEdge((MGraph.Edge)object2)) continue;
                    hashSet.add(object2);
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (edge == null) {
                    edge = dart;
                    hashSet2.add(object2);
                    continue;
                }
                if (!hashSet2.contains(object2)) {
                    linkedHashSet.add(dart);
                    hashSet2.add(object2);
                    continue;
                }
                arrayList2.add(dart);
                hashSet3.add(dart.getEdge());
            }
        }
        linkedHashSet.addAll(arrayList2);
        Face face = new Face();
        face.setOuterFace(true);
        object3 = edge.getV();
        linkedHashSet.remove(edge);
        face.addEdge(((Face.Dart)edge).getEdge());
        ArrayList arrayList3 = new ArrayList();
        while (!linkedHashSet.isEmpty()) {
            arrayList3.clear();
            int n2 = ((MGraph.Vertex)object3).getNumber();
            for (Face.Dart object4 : linkedHashSet) {
                if (!object4.contains((MGraph.Vertex)object3)) continue;
                arrayList3.add(object4);
            }
            object2 = null;
            if (arrayList3.size() > 1) {
                Face.Dart dart;
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    dart = (Face.Dart)iterator.next();
                    if (!hashSet3.contains(dart.getEdge())) continue;
                    hashSet3.remove(dart.getEdge());
                    object2 = dart;
                    break;
                }
                if (object2 == null) {
                    Iterator iterator2 = arrayList3.iterator();
                    while (iterator2.hasNext()) {
                        dart = (Face.Dart)iterator2.next();
                        if (!collection2.contains(dart.getEdge())) continue;
                        object2 = dart;
                        break;
                    }
                }
                if (object2 == null) {
                    Iterator iterator3 = arrayList3.iterator();
                    while (iterator3.hasNext()) {
                        dart = (Face.Dart)iterator3.next();
                        if (object2 == null) {
                            object2 = dart;
                            continue;
                        }
                        object = null;
                        object = dart.getW().getNumber() > dart.getV().getNumber() ? dart.getW() : dart.getV();
                        MGraph.Vertex vertex = null;
                        vertex = ((MGraph.Edge)object2).getW().getNumber() > ((MGraph.Edge)object2).getV().getNumber() ? ((MGraph.Edge)object2).getW() : ((MGraph.Edge)object2).getV();
                        int n3 = ((MGraph.Vertex)object).getNumber();
                        int n4 = vertex.getNumber();
                        if (n3 <= n2 || n3 >= n4) continue;
                        object2 = dart;
                    }
                }
            } else {
                object2 = arrayList3.size() > 0 ? (Face.Dart)arrayList3.get(0) : null;
            }
            if (object2 == null) continue;
            linkedHashSet.remove(object2);
            face.addEdge(((Face.Dart)object2).getEdge());
            object3 = ((MGraph.Edge)object2).getOppositeVertex((MGraph.Vertex)object3);
        }
        face.setOuterFace(true);
        face.createDarts();
        return face;
    }

    private Collection<Face> createFaces(Collection<MGraph.Edge> collection, Collection<MGraph.Edge> collection2, ArrayList<MGraph.Vertex> arrayList, boolean bl) {
        ArrayList<Face> arrayList2 = new ArrayList<Face>();
        block0: for (MGraph.Vertex vertex : arrayList) {
            Collection<MGraph.Edge> collection3 = this.getIncidentEdges(vertex, collection);
            while (!collection3.isEmpty()) {
                int n = vertex.getNumber();
                MGraph.Edge edge = null;
                for (MGraph.Edge edge2 : collection3) {
                    MGraph.Vertex vertex2 = edge2.getOppositeVertex(vertex);
                    int n2 = vertex2.getNumber();
                    if (n2 <= n) continue;
                    n = n2;
                    edge = edge2;
                }
                if (edge == null) continue block0;
                collection3.remove(edge);
                Collection<MGraph.Edge> collection4 = this.computeShortedReturnPath(vertex, edge.getOppositeVertex(vertex), edge, collection, collection2);
                if (collection4.isEmpty()) continue;
                Face face = new Face();
                face.addEdge(edge);
                face.addEdges(collection4);
                boolean bl2 = false;
                if (face.getDegree() == 2) {
                    for (Face face2 : arrayList2) {
                        if (!face.borders(face2)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue;
                if (bl) {
                    face.reverseDirection();
                }
                face.createDarts();
                arrayList2.add(face);
            }
        }
        return arrayList2;
    }

    private Collection<MGraph.Edge> computeShortedReturnPath(MGraph.Vertex vertex, MGraph.Vertex vertex2, MGraph.Edge edge, Collection<MGraph.Edge> collection, Collection<MGraph.Edge> collection2) {
        ArrayList<MGraph.Edge> arrayList = new ArrayList<MGraph.Edge>();
        Collection<MGraph.Edge> collection3 = this.getIncidentEdges(vertex2, collection);
        collection3.remove(edge);
        int n = vertex.getNumber();
        int n2 = vertex2.getNumber();
        MGraph.Edge object = null;
        int n3 = n2;
        boolean bl = false;
        for (MGraph.Edge object2 : collection3) {
            MGraph.Vertex vertex3 = object2.getOppositeVertex(vertex2);
            int n4 = vertex3.getNumber();
            if (n4 < n3 && n4 >= n) {
                n3 = n4;
                object = object2;
            }
            if (n4 >= n2) continue;
            bl = true;
        }
        if (object == null && collection2 != null) {
            collection3 = this.getIncidentEdges(vertex2, collection2);
            int n5 = n;
            for (MGraph.Edge edge2 : collection3) {
                MGraph.Vertex vertex4 = edge2.getOppositeVertex(vertex2);
                int n6 = vertex4.getNumber();
                if (n6 >= n5 && n6 < n2) {
                    n5 = n6;
                    object = edge2;
                }
                if (n6 >= n2) continue;
                bl = true;
            }
        }
        if (object == null && !bl) {
            object = edge;
        }
        if (object != null) {
            if (object.contains(vertex)) {
                arrayList.add(object);
            } else {
                Object object4 = null;
                MGraph.Vertex vertex5 = object.getOppositeVertex(vertex2);
                if (!vertex5.equals(vertex2) || !object.equals(edge)) {
                    object4 = this.computeShortedReturnPath(vertex, vertex5, object, collection, collection2);
                }
                if (!object4.isEmpty()) {
                    arrayList.add(object);
                    arrayList.addAll((Collection<MGraph.Edge>)object4);
                }
            }
        }
        return arrayList;
    }

    private void removeFaces(Collection<Face> collection) {
        ArrayList<Face> arrayList = new ArrayList<Face>();
        for (Face face : collection) {
            if (face.isOuterFace() || face.getDegree() != 2) continue;
            for (Face face2 : collection) {
                if (face2.isOuterFace() || face == face2 || !face.borders(face2)) continue;
                arrayList.add(face);
            }
        }
        collection.removeAll(arrayList);
    }

    private Collection<MGraph.Edge> getIncidentEdges(MGraph.Vertex vertex, Collection<MGraph.Edge> collection) {
        ArrayList<MGraph.Edge> arrayList = new ArrayList<MGraph.Edge>(vertex.getEdges());
        arrayList.retainAll(collection);
        return arrayList;
    }

    private void insertRemainingEdges(Collection<EmbeddedPlanarGraph> collection, Collection<MGraph.Edge> collection2, Collection<Face> collection3, boolean bl, Collection<Face> collection4, Collection<MGraph.Edge> collection5) {
        if (collection2.isEmpty()) {
            return;
        }
        for (EmbeddedPlanarGraph embeddedPlanarGraph : collection) {
            DualGraph dualGraph = DualGraph.createGraph(embeddedPlanarGraph, collection4, collection5);
            for (MGraph.Edge edge : collection2) {
                this.insertEdge(dualGraph, edge, collection3, bl);
            }
        }
    }

    private void insertEdge(DualGraph dualGraph, MGraph.Edge edge, Collection<Face> collection, boolean bl) {
        EmbeddedPlanarGraph embeddedPlanarGraph = dualGraph.getOriginalGraph();
        MGraph mGraph = embeddedPlanarGraph.getOriginalGraph();
        MGraph.Vertex vertex = edge.getV();
        MGraph.Vertex vertex2 = edge.getW();
        boolean bl2 = false;
        if (vertex.getNumber() < vertex2.getNumber()) {
            bl2 = true;
        }
        ArrayList<DualGraph.FaceEdge> arrayList = this.computeShortestPathInDualGraph(dualGraph, vertex, vertex2, collection);
        DualGraph.FaceEdge faceEdge = null;
        DualGraph.FaceVertex faceVertex = null;
        MGraph.Vertex vertex3 = null;
        MGraph.Vertex vertex4 = vertex;
        MGraph.DummyEdge dummyEdge = null;
        MGraph.Edge edge2 = null;
        ArrayList<MGraph.Edge> arrayList2 = null;
        int n = arrayList.size();
        for (int i = 0; i <= n; ++i) {
            if (i == n) {
                vertex3 = vertex2;
            } else {
                faceEdge = arrayList.get(i);
                if (i == 0) {
                    faceVertex = faceEdge.getVertex(vertex);
                }
                if (arrayList2 != null) {
                    faceVertex.getFace().replaceEdge(edge2, arrayList2);
                }
                vertex3 = mGraph.insertDummyVertex(faceEdge.getEdge(), MGraph.DummyVertex.Type.CROSSING);
                ((MGraph.DummyVertex)vertex3).setNumber(Integer.MAX_VALUE);
                arrayList2 = new ArrayList<MGraph.Edge>(vertex3.getEdges());
            }
            dummyEdge = mGraph.addDummyEdge(vertex4, vertex3);
            dummyEdge.setOriginalEdge(edge);
            MGraph.Vertex vertex5 = null;
            vertex5 = bl ? (bl2 ? vertex3 : vertex4) : (bl2 ? vertex4 : vertex3);
            this.subdivide(dualGraph, faceVertex, faceEdge, arrayList2, dummyEdge, vertex5, collection);
            vertex4 = vertex3;
            edge2 = faceEdge.getEdge();
            if (i >= n) continue;
            faceVertex = faceEdge.getOppositeVertex(faceVertex);
        }
        this.removeFaces(embeddedPlanarGraph.getFaces());
        dualGraph.updateFaces();
        dualGraph.updateEdges();
    }

    private Collection<DualGraph.FaceVertex> getIncidentFaceVertices(MGraph.Vertex vertex, DualGraph dualGraph, Collection<Face> collection) {
        LinkedHashSet<DualGraph.FaceVertex> linkedHashSet = new LinkedHashSet<DualGraph.FaceVertex>();
        DualGraph.FaceVertex faceVertex = null;
        Collection<MGraph.Edge> collection2 = vertex.getEdges();
        for (MGraph.Edge edge : collection2) {
            Collection<DualGraph.FaceVertex> collection3 = dualGraph.getVerticesBorderingEdge(edge);
            for (DualGraph.FaceVertex faceVertex2 : collection3) {
                Face face = faceVertex2.getFace();
                if (!collection.contains(face)) continue;
                if (face.isOuterFace()) {
                    faceVertex = faceVertex2;
                    continue;
                }
                linkedHashSet.add(faceVertex2);
            }
        }
        if (linkedHashSet.isEmpty()) {
            linkedHashSet.add(faceVertex);
        }
        return linkedHashSet;
    }

    private ArrayList<DualGraph.FaceEdge> computeShortestPathInDualGraph(DualGraph dualGraph, MGraph.Vertex vertex, MGraph.Vertex vertex2, Collection<Face> collection) {
        EmbeddedPlanarGraph embeddedPlanarGraph = dualGraph.getOriginalGraph();
        Collection<DualGraph.FaceVertex> collection2 = this.getIncidentFaceVertices(vertex, dualGraph, collection);
        Collection<DualGraph.FaceVertex> collection3 = this.getIncidentFaceVertices(vertex2, dualGraph, collection);
        ArrayList<DualGraph.FaceEdge> arrayList = null;
        int n = Integer.MAX_VALUE;
        for (DualGraph.FaceVertex faceVertex : collection2) {
            for (DualGraph.FaceVertex faceVertex2 : collection3) {
                ArrayList<DualGraph.FaceEdge> arrayList2;
                if (faceVertex == faceVertex2 || (arrayList2 = this.computeShortestPathInDualGraph(faceVertex, faceVertex2, new HashSet<DualGraph.FaceVertex>(), n, collection)) == null || arrayList != null && arrayList2.size() >= arrayList.size()) continue;
                arrayList = arrayList2;
                n = arrayList.size();
                if (arrayList.size() != 1) continue;
                return arrayList;
            }
        }
        return arrayList;
    }

    private ArrayList<DualGraph.FaceEdge> computeShortestPathInDualGraph(DualGraph.FaceVertex faceVertex, DualGraph.FaceVertex faceVertex2, Collection<DualGraph.FaceVertex> collection, int n, Collection<Face> collection2) {
        ArrayList<DualGraph.FaceEdge> arrayList = null;
        collection.add(faceVertex);
        for (DualGraph.FaceEdge faceEdge : faceVertex.getEdges()) {
            ArrayList<DualGraph.FaceEdge> arrayList2;
            if (faceEdge.contains(faceVertex2)) {
                arrayList = new ArrayList<DualGraph.FaceEdge>();
                arrayList.add(faceEdge);
                break;
            }
            DualGraph.FaceVertex faceVertex3 = faceEdge.getOppositeVertex(faceVertex);
            if (!collection2.contains(faceVertex3.getFace()) || collection.contains(faceVertex3) || collection.size() - 1 > n || (arrayList2 = this.computeShortestPathInDualGraph(faceVertex3, faceVertex2, collection, n, collection2)) == null || arrayList != null && arrayList2.size() >= arrayList.size() - 1) continue;
            arrayList = new ArrayList();
            arrayList.add(faceEdge);
            arrayList.addAll(arrayList2);
            n = arrayList.size();
        }
        collection.remove(faceVertex);
        return arrayList;
    }

    public void subdivide(DualGraph dualGraph, DualGraph.FaceVertex faceVertex, DualGraph.FaceEdge faceEdge, Collection<MGraph.Edge> collection, MGraph.Edge edge, MGraph.Vertex vertex, Collection<Face> collection2) {
        Face face = faceVertex.getFace();
        face.replaceEdge(faceEdge.getEdge(), collection);
        List<Face.Dart> list = face.replaceDarts(edge, vertex);
        Face face2 = new Face();
        MGraph.Edge edge2 = null;
        for (Face.Dart dart : list) {
            if (edge2 == null) {
                edge2 = dart;
            }
            face2.addEdge(dart.getEdge());
        }
        face2.addEdge(edge);
        face2.createDarts(edge2.getV());
        EmbeddedPlanarGraph embeddedPlanarGraph = dualGraph.getOriginalGraph();
        embeddedPlanarGraph.addFace(face2);
        collection2.add(face2);
        dualGraph.updateFaces();
    }

    public void setRandom(boolean bl) {
        this.isRandom = bl;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    private int getMaxIterations() {
        return this.maxIterations;
    }
}

