/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.visual.router.OrthogonalSearchRouter;
import org.netbeans.modules.visual.router.OrthogonalSearchRouterRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OrthogonalSearchRouterCore {
    private static final int MAXIMAL_DEPTH = 5;
    private static final int CORNER_LENGTH = 200;
    private static final boolean UPDATE_COLLISION_LISTS = true;
    private static final boolean UPDATE_COLLISION_LISTS_REMOVE = true;
    static final boolean IGNORE_LINKS_WITH_ACTUAL_PORTS = false;
    private static final boolean OPTIMALIZE_REGIONS = false;
    private Scene scene;
    private ArrayList<Rectangle> verticalCollisions;
    private ArrayList<Rectangle> horizontalCollisions;
    private Point sourcePoint;
    private Anchor.Direction sourceDirection;
    private Point targetPoint;
    private Anchor.Direction targetDirection;
    private Point sourceBoundaryPoint;
    private Point targetBoundaryPoint;
    private final OrthogonalSearchRouterRegion[] regions = new OrthogonalSearchRouterRegion[6];
    private Point[] bestControlPoints;
    private int bestControlPointsPrice;

    public OrthogonalSearchRouterCore(Scene scene, ArrayList<Rectangle> arrayList, ArrayList<Rectangle> arrayList2, Point point, Anchor.Direction direction, Point point2, Anchor.Direction direction2) {
        this.scene = scene;
        this.verticalCollisions = arrayList;
        this.horizontalCollisions = arrayList2;
        this.sourcePoint = point;
        this.sourceDirection = direction;
        this.targetPoint = point2;
        this.targetDirection = direction2;
    }

    public OrthogonalSearchRouter.Solution route() {
        this.sourceBoundaryPoint = this.findBoundaryPoint(this.sourcePoint, this.sourceDirection);
        this.targetBoundaryPoint = this.findBoundaryPoint(this.targetPoint, this.targetDirection);
        if (this.sourceBoundaryPoint.x == this.targetBoundaryPoint.x) {
            ++this.targetBoundaryPoint.x;
        }
        if (this.sourceBoundaryPoint.y == this.targetBoundaryPoint.y) {
            ++this.targetBoundaryPoint.y;
        }
        OrthogonalSearchRouterRegion orthogonalSearchRouterRegion = new OrthogonalSearchRouterRegion(this.sourceBoundaryPoint.x, this.sourceBoundaryPoint.y, 0, 0, this.sourceDirection, 0);
        this.search(orthogonalSearchRouterRegion);
        if (this.bestControlPoints == null) {
            return null;
        }
        OrthogonalSearchRouter.Solution solution = new OrthogonalSearchRouter.Solution(this.bestControlPointsPrice, Arrays.asList(this.bestControlPoints));
        return solution;
    }

    private Point findBoundaryPoint(Point point, Anchor.Direction direction) {
        ArrayList<Rectangle> arrayList;
        point = new Point(point);
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                arrayList = this.horizontalCollisions;
                break;
            }
            case BOTTOM: 
            case TOP: {
                arrayList = this.verticalCollisions;
                break;
            }
            default: {
                return point;
            }
        }
        boolean bl = true;
        block10: while (bl) {
            bl = false;
            switch (direction) {
                case LEFT: {
                    for (Rectangle rectangle : arrayList) {
                        if (!rectangle.contains(point)) continue;
                        point.x = rectangle.x - 1;
                        bl = true;
                    }
                    continue block10;
                }
                case RIGHT: {
                    for (Rectangle rectangle : arrayList) {
                        if (!rectangle.contains(point)) continue;
                        point.x = rectangle.x + rectangle.width;
                        bl = true;
                    }
                    continue block10;
                }
                case BOTTOM: {
                    for (Rectangle rectangle : arrayList) {
                        if (!rectangle.contains(point)) continue;
                        point.y = rectangle.y + rectangle.height;
                        bl = true;
                    }
                    continue block10;
                }
                case TOP: {
                    for (Rectangle rectangle : arrayList) {
                        if (!rectangle.contains(point)) continue;
                        point.y = rectangle.y - 1;
                        bl = true;
                    }
                    break;
                }
            }
        }
        return point;
    }

    private void search(OrthogonalSearchRouterRegion orthogonalSearchRouterRegion) {
        Rectangle rectangle = orthogonalSearchRouterRegion.intersection(this.scene.getMaximumBounds());
        orthogonalSearchRouterRegion = new OrthogonalSearchRouterRegion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, orthogonalSearchRouterRegion.getDirection(), orthogonalSearchRouterRegion.getDepth());
        if (orthogonalSearchRouterRegion.width < 0 || orthogonalSearchRouterRegion.height < 0) {
            return;
        }
        assert (orthogonalSearchRouterRegion.x >= -20000);
        assert (orthogonalSearchRouterRegion.y >= -20000);
        assert (orthogonalSearchRouterRegion.x + orthogonalSearchRouterRegion.width <= 20000);
        assert (orthogonalSearchRouterRegion.y + orthogonalSearchRouterRegion.height <= 20000);
        int n = orthogonalSearchRouterRegion.getDepth();
        if (n >= 5) {
            return;
        }
        orthogonalSearchRouterRegion.extendToInfinity();
        this.regions[n] = orthogonalSearchRouterRegion;
        ArrayList<Rectangle> arrayList = orthogonalSearchRouterRegion.isHorizontal() ? this.horizontalCollisions : this.verticalCollisions;
        ArrayList<OrthogonalSearchRouterRegion> arrayList2 = orthogonalSearchRouterRegion.parseSubRegions(arrayList);
        boolean bl = false;
        if (!orthogonalSearchRouterRegion.isEmpty()) {
            Rectangle rectangle2 = new Rectangle(orthogonalSearchRouterRegion);
            this.horizontalCollisions.add(rectangle2);
            this.verticalCollisions.add(rectangle2);
            bl = true;
        }
        if (orthogonalSearchRouterRegion.containsInsideEdges(this.targetBoundaryPoint)) {
            this.constructControlPoints(n);
        } else {
            if (orthogonalSearchRouterRegion.getLength() > 0) {
                this.search(orthogonalSearchRouterRegion.cloneWithCounterClockwiseEdge());
                this.search(orthogonalSearchRouterRegion.cloneWithClockwiseEdge());
            }
            if (!arrayList2.isEmpty()) {
                for (OrthogonalSearchRouterRegion orthogonalSearchRouterRegion2 : arrayList2) {
                    this.search(orthogonalSearchRouterRegion2);
                }
            }
        }
        if (bl) {
            this.horizontalCollisions.remove(this.horizontalCollisions.size() - 1);
            this.verticalCollisions.remove(this.verticalCollisions.size() - 1);
        }
    }

    private void constructControlPoints(int n) {
        int n2;
        Point[] pointArray;
        Anchor.Direction direction;
        switch (this.targetDirection) {
            case LEFT: {
                direction = Anchor.Direction.RIGHT;
                break;
            }
            case RIGHT: {
                direction = Anchor.Direction.LEFT;
                break;
            }
            case TOP: {
                direction = Anchor.Direction.BOTTOM;
                break;
            }
            case BOTTOM: {
                direction = Anchor.Direction.TOP;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (direction != this.regions[n].getDirection()) {
            pointArray = this.regions[n];
            this.regions[++n] = new OrthogonalSearchRouterRegion(pointArray.x, pointArray.y, pointArray.width, pointArray.height, direction, n);
        }
        pointArray = new Point[n + 4];
        pointArray[0] = new Point(this.sourcePoint);
        pointArray[1] = new Point(this.sourceBoundaryPoint);
        for (n2 = 2; n2 < n + 2; ++n2) {
            pointArray[n2] = new Point();
        }
        pointArray[n + 2] = new Point(this.targetBoundaryPoint);
        pointArray[n + 3] = new Point(this.targetPoint);
        for (n2 = 0; n2 < n; ++n2) {
            int n3;
            int n4;
            int n5;
            OrthogonalSearchRouterRegion orthogonalSearchRouterRegion = this.regions[n2];
            Point point = pointArray[n2 + 1];
            Point point2 = pointArray[n2 + 2];
            if (orthogonalSearchRouterRegion.isHorizontal()) {
                if (n2 > 0) {
                    n5 = orthogonalSearchRouterRegion.y;
                    n4 = orthogonalSearchRouterRegion.y + orthogonalSearchRouterRegion.height;
                    n3 = n5 <= -20000 && n4 < 20000 ? n4 - 8 : (n5 > -20000 && n4 >= 20000 ? n5 + 8 : orthogonalSearchRouterRegion.y + orthogonalSearchRouterRegion.height / 2);
                } else {
                    n3 = point.y;
                }
                point.y = point2.y = n3;
                continue;
            }
            if (n2 > 0) {
                n5 = orthogonalSearchRouterRegion.x;
                n4 = orthogonalSearchRouterRegion.x + orthogonalSearchRouterRegion.width;
                n3 = n5 <= -20000 && n4 < 20000 ? n4 - 8 : (n5 > -20000 && n4 >= 20000 ? n5 + 8 : orthogonalSearchRouterRegion.x + orthogonalSearchRouterRegion.width / 2);
            } else {
                n3 = point.x;
            }
            point.x = point2.x = n3;
        }
        if (this.regions[n].isHorizontal()) {
            pointArray[n + 1].y = pointArray[n + 2].y;
        } else {
            pointArray[n + 1].x = pointArray[n + 2].x;
        }
        n2 = this.removeDuplicateControlPoints(pointArray);
        int n6 = this.calculatePrice(n2, pointArray);
        if (this.bestControlPoints == null || this.bestControlPointsPrice > n6) {
            if (n2 < pointArray.length) {
                this.bestControlPoints = new Point[n2];
                System.arraycopy(pointArray, 0, this.bestControlPoints, 0, n2);
            } else {
                this.bestControlPoints = pointArray;
            }
            this.bestControlPointsPrice = n6;
        }
    }

    private int removeDuplicateControlPoints(Point[] pointArray) {
        int n = 0;
        for (int i = 1; i < pointArray.length - 1; ++i) {
            Point point = pointArray[n];
            Point point2 = pointArray[i];
            Point point3 = pointArray[i + 1];
            int n2 = 2;
            if (Math.abs(point.x - point2.x) < n2 && Math.abs(point2.x - point3.x) < n2 || Math.abs(point.y - point2.y) < n2 && Math.abs(point2.y - point3.y) < n2 || ++n == i) continue;
            pointArray[n] = point2;
        }
        if (++n < pointArray.length - 1) {
            pointArray[n++] = pointArray[pointArray.length - 1];
        }
        return n;
    }

    private int calculatePrice(int n, Point[] pointArray) {
        int n2;
        int n3 = 0;
        int n4 = n - 1;
        for (n2 = 1; n2 < n; ++n2) {
            Point point = pointArray[n2 - 1];
            Point point2 = pointArray[n2];
            n3 += Math.abs(point2.y - point.y) + Math.abs(point2.x - point.x) + 200;
        }
        if (n > 0) {
            n2 = n3 / n4;
            int n5 = 0;
            for (int i = 1; i < n; ++i) {
                Point point = pointArray[i - 1];
                Point point3 = pointArray[i];
                n5 += Math.abs(Math.abs(point3.y - point.y) + Math.abs(point3.x - point.x) - n2);
            }
            n3 += (n5 /= n4);
        }
        return n3;
    }
}

