/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.openide.util.NbBundle;
import tr.model.action.Interval;
import tr.model.action.Period;
import tr.model.action.PeriodType;
import tr.prefs.recurrence.RecurrencePrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodMonth
extends Period {
    public static final byte ID = 4;
    public static final String BUNDLE_KEY = "period.month";
    private Option option;
    private List<Integer> selectedDays;
    private OnTheNth onTheNth;
    private OnTheDay onTheDay;

    public PeriodMonth() {
        this.setOption(Option.Each);
        this.selectedDays = new Vector<Integer>();
    }

    public PeriodMonth(List<Integer> daysOfMonth) {
        this.setOption(Option.Each);
        this.selectedDays = daysOfMonth;
    }

    public PeriodMonth(OnTheNth nth, OnTheDay day) {
        this();
        this.setOption(Option.OnThe);
        this.setOnTheNth(nth);
        this.setOnTheDay(day);
    }

    @Override
    public Period clone() {
        PeriodMonth clone = new PeriodMonth();
        clone.option = this.option;
        clone.selectedDays = new Vector<Integer>(this.selectedDays);
        clone.onTheDay = this.onTheDay;
        clone.onTheNth = this.onTheNth;
        return clone;
    }

    @Override
    public final byte getID() {
        return 4;
    }

    @Override
    public final String getBundleKey() {
        return BUNDLE_KEY;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PeriodMonth) {
            PeriodMonth other = (PeriodMonth)object;
            if (this.option != other.option) {
                return false;
            }
            if (this.option == Option.Each) {
                return ((Object)this.selectedDays).equals(other.selectedDays);
            }
            if (this.option == Option.OnThe) {
                return this.onTheNth == other.onTheNth && this.onTheDay == other.onTheDay;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.option != null ? this.option.hashCode() : 0);
        hash = 23 * hash + (this.selectedDays != null ? ((Object)this.selectedDays).hashCode() : 0);
        hash = 23 * hash + (this.onTheNth != null ? this.onTheNth.hashCode() : 0);
        hash = 23 * hash + (this.onTheDay != null ? this.onTheDay.hashCode() : 0);
        return hash;
    }

    public List<Integer> getSelectedDays() {
        Collections.sort(this.selectedDays);
        return new Vector<Integer>(this.selectedDays);
    }

    public String getSelectedDaysText() {
        if (this.selectedDays.size() == 0) {
            return this.getMsg("period.day") + " ...";
        }
        Collections.sort(this.selectedDays);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.selectedDays.size(); ++i) {
            sb.append((i > 0 ? "," : "") + this.selectedDays.get(i));
        }
        return sb.toString();
    }

    public void setSelectedDays(List<Integer> days) {
        this.selectedDays.clear();
        if (days != null) {
            for (Integer day : days) {
                this.select(day);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(Integer dayOfMonth) {
        PeriodMonth periodMonth = this;
        synchronized (periodMonth) {
            return this.selectedDays.contains(dayOfMonth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(Integer dayOfMonth) {
        PeriodMonth periodMonth = this;
        synchronized (periodMonth) {
            if (!this.isSelected(dayOfMonth)) {
                this.selectedDays.add(dayOfMonth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselected(Integer dayOfMonth) {
        PeriodMonth periodMonth = this;
        synchronized (periodMonth) {
            this.selectedDays.remove(dayOfMonth);
        }
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public OnTheNth getOnTheNth() {
        return this.onTheNth;
    }

    public void setOnTheNth(OnTheNth onTheNth) {
        this.onTheNth = onTheNth;
    }

    public OnTheDay getOnTheDay() {
        return this.onTheDay;
    }

    public void setOnTheDay(OnTheDay onTheDay) {
        this.onTheDay = onTheDay;
    }

    private Date calculateStartDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date calculateEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(2, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    private Date addMonths(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, n);
        return calendar.getTime();
    }

    @Override
    public List<Date> getSelectedDates(Date startDate, Date templateDate) {
        assert (startDate != null);
        assert (templateDate != null);
        Vector<Date> dates = new Vector<Date>();
        Calendar templateCal = Calendar.getInstance();
        templateCal.setTime(templateDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (this.option == Option.Each) {
            for (Integer day : this.selectedDays) {
                cal.set(5, day);
                cal.set(11, templateCal.get(11));
                cal.set(12, templateCal.get(12));
                cal.set(13, templateCal.get(13));
                cal.set(14, templateCal.get(14));
                dates.add(cal.getTime());
            }
        } else if (this.onTheNth == OnTheNth.Last) {
            cal.set(7, this.onTheDay.dayOfWeek);
            cal.set(8, -1);
            cal.set(11, templateCal.get(11));
            cal.set(12, templateCal.get(12));
            cal.set(13, templateCal.get(13));
            cal.set(14, templateCal.get(14));
            dates.add(cal.getTime());
        } else if (this.onTheNth != null) {
            cal.set(7, this.onTheDay.dayOfWeek);
            cal.set(8, this.onTheNth.n);
            cal.set(11, templateCal.get(11));
            cal.set(12, templateCal.get(12));
            cal.set(13, templateCal.get(13));
            cal.set(14, templateCal.get(14));
            dates.add(cal.getTime());
        }
        return dates;
    }

    @Override
    public void initialise(Date startDate) {
        this.option = Option.Each;
        this.selectedDays = new Vector<Integer>();
        if (startDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            this.selectedDays.add(calendar.get(5));
        }
        this.onTheNth = OnTheNth.First;
        this.onTheDay = OnTheDay.Monday;
    }

    @Override
    public int getDefaultAdvanceNbr() {
        return RecurrencePrefs.getNbrFutureMonth();
    }

    @Override
    public PeriodType getType() {
        return PeriodType.MONTH;
    }

    @Override
    public Interval getPeriod(Date date) {
        return new Interval(this.calculateStartDate(date), this.calculateEndDate(date));
    }

    @Override
    public Interval addPeriods(Interval interval, int n) {
        return this.getPeriod(this.addMonths(interval.start, n));
    }

    public String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnTheDay {
        Monday(2),
        Tuesday(3),
        Wednesday(4),
        Thursday(5),
        Friday(6),
        Saturday(7),
        Sunday(1);

        public final int dayOfWeek;

        private OnTheDay(int dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public String toString() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.name().toLowerCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnTheNth {
        First(1),
        Second(2),
        Third(3),
        Fourth(4),
        Last(Integer.MAX_VALUE);

        public final int n;

        private OnTheNth(int n2) {
            this.n = n2;
        }

        public String toString() {
            switch (this.n) {
                case 1: {
                    return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"first");
                }
                case 2: {
                    return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"second");
                }
                case 3: {
                    return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"third");
                }
                case 4: {
                    return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"fourth");
                }
            }
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"last");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        Each,
        OnThe;

    }
}

