/*
 * Decompiled with CFR 0.152.
 */
package tr.model.topic;

import java.awt.Color;
import org.openide.util.NbBundle;
import tr.util.Observable;
import tr.util.ObservableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topic
extends ObservableImpl
implements Comparable<Topic> {
    private static final long serialVersionUID = 989435278L;
    private static final String DEFAULT_NAME = "None";
    private static Topic def;
    private String name = "";
    private String description = "";
    private Color color = Color.black;
    private Color background = Color.white;
    private Integer id;
    public transient String key;

    public Topic(int id) {
        this.id = id;
    }

    public void initID(int id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public String getName() {
        if (this.name.equals(DEFAULT_NAME)) {
            return NbBundle.getMessage(Topic.class, (String)DEFAULT_NAME);
        }
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (name.equals(this.name)) {
            return;
        }
        if (name.equals(DEFAULT_NAME)) {
            return;
        }
        this.name = name;
        this.notifyObservers((Observable)this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null || description.equals(this.description)) {
            return;
        }
        this.description = description;
        this.notifyObservers((Observable)this);
    }

    public Color getForeground() {
        return this.color;
    }

    public void setForeground(Color color) {
        if (color == null || color.equals(this.color)) {
            return;
        }
        this.color = color;
        this.notifyObservers((Observable)this);
    }

    public Color getBackground() {
        return this.background == null ? Color.white : this.background;
    }

    public void setBackground(Color background) {
        if (background == null || background.equals(this.background)) {
            return;
        }
        this.background = background;
        this.notifyObservers((Observable)this);
    }

    public static Topic getDefault() {
        if (def == null) {
            def = new Topic(8);
            Topic.def.name = DEFAULT_NAME;
            Topic.def.description = NbBundle.getMessage(Topic.class, (String)"No_topic");
        }
        return def;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        return object instanceof Topic && this.name.equals(((Topic)object).name);
    }

    @Override
    public int compareTo(Topic topic) {
        if (topic == null || topic.name == null) {
            return -1;
        }
        if (this.name.equals(Topic.getDefault().name)) {
            if (topic.name.equals(Topic.getDefault().name)) {
                return 0;
            }
            return -1;
        }
        if (topic.name.equals(Topic.getDefault().name)) {
            return 1;
        }
        return this.name.compareToIgnoreCase(topic.name);
    }
}

