/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PanelBodyContainer
extends JPanel {
    private String head = null;
    private String message = null;
    private JScrollPane customPanel;
    private JPanel bodyPanel = null;
    private JComponent progressPanel = null;
    private boolean isWaiting = false;
    private Timer delay;
    private ProgressHandle handle;
    private JPanel pBodyPanel;
    private JScrollPane spPanelHeader;
    private JTextPane tpPanelHeader;

    public PanelBodyContainer(String string, String string2, JPanel jPanel) {
        this.head = string;
        this.message = string2;
        this.bodyPanel = jPanel;
        this.initComponents();
        this.writeToHeader(this.head, this.message);
        this.initBodyPanel();
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PanelBodyContainer.this.bodyPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            }
        });
        if (this.isWaiting) {
            this.setWaitingState(true);
        }
    }

    public void setBody(final JPanel jPanel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.bodyPanel = jPanel;
            this.initBodyPanel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PanelBodyContainer.this.bodyPanel = jPanel;
                    PanelBodyContainer.this.initBodyPanel();
                }
            });
        }
    }

    public void setWaitingState(boolean bl) {
        this.setWaitingState(bl, 0L);
    }

    public void setWaitingState(boolean bl, final long l) {
        if (this.isWaiting == bl) {
            return;
        }
        this.isWaiting = bl;
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PanelBodyContainer.this.addProgressLine(l);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PanelBodyContainer.this.removeProgressLine();
                }
            });
        }
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            if (bl) {
                jRootPane.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                jRootPane.setCursor(null);
            }
        }
    }

    private void addProgressLine(long l) {
        this.handle = ProgressHandleFactory.createHandle((String)"PanelBodyContainer_ProgressLine");
        JLabel jLabel = new JLabel(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_PleaseWait"));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
        this.progressPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 12, 0, 12);
        this.progressPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 0, 0, 20);
        gridBagConstraints.weightx = 1.0;
        this.progressPanel.add((Component)jLabel, gridBagConstraints);
        this.progressPanel.setVisible(false);
        this.delay = new Timer(900, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelBodyContainer.this.delay.stop();
                PanelBodyContainer.this.progressPanel.setVisible(true);
                PanelBodyContainer.this.initBodyPanel();
            }
        });
        this.delay.setRepeats(false);
        this.delay.start();
        final String string = NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ProgressLine");
        if (l == 0L) {
            this.handle.start();
            this.handle.progress(string);
        } else {
            assert (l > 0L) : "Estimated time " + l;
            final long l2 = l + 2L;
            this.handle.start((int)l2 * 10, l2);
            this.handle.progress(string, 0);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    int n = 0;
                    while (PanelBodyContainer.this.isWaiting) {
                        try {
                            if (l2 * 10L <= (long)n++) {
                                PanelBodyContainer.this.handle.switchToIndeterminate();
                                PanelBodyContainer.this.handle.progress(string);
                                return;
                            }
                            PanelBodyContainer.this.handle.progress(string, n);
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
        }
    }

    private void initBodyPanel() {
        this.pBodyPanel.removeAll();
        this.customPanel = new JScrollPane();
        this.customPanel.setBorder(null);
        this.pBodyPanel.add((Component)this.customPanel, "Center");
        if (this.isWaiting) {
            this.pBodyPanel.add((Component)this.progressPanel, "South");
        }
        this.customPanel.setViewportView(this.bodyPanel);
        this.customPanel.getVerticalScrollBar().setUnitIncrement(10);
        this.customPanel.getHorizontalScrollBar().setUnitIncrement(10);
        this.revalidate();
    }

    private void removeProgressLine() {
        if (this.progressPanel != null) {
            this.pBodyPanel.remove(this.progressPanel);
            if (this.handle != null) {
                this.handle.finish();
            }
            this.revalidate();
        }
    }

    public void setHeadAndContent(final String string, final String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.writeToHeader(string, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PanelBodyContainer.this.writeToHeader(string, string2);
                }
            });
        }
    }

    private void writeToHeader(String string, String string2) {
        this.tpPanelHeader.setText(null);
        this.tpPanelHeader.setText("<br><b>" + string + "</b> <br>" + string2);
    }

    private void initComponents() {
        this.pBodyPanel = new JPanel();
        this.spPanelHeader = new JScrollPane();
        this.tpPanelHeader = new JTextPane();
        this.pBodyPanel.setLayout(new BorderLayout());
        this.tpPanelHeader.setBackground(SystemColor.controlLtHighlight);
        this.tpPanelHeader.setContentType("text/html");
        this.tpPanelHeader.setEditable(false);
        this.spPanelHeader.setViewportView(this.tpPanelHeader);
        this.tpPanelHeader.getAccessibleContext().setAccessibleName(this.head);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.pBodyPanel, -1, 24, Short.MAX_VALUE).add(2, (Component)this.spPanelHeader, -2, 24, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.spPanelHeader, -2, 78, -2).addPreferredGap(0).add((Component)this.pBodyPanel, -1, -1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACD"));
    }
}

