/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import org.jfree.chart.plot.PlotOrientation;

public abstract class JRBaseChartPlot
implements JRChartPlot,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BACKGROUND_ALPHA = "backgroundAlpha";
    public static final String PROPERTY_FOREGROUND_ALPHA = "foregroundAlpha";
    public static final String PROPERTY_LABEL_ROTATION = "labelRotation";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_SERIES_COLORS = "seriesColors";
    protected JRChart chart = null;
    protected Color backcolor = null;
    protected PlotOrientation orientation = PlotOrientation.VERTICAL;
    protected float backgroundAlpha = 1.0f;
    protected float foregroundAlpha = 1.0f;
    protected double labelRotation = 0.0;
    protected SortedSet seriesColors = null;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseChartPlot(JRChartPlot plot, JRChart chart) {
        this.chart = chart;
        if (plot != null) {
            this.backcolor = plot.getOwnBackcolor();
            this.orientation = plot.getOrientation();
            this.backgroundAlpha = plot.getBackgroundAlpha();
            this.foregroundAlpha = plot.getForegroundAlpha();
            this.labelRotation = plot.getLabelRotation();
            this.seriesColors = new TreeSet(plot.getSeriesColors());
        } else {
            this.seriesColors = new TreeSet();
        }
    }

    protected JRBaseChartPlot(JRChartPlot plot, JRBaseObjectFactory factory) {
        factory.put(plot, this);
        this.chart = (JRChart)factory.getVisitResult(plot.getChart());
        this.backcolor = plot.getOwnBackcolor();
        this.orientation = plot.getOrientation();
        this.backgroundAlpha = plot.getBackgroundAlpha();
        this.foregroundAlpha = plot.getForegroundAlpha();
        this.labelRotation = plot.getLabelRotation();
        this.seriesColors = new TreeSet(plot.getSeriesColors());
    }

    public JRChart getChart() {
        return this.chart;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, old, this.backcolor);
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        PlotOrientation old = this.orientation;
        this.orientation = orientation;
        this.getEventSupport().firePropertyChange(PROPERTY_ORIENTATION, old, this.orientation);
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float backgroundAlpha) {
        float old = this.backgroundAlpha;
        this.backgroundAlpha = backgroundAlpha;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKGROUND_ALPHA, old, this.backgroundAlpha);
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float foregroundAlpha) {
        float old = this.foregroundAlpha;
        this.foregroundAlpha = foregroundAlpha;
        this.getEventSupport().firePropertyChange(PROPERTY_FOREGROUND_ALPHA, old, this.foregroundAlpha);
    }

    public double getLabelRotation() {
        return this.labelRotation;
    }

    public void setLabelRotation(double labelRotation) {
        double old = this.labelRotation;
        this.labelRotation = labelRotation;
        this.getEventSupport().firePropertyChange(PROPERTY_LABEL_ROTATION, old, this.labelRotation);
    }

    public SortedSet getSeriesColors() {
        return this.seriesColors;
    }

    public void clearSeriesColors() {
        this.setSeriesColors(null);
    }

    public void addSeriesColor(JRChartPlot.JRSeriesColor seriesColor) {
        this.seriesColors.add(seriesColor);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_SERIES_COLORS, seriesColor, this.seriesColors.size() - 1);
    }

    public void setSeriesColors(Collection colors) {
        TreeSet old = new TreeSet(this.seriesColors);
        this.seriesColors.clear();
        if (colors != null) {
            this.seriesColors.addAll(colors);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_SERIES_COLORS, old, this.seriesColors);
    }

    public Object clone(JRChart parentChart) {
        JRBaseChartPlot clone = null;
        try {
            clone = (JRBaseChartPlot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.chart = parentChart;
        if (this.seriesColors != null) {
            clone.seriesColors = new TreeSet();
            Iterator it = this.seriesColors.iterator();
            while (it.hasNext()) {
                clone.seriesColors.add(((JRChartPlot.JRSeriesColor)it.next()).clone());
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseChartPlot jRBaseChartPlot = this;
        synchronized (jRBaseChartPlot) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public static class JRBaseSeriesColor
    implements JRChartPlot.JRSeriesColor,
    Serializable,
    Comparable {
        private static final long serialVersionUID = 10200L;
        protected int seriesOrder = -1;
        protected Color color = null;

        public JRBaseSeriesColor(int seriesOrder, Color color) {
            this.seriesOrder = seriesOrder;
            this.color = color;
        }

        public int getSeriesOrder() {
            return this.seriesOrder;
        }

        public Color getColor() {
            return this.color;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            return this.seriesOrder - ((JRBaseSeriesColor)obj).getSeriesOrder();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

