/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Image;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;

public class ImageConverter
extends ElementConverter {
    private static final ImageConverter INSTANCE = new ImageConverter();

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRImage image = (JRImage)element;
        this.copyGraphicElement(reportConverter, image, printImage);
        printImage.copyBox(image.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(image.getAnchorNameExpression()));
        printImage.setBookmarkLevel(image.getBookmarkLevel());
        printImage.setHorizontalAlignment(image.getOwnHorizontalAlignment());
        printImage.setLazy(image.isLazy());
        printImage.setLinkType(image.getLinkType());
        printImage.setOnErrorType(image.getOnErrorType());
        printImage.setVerticalAlignment(image.getOwnVerticalAlignment());
        printImage.setRenderer(this.getRenderer(image));
        printImage.setScaleImage(image.getOwnScaleImage());
        return printImage;
    }

    private JRRenderable getRenderer(JRImage imageElement) {
        JRRenderable imageRenderer = null;
        Image awtImage = null;
        String location = JRExpressionUtil.getSimpleExpressionText(imageElement.getExpression());
        if (location != null) {
            try {
                awtImage = JRImageLoader.loadImage(JRLoader.loadBytesFromLocation(location));
                if (awtImage == null) {
                    awtImage = JRImageLoader.getImage((byte)1);
                    imageElement.setScaleImage((byte)1);
                    imageElement.setStretchType((byte)0);
                }
                imageRenderer = JRImageRenderer.getInstance(awtImage, imageElement.getOnErrorType());
                return imageRenderer;
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        try {
            awtImage = JRImageLoader.getImage((byte)1);
            imageRenderer = JRImageRenderer.getInstance(awtImage, imageElement.getOnErrorType());
            imageElement.setScaleImage((byte)1);
            imageElement.setStretchType((byte)0);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        return imageRenderer;
    }
}

