/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.xmlss;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.export.xmlss.XmlssBorderStyle;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XmlssCellStyle
extends XmlssBorderStyle {
    private static final String ALIGNMENT_LEFT = "Left";
    private static final String ALIGNMENT_RIGHT = "Right";
    private static final String ALIGNMENT_CENTER = "Center";
    private static final String ALIGNMENT_TOP = "Top";
    private static final String ALIGNMENT_BOTTOM = "Bottom";
    private static final String READING_ORDER_LTR = "LeftToRight";
    private static final String READING_ORDER_RTL = "RightToLeft";
    private static final String ROTATE_NONE = "0";
    private static final String ROTATE_LEFT = "90";
    private static final String ROTATE_RIGHT = "-90";
    private static final String STYLE_AUTOMATIC = "Automatic";
    private static final String STYLE_NONE = "None";
    private static final String UNDERLINE_STYLE_SINGLE = "Single";
    private final String id;
    private String backcolor = "Automatic";
    private String horizontalAlignment = "Left";
    private String verticalAlignment = "Top";
    private String readingOrder = "LeftToRight";
    private String rotate = "0";
    private String shrinkToFit;
    private String wrapText = "1";
    private JRStyle style;
    private String verticalPosition = "None";
    private String pattern;
    private String forecolor = "Automatic";
    private JRFont defaultFont;
    private String excelFontName;

    public XmlssCellStyle(Writer styleWriter, JRPrintElement element, Color cellBackground, String pattern, boolean isShrinkToFit, JRFont defaultFont, Map fontMap) {
        super(styleWriter, element);
        JRAlignment alignment;
        this.style = element.getStyle() != null ? element.getStyle() : element.getDefaultStyleProvider().getDefaultStyle();
        this.defaultFont = defaultFont;
        this.pattern = pattern;
        this.shrinkToFit = String.valueOf(this.getBitValue(isShrinkToFit));
        switch (element.getMode()) {
            case 1: {
                this.backcolor = "#" + JRColorUtil.getColorHexa(element.getBackcolor());
                break;
            }
            default: {
                if (cellBackground == null) break;
                this.backcolor = "#" + JRColorUtil.getColorHexa(cellBackground);
            }
        }
        if (element.getForecolor() != null) {
            this.forecolor = "#" + JRColorUtil.getColorHexa(element.getForecolor());
        }
        byte rotation = element instanceof JRPrintText ? ((JRPrintText)element).getRotation() : (byte)0;
        this.rotate = this.getRotation(rotation);
        if (element instanceof JRPrintText && ((JRPrintText)element).getRunDirection() == 1) {
            this.readingOrder = READING_ORDER_RTL;
        }
        JRAlignment jRAlignment = alignment = element instanceof JRAlignment ? (JRAlignment)((Object)element) : null;
        if (alignment != null) {
            this.horizontalAlignment = XmlssCellStyle.getHorizontalAlignment(alignment.getHorizontalAlignment(), alignment.getVerticalAlignment(), rotation);
            this.verticalAlignment = XmlssCellStyle.getVerticalAlignment(alignment.getHorizontalAlignment(), alignment.getVerticalAlignment(), rotation);
        }
        if (this.style != null) {
            String fontName = this.style.getFontName();
            this.excelFontName = fontMap != null && fontMap.containsKey(fontName) ? (String)fontMap.get(fontName) : fontName;
            this.id = this.horizontalAlignment + "|" + this.verticalAlignment + "|" + this.readingOrder + "|" + this.rotate + "|" + this.shrinkToFit + "|" + super.getId() + "|" + this.excelFontName + "|" + this.style.getFontSize() + "|" + this.forecolor + "|" + this.style.isItalic() + "|" + this.style.isBold() + "|" + this.style.isStrikeThrough() + "|" + this.style.isUnderline() + "|" + this.verticalPosition + "|" + this.backcolor + "|" + this.pattern;
        } else {
            String fontName = defaultFont.getFontName();
            this.excelFontName = fontMap != null && fontMap.containsKey(fontName) ? (String)fontMap.get(fontName) : fontName;
            this.id = this.horizontalAlignment + "|" + this.verticalAlignment + "|" + this.readingOrder + "|" + this.rotate + "|" + this.shrinkToFit + "|" + super.getId() + "|" + this.excelFontName + "|" + defaultFont.getFontSize() + "|" + this.forecolor + "|" + defaultFont.isItalic() + "|" + defaultFont.isBold() + "|" + defaultFont.isStrikeThrough() + "|" + defaultFont.isUnderline() + "|" + this.verticalPosition + "|" + this.backcolor + "|" + this.pattern;
        }
    }

    public String getId() {
        return this.id;
    }

    public void write(String cellStyleName) throws IOException {
        this.styleWriter.write("<ss:Style ss:ID=\"");
        this.styleWriter.write(cellStyleName);
        this.styleWriter.write("\">\n");
        this.styleWriter.write(" <ss:Alignment");
        this.styleWriter.write(" ss:Horizontal=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" ss:Vertical=\"" + this.verticalAlignment + "\"");
        this.styleWriter.write(" ss:ReadingOrder=\"" + this.readingOrder + "\"");
        this.styleWriter.write(" ss:Rotate=\"" + this.rotate + "\"");
        this.styleWriter.write(" ss:ShrinkToFit=\"" + this.shrinkToFit + "\"");
        this.styleWriter.write(" ss:WrapText=\"" + this.wrapText + "\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:Borders>");
        this.writeBorder(0);
        this.writeBorder(1);
        this.writeBorder(2);
        this.writeBorder(3);
        this.styleWriter.write(" </ss:Borders>\n");
        this.styleWriter.write(" <ss:Font");
        this.styleWriter.write(" ss:FontName=\"" + this.excelFontName + "\"");
        if (this.style != null) {
            this.styleWriter.write(" ss:Size=\"" + this.style.getFontSize() + "\"");
            this.styleWriter.write(" ss:Bold=\"" + this.getBitValue(this.style.isBold()) + "\"");
            this.styleWriter.write(" ss:Italic=\"" + this.getBitValue(this.style.isItalic()) + "\"");
            this.styleWriter.write(" ss:StrikeThrough=\"" + this.getBitValue(this.style.isStrikeThrough()) + "\"");
            this.styleWriter.write(" ss:Underline=\"" + this.getUnderlineStyle(this.style.isUnderline()) + "\"");
        } else if (this.defaultFont != null) {
            this.styleWriter.write(" ss:Size=\"" + this.defaultFont.getFontSize() + "\"");
            this.styleWriter.write(" ss:Bold=\"" + this.getBitValue(this.defaultFont.isBold()) + "\"");
            this.styleWriter.write(" ss:Italic=\"" + this.getBitValue(this.defaultFont.isItalic()) + "\"");
            this.styleWriter.write(" ss:StrikeThrough=\"" + this.getBitValue(this.defaultFont.isStrikeThrough()) + "\"");
            this.styleWriter.write(" ss:Underline=\"" + this.getUnderlineStyle(this.defaultFont.isUnderline()) + "\"");
        }
        this.styleWriter.write(" ss:Color=\"" + this.forecolor + "\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:Interior");
        this.styleWriter.write(" ss:Color=\"" + this.backcolor + "\"");
        this.styleWriter.write(" ss:Pattern=\"Solid\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:NumberFormat");
        this.styleWriter.write(" ss:Format=\"" + this.pattern + "\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:Protection/>\n");
        this.styleWriter.write("</ss:Style>\n");
    }

    public static String getVerticalAlignment(byte horizontalAlignment, byte verticalAlignment, byte rotation) {
        switch (rotation) {
            case 1: {
                switch (horizontalAlignment) {
                    case 3: {
                        return ALIGNMENT_TOP;
                    }
                    case 2: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_BOTTOM;
            }
            case 2: {
                switch (horizontalAlignment) {
                    case 3: {
                        return ALIGNMENT_BOTTOM;
                    }
                    case 2: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_TOP;
            }
        }
        switch (verticalAlignment) {
            case 3: {
                return ALIGNMENT_BOTTOM;
            }
            case 2: {
                return ALIGNMENT_CENTER;
            }
        }
        return ALIGNMENT_TOP;
    }

    public static String getHorizontalAlignment(byte horizontalAlignment, byte verticalAlignment, byte rotation) {
        switch (rotation) {
            case 1: {
                switch (verticalAlignment) {
                    case 3: {
                        return ALIGNMENT_RIGHT;
                    }
                    case 2: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_LEFT;
            }
            case 2: {
                switch (verticalAlignment) {
                    case 3: {
                        return ALIGNMENT_LEFT;
                    }
                    case 2: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_RIGHT;
            }
        }
        switch (horizontalAlignment) {
            case 3: {
                return ALIGNMENT_RIGHT;
            }
            case 2: {
                return ALIGNMENT_CENTER;
            }
        }
        return ALIGNMENT_LEFT;
    }

    private String getRotation(byte rotation) {
        switch (rotation) {
            case 1: {
                return ROTATE_LEFT;
            }
            case 2: {
                return ROTATE_RIGHT;
            }
        }
        return ROTATE_NONE;
    }

    private byte getBitValue(boolean isTrue) {
        return isTrue ? (byte)1 : 0;
    }

    private String getUnderlineStyle(boolean isUnderline) {
        if (isUnderline) {
            return UNDERLINE_STYLE_SINGLE;
        }
        return STYLE_NONE;
    }
}

