/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.viewers;

import com.sun.activation.viewers.ImageViewerCanvas;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class ImageViewer
extends Panel
implements CommandObject {
    private ImageViewerCanvas canvas = new ImageViewerCanvas();
    private Image image = null;
    private DataHandler _dh = null;
    private boolean DEBUG = false;

    public ImageViewer() {
        this.add(this.canvas);
    }

    public void setCommandContext(String string, DataHandler dataHandler) throws IOException {
        this._dh = dataHandler;
        this.setInputStream(this._dh.getInputStream());
    }

    private void setInputStream(InputStream inputStream) throws IOException {
        MediaTracker mediaTracker = new MediaTracker(this);
        int n = 0;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.image = this.getToolkit().createImage(byteArrayOutputStream.toByteArray());
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForID(0);
            mediaTracker.waitForAll();
            if (mediaTracker.statusID(0, true) != 8) {
                System.out.println("Error occured in image loading = " + mediaTracker.getErrorsID(0));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Error reading image data");
        }
        this.canvas.setImage(this.image);
        if (this.DEBUG) {
            System.out.println("calling invalidate");
        }
    }

    public void addNotify() {
        super.addNotify();
        this.invalidate();
        this.validate();
        this.doLayout();
    }

    public Dimension getPreferredSize() {
        return this.canvas.getPreferredSize();
    }
}

