/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.date.field;

import au.com.trgtd.tr.appl.Constants;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.MaskFormatter;
import org.openide.util.NbBundle;
import tr.prefs.dates.DatesPrefs;
import tr.swing.date.chooser.DateChooser;
import tr.swing.date.chooser.DateChooserDialog;
import tr.util.Utils;

public class DateField
extends JComponent
implements ActionListener,
FocusListener {
    private static final Dimension SIZE = new Dimension(110, 23);
    private static final String TEXT_FORMAT = NbBundle.getMessage(DateField.class, (String)"format");
    private static final String INPUT_PATTERN_DDMMYY = "dd/MM/yy";
    private static final String INPUT_PATTERN_MMDDYY = "MM/dd/yy";
    private static final String DISPLAY_PATTERN_DDMMYY = "dd/MM/yyyy";
    private static final String DISPLAY_PATTERN_MMDDYY = "MM/dd/yyyy";
    private static final String TOOL_TIP_DDMMYY = TEXT_FORMAT + ": DD/MM/YYYY";
    private static final String TOOL_TIP_MMDDYY = TEXT_FORMAT + ": MM/DD/YYYY";
    private static final char PLACEHOLDER = '_';
    private static final String MASK = "##/##/####";
    private static DateFormat DISPLAY_FORMAT = DateField.getDisplayFormat();
    private static DateFormat INPUT_FORMAT = DateField.getInputFormat();
    private static Icon icon = new ImageIcon(DateField.class.getResource("/tr/swing/date/field/Down16.gif"));
    private final JFormattedTextField ftf = new FTF(DateField.getMaskFormatter());
    private final JButton btn = this.createButton();
    private DateChooser dateChooser;
    private Date date;

    private static DateFormat getInputFormat() {
        String pattern = DatesPrefs.getDateOrder() == 0 ? INPUT_PATTERN_MMDDYY : INPUT_PATTERN_DDMMYY;
        SimpleDateFormat inputFormat = new SimpleDateFormat(pattern);
        inputFormat.setLenient(false);
        return inputFormat;
    }

    private static DateFormat getDisplayFormat() {
        String pattern = DatesPrefs.getDateOrder() == 0 ? DISPLAY_PATTERN_MMDDYY : DISPLAY_PATTERN_DDMMYY;
        SimpleDateFormat displayFormat = new SimpleDateFormat(pattern);
        displayFormat.setLenient(false);
        return displayFormat;
    }

    public DateField() {
        this.ftf.addPropertyChangeListener("value", new ValueDateGuard());
        this.ftf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    e.consume();
                    DateField.this.popupCalendar();
                }
            }
        });
        this.initialise();
        this.setPreferredSize(SIZE);
        this.setMinimumSize(SIZE);
        this.setMaximumSize(SIZE);
    }

    private static MaskFormatter getMaskFormatter() {
        try {
            DateMaskFormatter maskFormatter = new DateMaskFormatter(MASK);
            maskFormatter.setPlaceholderCharacter('_');
            return maskFormatter;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void initialise() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.btn.addActionListener(this);
        this.ftf.addActionListener(this);
        this.ftf.addFocusListener(this);
        this.ftf.setAlignmentX(0.0f);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.ftf);
        this.add(Box.createHorizontalGlue());
        this.add(this.btn);
        DatesPrefs.prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey().equals("date.order")) {
                    INPUT_FORMAT = DateField.getInputFormat();
                    DISPLAY_FORMAT = DateField.getDisplayFormat();
                }
            }
        });
    }

    private JButton createButton() {
        JButton button = new JButton();
        button.setIcon(icon);
        button.setFocusable(false);
        int width = 18;
        int minHeight = 23;
        int maxHeight = 27;
        int height = this.getPreferredSize().height;
        height = height < minHeight ? minHeight : height;
        height = height > maxHeight ? maxHeight : height;
        button.setPreferredSize(new Dimension(width, height));
        button.setMinimumSize(new Dimension(width, minHeight));
        button.setMaximumSize(new Dimension(width, maxHeight));
        button.setAlignmentX(0.0f);
        return button;
    }

    public Date getDate() {
        return this.date;
    }

    public final JFormattedTextField getDateField() {
        return this.ftf;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.btn)) {
            this.popupCalendar();
        } else if (ae.getSource().equals(this.ftf)) {
            this.setDate(this.getTextDate());
        }
    }

    public void focusGained(FocusEvent fe) {
    }

    public void focusLost(FocusEvent fe) {
        if (fe.getSource().equals(this.ftf) && !fe.isTemporary()) {
            this.setDate(this.getTextDate());
        }
    }

    public final JButton getButton() {
        return this.btn;
    }

    protected final Date getTextDate() {
        try {
            return DateField.parseDate(this.ftf.getText());
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static Date parseDate(String text) throws ParseException {
        try {
            return INPUT_FORMAT.parse(text);
        }
        catch (ParseException pe) {
            return DISPLAY_FORMAT.parse(text);
        }
    }

    protected Date getValueDate() {
        try {
            return DISPLAY_FORMAT.parse((String)this.ftf.getValue());
        }
        catch (ParseException e) {
            return null;
        }
    }

    private void popupCalendar() {
        if (this.dateChooser == null) {
            Window parent = SwingUtilities.windowForComponent(this);
            this.dateChooser = parent instanceof Frame ? new DateChooser((Frame)parent) : (parent instanceof Dialog ? new DateChooser((Dialog)parent) : new DateChooser(new Frame()));
        }
        DateChooserDialog dialog = this.dateChooser.getDialog();
        Date newDate = dialog.select(this.date, this);
        if (dialog.cancelled()) {
            return;
        }
        this.setDate(newDate);
        this.ftf.transferFocus();
    }

    public void setDate(Date date) {
        this.setInternalDate(date);
        this.setValueDate(date);
        this.setToolTipText();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.btn.setEnabled(b);
        this.ftf.setEnabled(b);
    }

    protected final void setInternalDate(Date newDate) {
        if (Utils.equal((Object)this.date, (Object)newDate)) {
            return;
        }
        Date oldDate = this.date;
        this.date = newDate;
        this.firePropertyChange("value", oldDate, newDate);
    }

    private void setToolTipText() {
        String tttEntry;
        if (this.ftf == null) {
            return;
        }
        String string = tttEntry = DatesPrefs.getDateOrder() == 0 ? TOOL_TIP_MMDDYY : TOOL_TIP_DDMMYY;
        if (this.date == null) {
            this.ftf.setToolTipText(tttEntry);
        } else {
            this.ftf.setToolTipText(Constants.DATE_FORMAT_FIXED.format(this.date) + " (" + tttEntry + ")");
        }
    }

    protected void setValueDate(Date date) {
        this.ftf.setValue(date == null ? null : DISPLAY_FORMAT.format(date));
    }

    public Insets getMargin() {
        return this.ftf.getMargin();
    }

    private static class FTF
    extends JFormattedTextField {
        public FTF(MaskFormatter f) {
            super(f);
        }

        protected void invalidEdit() {
        }
    }

    private final class ValueDateGuard
    implements PropertyChangeListener {
        private ValueDateGuard() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DateField.this.setInternalDate(DateField.this.getTextDate());
        }
    }

    private static class DateMaskFormatter
    extends MaskFormatter {
        public DateMaskFormatter(String mask) throws ParseException {
            super(mask);
        }

        public Object stringToValue(String value) throws ParseException {
            try {
                return super.stringToValue(value);
            }
            catch (ParseException e) {
                try {
                    return DISPLAY_FORMAT.format(DateField.parseDate(value));
                }
                catch (ParseException notcheckedException) {
                    throw e;
                }
            }
        }
    }
}

