/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.netbeans.core.startup.preferences.NbPreferences;
import org.netbeans.core.startup.preferences.Statistics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;

class PropertiesStorage
implements NbPreferences.FileStorage {
    private static final String USERROOT_PREFIX = "/Preferences";
    private static final String SYSTEMROOT_PREFIX = "/SystemPreferences";
    private static final FileObject SFS_ROOT = Repository.getDefault().getDefaultFileSystem().getRoot();
    private final String folderPath;
    private String filePath;
    private boolean isModified;

    static NbPreferences.FileStorage instance(String string) {
        return new PropertiesStorage(string, true);
    }

    FileObject preferencesRoot() throws IOException {
        return FileUtil.createFolder((FileObject)SFS_ROOT, (String)USERROOT_PREFIX);
    }

    static NbPreferences.FileStorage instanceReadOnly(String string) {
        return new PropertiesStorage(string, false){

            public boolean isReadOnly() {
                return true;
            }

            public final String[] childrenNames() {
                return new String[0];
            }

            public final Properties load() throws IOException {
                return new Properties();
            }

            protected FileObject toPropertiesFile(boolean bl) throws IOException {
                if (bl) {
                    throw new IOException();
                }
                return null;
            }

            protected FileObject toFolder(boolean bl) throws IOException {
                if (bl) {
                    throw new IOException();
                }
                return null;
            }

            protected FileObject toPropertiesFile() {
                return null;
            }

            protected FileObject toFolder() {
                return null;
            }

            FileObject preferencesRoot() throws IOException {
                return FileUtil.createFolder((FileObject)SFS_ROOT, (String)PropertiesStorage.SYSTEMROOT_PREFIX);
            }
        };
    }

    private PropertiesStorage(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = bl ? USERROOT_PREFIX : SYSTEMROOT_PREFIX;
        stringBuffer.append(string2).append(string);
        this.folderPath = stringBuffer.toString();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void markModified() {
        this.isModified = true;
    }

    public final boolean existsNode() {
        return this.toPropertiesFile() != null || this.toFolder() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childrenNames() {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.CHILDREN_NAMES, true);
        try {
            FileObject fileObject = this.toFolder();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (fileObject != null) {
                block3: for (FileObject fileObject2 : Collections.list(fileObject.getFolders(false))) {
                    Enumeration enumeration = fileObject2.getChildren(true);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject3 = (FileObject)enumeration.nextElement();
                        if (!fileObject3.hasExt("properties")) continue;
                        arrayList.add(fileObject2.getNameExt());
                        continue block3;
                    }
                }
                for (FileObject fileObject2 : Collections.list(fileObject.getData(false))) {
                    if (!fileObject2.hasExt("properties")) continue;
                    arrayList.add(fileObject2.getName());
                }
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            return stringArray;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNode() throws IOException {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REMOVE_NODE, true);
        try {
            FileObject fileObject = this.toPropertiesFile();
            if (fileObject != null && fileObject.isValid()) {
                fileObject.delete();
                for (FileObject fileObject2 = fileObject.getParent(); fileObject2 != null && fileObject2 != this.preferencesRoot() && fileObject2.getChildren().length == 0; fileObject2 = fileObject2.getParent()) {
                    fileObject2.delete();
                }
            }
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties load() throws IOException {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LOAD, true);
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.inputStream();
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Properties properties) throws IOException {
        block11: {
            if (this.isModified) {
                Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.FLUSH, true);
                try {
                    this.isModified = false;
                    if (!properties.isEmpty()) {
                        OutputStream outputStream = null;
                        try {
                            outputStream = this.outputStream();
                            properties.store(outputStream, null);
                            break block11;
                        }
                        finally {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                    }
                    FileObject fileObject = this.toPropertiesFile();
                    if (fileObject != null) {
                        fileObject.delete();
                    }
                    for (FileObject fileObject2 = this.toFolder(); fileObject2 != null && fileObject2 != this.preferencesRoot() && fileObject2.getChildren().length == 0; fileObject2 = fileObject2.getParent()) {
                        fileObject2.delete();
                    }
                }
                finally {
                    stopWatch.stop();
                }
            }
        }
    }

    private InputStream inputStream() throws IOException {
        FileObject fileObject = this.toPropertiesFile(false);
        return fileObject == null ? null : fileObject.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream outputStream() throws IOException {
        FileObject fileObject = this.toPropertiesFile(true);
        final FileLock fileLock = fileObject.lock();
        OutputStream outputStream = null;
        try {
            outputStream = fileObject.getOutputStream(fileLock);
        }
        finally {
            if (outputStream == null && fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return new FilterOutputStream(outputStream){

            public void close() throws IOException {
                super.close();
                fileLock.releaseLock();
            }
        };
    }

    private String folderPath() {
        return this.folderPath;
    }

    private String filePath() {
        if (this.filePath == null) {
            String[] stringArray = this.folderPath().split("/");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i]).append("/");
            }
            if (stringArray.length > 0) {
                stringBuilder.append(stringArray[stringArray.length - 1]).append(".properties");
            } else {
                stringBuilder.append("root.properties");
            }
            this.filePath = stringBuilder.toString();
        }
        return this.filePath;
    }

    protected FileObject toFolder() {
        return SFS_ROOT.getFileObject(this.folderPath());
    }

    protected FileObject toPropertiesFile() {
        return SFS_ROOT.getFileObject(this.filePath());
    }

    protected FileObject toFolder(boolean bl) throws IOException {
        FileObject fileObject = this.toFolder();
        if (fileObject == null && bl) {
            fileObject = FileUtil.createFolder((FileObject)SFS_ROOT, (String)this.folderPath);
        }
        assert (fileObject == null && !bl || fileObject != null && fileObject.isFolder());
        return fileObject;
    }

    protected FileObject toPropertiesFile(boolean bl) throws IOException {
        FileObject fileObject = this.toPropertiesFile();
        if (fileObject == null && bl) {
            fileObject = FileUtil.createData((FileObject)SFS_ROOT, (String)this.filePath());
        }
        assert (fileObject == null && !bl || fileObject != null && fileObject.isData());
        return fileObject;
    }

    public void runAtomic(final Runnable runnable) {
        try {
            SFS_ROOT.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    runnable.run();
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

