/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future.screen;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.logging.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import tr.view.Window;
import tr.view.future.screen.FutureNode;
import tr.view.future.screen.FuturePanel;
import tr.view.future.screen.FuturesTopComponent;

public final class FutureTopComponent
extends Window
implements LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.view.future");
    private static final String PREFERRED_ID = "FutureTopComponent";
    private static FutureTopComponent instance;
    private FuturePanel panel;
    private Lookup.Result result;

    private FutureTopComponent() {
        this.setName(NbBundle.getMessage(FutureTopComponent.class, (String)"CTL_FutureTopComponent"));
        this.setToolTipText(NbBundle.getMessage(FutureTopComponent.class, (String)"TTT_FutureTopComponent"));
        this.setIcon(Icons.SomedayMaybe.getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    protected void componentOpened() {
        super.componentOpened();
        if (this.panel == null) {
            this.removeAll();
            this.panel = new FuturePanel();
            this.add(this.panel, "Center");
        }
        this.panel.initModel(null);
        FuturesTopComponent rtc = FuturesTopComponent.findInstance();
        this.result = rtc.getLookup().lookup(new Lookup.Template(FutureNode.class));
        this.result.addLookupListener((LookupListener)this);
        this.result.allInstances();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    protected void componentDeactivated() {
        this.panel.deactivate();
        super.componentDeactivated();
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        LOG.info("Starting");
        if (this.panel == null) {
            return;
        }
        Collection collection = this.result.allInstances();
        if (collection.isEmpty()) {
            this.panel.initModel(null);
            LOG.info("null");
        } else {
            FutureNode node = (FutureNode)collection.iterator().next();
            this.panel.initModel(node.future);
            LOG.info("initialising model");
        }
    }

    public void edit() {
        if (this.panel == null) {
            return;
        }
        this.requestActive();
        this.panel.edit();
    }

    public static synchronized FutureTopComponent getDefault() {
        if (instance == null) {
            instance = new FutureTopComponent();
        }
        return instance;
    }

    public static synchronized FutureTopComponent findInstance() {
        return FutureTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.future");
    }
}

