/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.bruteforce.GuessProviderType;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.config.PskBruteForcerAttackClientCommandConfig;
import de.rub.nds.tlsattacker.attacks.config.delegate.AttackDelegate;
import de.rub.nds.tlsattacker.attacks.exception.WordlistNotFoundException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ProtocolVersionDelegate;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;

public class PskBruteForcerAttackServerCommandConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "pskbruteforcerserver";
    @ParametersDelegate
    private ClientDelegate clientDelegate;
    @ParametersDelegate
    private CiphersuiteDelegate ciphersuiteDelegate;
    @ParametersDelegate
    private ProtocolVersionDelegate protocolVersionDelegate;
    @ParametersDelegate
    private AttackDelegate attackDelegate;
    @Parameter(names={"-guessProviderType"}, description="Chooses how the BruteForcer will choose the keys to guess")
    private GuessProviderType guessProviderType = GuessProviderType.INCREMENTING;
    @Parameter(names={"-guessProviderInputFile"}, description="Set the path to an input file which can be used in the guess provider eg. a path to a wordlist")
    private String guessProviderInputFile = null;
    @Parameter(names={"-clientIdentity"}, description="Set a Client Identity")
    private String clientIdentity;
    @Parameter(names={"-pskIdentity"}, description="Set the Psk Identity, that should be used")
    private String pskIdentity = "Client_identity";

    public PskBruteForcerAttackServerCommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.clientDelegate = new ClientDelegate();
        this.ciphersuiteDelegate = new CiphersuiteDelegate();
        this.protocolVersionDelegate = new ProtocolVersionDelegate();
        this.attackDelegate = new AttackDelegate();
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.ciphersuiteDelegate);
        this.addDelegate(this.protocolVersionDelegate);
        this.addDelegate(this.attackDelegate);
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        if (this.ciphersuiteDelegate.getCipherSuites() == null) {
            LinkedList<CipherSuite> cipherSuiteList = new LinkedList<CipherSuite>();
            for (CipherSuite cipherSuite : CipherSuite.getImplemented()) {
                if (!cipherSuite.isPsk()) continue;
                cipherSuiteList.add(cipherSuite);
            }
            config.setDefaultClientSupportedCiphersuites(cipherSuiteList);
        }
        config.setQuickReceive(true);
        config.setEarlyStop(true);
        config.setStopActionsAfterFatal(true);
        return config;
    }

    @Override
    public boolean isExecuteAttack() {
        return this.attackDelegate.isExecuteAttack();
    }

    public String getClientIdentity() {
        return this.clientIdentity;
    }

    public String getPskIdentity() {
        return this.pskIdentity;
    }

    public String getGuessProviderInputFile() {
        return this.guessProviderInputFile;
    }

    public InputStream getGuessProviderInputStream() {
        if (this.guessProviderInputFile == null) {
            if (this.guessProviderType == GuessProviderType.WORDLIST) {
                return PskBruteForcerAttackClientCommandConfig.class.getClassLoader().getResourceAsStream("psk_common_passwords.txt");
            }
            return System.in;
        }
        File file = new File(this.getGuessProviderInputFile());
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new WordlistNotFoundException("Wordlist not found: " + file.getAbsolutePath(), ex);
        }
    }

    public GuessProviderType getGuessProviderType() {
        return this.guessProviderType;
    }

    public void setGuessProviderType(GuessProviderType guessProviderType) {
        this.guessProviderType = guessProviderType;
    }
}

