/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum EllipticCurveType {
    EXPLICIT_PRIME(1),
    EXPLICIT_CHAR2(2),
    NAMED_CURVE(3);

    public static final int LENGTH = 1;
    private byte value;
    private static final Map<Byte, EllipticCurveType> MAP;

    private EllipticCurveType(byte value) {
        this.value = value;
    }

    public static EllipticCurveType getCurveType(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return this.value;
    }

    static {
        MAP = new HashMap<Byte, EllipticCurveType>();
        for (EllipticCurveType c : EllipticCurveType.values()) {
            MAP.put(c.value, c);
        }
    }
}

