/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientHelloSerializer
extends ProtocolMessageSerializer<SSL2ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SSL2ClientHelloMessage msg;

    public SSL2ClientHelloSerializer(SSL2ClientHelloMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        LOGGER.debug("Serializing SSL2ClientHello");
        this.writeMessageLength(this.msg);
        this.writeType(this.msg);
        this.writeProtocolVersion(this.msg);
        this.writeCipherSuiteLength(this.msg);
        this.writeSessionIDLength(this.msg);
        this.writeChallengeLength(this.msg);
        this.writeCipherSuites(this.msg);
        this.writeSessionID(this.msg);
        this.writeChallenge(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeMessageLength(SSL2ClientHelloMessage msg) {
        if ((Integer)msg.getPaddingLength().getValue() != 0) {
            throw new UnsupportedOperationException("Long record headers are not supported");
        }
        this.appendInt((int)((Integer)msg.getMessageLength().getValue() ^ 0x8000), 2);
        LOGGER.debug("MessageLength: " + msg.getMessageLength().getValue());
    }

    private void writeType(SSL2ClientHelloMessage msg) {
        this.appendByte((Byte)msg.getType().getValue());
        LOGGER.debug("Type: " + msg.getType().getValue());
    }

    private void writeProtocolVersion(SSL2ClientHelloMessage msg) {
        this.appendBytes((byte[])msg.getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getProtocolVersion().getValue())));
    }

    private void writeCipherSuiteLength(SSL2ClientHelloMessage msg) {
        this.appendInt((Integer)msg.getCipherSuiteLength().getValue(), 2);
        LOGGER.debug("CipherSuiteLength: " + msg.getCipherSuiteLength().getValue());
    }

    private void writeSessionIDLength(SSL2ClientHelloMessage msg) {
        this.appendInt((Integer)msg.getSessionIdLength().getValue(), 2);
        LOGGER.debug("SessionIDLength: " + msg.getSessionIdLength().getValue());
    }

    private void writeChallengeLength(SSL2ClientHelloMessage msg) {
        this.appendInt((Integer)msg.getChallengeLength().getValue(), 2);
        LOGGER.debug("ChallengeLength: " + msg.getChallengeLength().getValue());
    }

    private void writeCipherSuites(SSL2ClientHelloMessage msg) {
        this.appendBytes((byte[])msg.getCipherSuites().getValue());
        LOGGER.debug("CipherSuites: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCipherSuites().getValue())));
    }

    private void writeSessionID(SSL2ClientHelloMessage msg) {
        this.appendBytes((byte[])msg.getSessionId().getValue());
        LOGGER.debug("SessionID: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSessionId().getValue())));
    }

    private void writeChallenge(SSL2ClientHelloMessage msg) {
        this.appendBytes((byte[])msg.getChallenge().getValue());
        LOGGER.debug("Challenge: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getChallenge().getValue())));
    }
}

