/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrintSecretsAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public PrintSecretsAction() {
    }

    public PrintSecretsAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext ctx = state.getTlsContext(this.connectionAlias);
        StringBuilder sb = new StringBuilder("\n\nContext: " + ctx);
        sb.append("\n  (Record Layer) ");
        if (ctx.getSelectedCipherSuite() == null) {
            sb.append("\n  CipherSuite: null");
        } else {
            sb.append("\n  CipherSuite: ").append(ctx.getSelectedCipherSuite().name());
        }
        sb.append("\n  (RSA Key Exchange) ");
        if (ctx.getChooser().getServerRSAPublicKey() == null) {
            sb.append("\n  ServerRsaPublicKey (chooser): null");
        } else {
            sb.append("\n  ServerRsaPublicKey (chooser): ");
            sb.append(ctx.getChooser().getServerRSAPublicKey());
        }
        if (ctx.getChooser().getServerRsaModulus() == null) {
            sb.append("\n  ServerRsaModulus(chooser): null");
        } else {
            sb.append("\n  ServerRsaModulus (chooser): ");
            sb.append(this.toIndentedString(ArrayConverter.bigIntegerToByteArray((BigInteger)ctx.getChooser().getServerRsaModulus())));
        }
        sb.append("\n\n  (Handshake) ");
        sb.append("\n  Client Random: ").append(this.toIndentedString(ctx.getClientRandom()));
        sb.append("\n  Server Random: ").append(this.toIndentedString(ctx.getServerRandom()));
        sb.append("\n  PreMasterSecret: ").append(this.toIndentedString(ctx.getPreMasterSecret()));
        sb.append("\n  MasterSecret: ").append(this.toIndentedString(ctx.getMasterSecret()));
        if (ctx.getLastClientVerifyData() == null) {
            sb.append("\n  LastClientVerifyData: null");
        } else {
            sb.append("\n  LastClientVerifyData: ").append(this.toIndentedString(ctx.getLastClientVerifyData()));
        }
        if (ctx.getLastServerVerifyData() == null) {
            sb.append("\n  LastServerVerifyData: null");
        } else {
            sb.append("\n  LastServerVerifyData: ").append(this.toIndentedString(ctx.getLastServerVerifyData()));
        }
        ConsoleLogger.CONSOLE.info(sb.append("\n").toString());
    }

    private String toIndentedString(byte[] bytes) {
        return ArrayConverter.bytesToHexString((byte[])bytes).replace("\n", "\n  ");
    }

    @Override
    public boolean executedAsPlanned() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void reset() {
    }
}

