/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class Main {
    private static final Options OPTS = new Options();
    static /* synthetic */ Class class$com$puppycrawl$tools$checkstyle$Main;

    public static void main(String[] aArgs) {
        int i;
        Properties props;
        PosixParser clp = new PosixParser();
        CommandLine line = null;
        try {
            line = clp.parse(OPTS, aArgs);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Main.usage();
        }
        Properties properties = props = line.hasOption("p") ? Main.loadProperties(new File(line.getOptionValue("p"))) : System.getProperties();
        if (!line.hasOption("c")) {
            System.out.println("Must specify a config XML file.");
            Main.usage();
        }
        Configuration config = null;
        try {
            config = ConfigurationLoader.loadConfiguration(line.getOptionValue("c"), new PropertiesExpander(props));
        }
        catch (CheckstyleException e) {
            System.out.println("Error loading configuration file");
            e.printStackTrace(System.out);
            System.exit(1);
        }
        ModuleFactory moduleFactory = null;
        if (line.hasOption("n")) {
            try {
                moduleFactory = PackageNamesLoader.loadModuleFactory(line.getOptionValue("n"));
            }
            catch (CheckstyleException e) {
                System.out.println("Error loading package names file");
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
        OutputStream out = null;
        boolean closeOut = false;
        if (line.hasOption("o")) {
            String fname = line.getOptionValue("o");
            try {
                out = new FileOutputStream(fname);
                closeOut = true;
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not find file: '" + fname + "'");
                System.exit(1);
            }
        } else {
            out = System.out;
            closeOut = false;
        }
        String format = line.hasOption("f") ? line.getOptionValue("f") : "plain";
        AuditListener listener = null;
        if ("xml".equals(format)) {
            listener = new XMLLogger(out, closeOut);
        } else if ("plain".equals(format)) {
            listener = new DefaultLogger(out, closeOut);
        } else {
            System.out.println("Invalid format: (" + format + "). Must be 'plain' or 'xml'.");
            Main.usage();
        }
        LinkedList<File> files = new LinkedList<File>();
        if (line.hasOption("r")) {
            String[] values = line.getOptionValues("r");
            i = 0;
            while (i < values.length) {
                Main.traverse(new File(values[i]), files);
                ++i;
            }
        }
        String[] remainingArgs = line.getArgs();
        i = 0;
        while (i < remainingArgs.length) {
            files.add(new File(remainingArgs[i]));
            ++i;
        }
        if (files.isEmpty()) {
            System.out.println("Must specify files to process");
            Main.usage();
        }
        Checker c = null;
        try {
            c = new Checker();
            c.setModuleFactory(moduleFactory);
            c.configure(config);
            c.addListener(listener);
        }
        catch (Exception e) {
            System.out.println("Unable to create Checker: " + e.getMessage());
            e.printStackTrace(System.out);
            System.exit(1);
        }
        File[] processedFiles = new File[files.size()];
        files.toArray(processedFiles);
        int numErrs = c.process(processedFiles);
        c.destroy();
        System.exit(numErrs);
    }

    private static void usage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("java " + (class$com$puppycrawl$tools$checkstyle$Main == null ? (class$com$puppycrawl$tools$checkstyle$Main = Main.class$("com.puppycrawl.tools.checkstyle.Main")) : class$com$puppycrawl$tools$checkstyle$Main).getName() + " [options] -c <config.xml> file...", OPTS);
        System.exit(1);
    }

    private static void traverse(File aNode, List aFiles) {
        if (aNode.canRead()) {
            if (aNode.isDirectory()) {
                File[] nodes = aNode.listFiles();
                int i = 0;
                while (i < nodes.length) {
                    Main.traverse(nodes[i], aFiles);
                    ++i;
                }
            } else if (aNode.isFile()) {
                aFiles.add(aNode);
            }
        }
    }

    private static Properties loadProperties(File aFile) {
        Properties properties = new Properties();
        try {
            FileInputStream fis = null;
            fis = new FileInputStream(aFile);
            properties.load(fis);
            fis.close();
        }
        catch (IOException ex) {
            System.out.println("Unable to load properties from file: " + aFile.getAbsolutePath());
            ex.printStackTrace(System.out);
            System.exit(1);
        }
        return properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OPTS.addOption("c", true, "The check configuration file to use.");
        OPTS.addOption("r", true, "Traverse the directory for source files");
        OPTS.addOption("o", true, "Sets the output file. Defaults to stdout");
        OPTS.addOption("p", true, "Loads the properties file");
        OPTS.addOption("n", true, "Loads the package names file");
        OPTS.addOption("f", true, "Sets the output format. (plain|xml). Defaults to plain");
    }
}

