/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.Log4jConsoleAppender;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.Log4jKettleLayout;
import org.pentaho.di.core.logging.Log4jMessage;
import org.pentaho.di.core.logging.Log4jStringAppender;
import org.pentaho.di.core.logging.Messages;
import org.pentaho.di.core.vfs.KettleVFS;

public class LogWriter {
    private static LogWriter logWriter;
    public static final int LOG_LEVEL_NOTHING = 0;
    public static final int LOG_LEVEL_ERROR = 1;
    public static final int LOG_LEVEL_MINIMAL = 2;
    public static final int LOG_LEVEL_BASIC = 3;
    public static final int LOG_LEVEL_DETAILED = 4;
    public static final int LOG_LEVEL_DEBUG = 5;
    public static final int LOG_LEVEL_ROWLEVEL = 6;
    public static final String[] logLevelDescription;
    public static final String[] log_level_desc_long;
    public static final String STRING_PENTAHO_DI_LOGGER_NAME = "org.pentaho.di";
    public static final String STRING_PENTAHO_DI_CONSOLE_APPENDER = "ConsoleAppender:org.pentaho.di";
    private int type;
    private int level;
    private String filter;
    private Logger pentahoLogger = Logger.getLogger((String)"org.pentaho.di");
    private Log4jFileAppender fileAppender;
    private File realFilename;
    private static Layout layout;

    public static final LogWriter getInstance() {
        if (logWriter != null) {
            return logWriter;
        }
        return LogWriter.getInstance(3);
    }

    public static final LogWriter getInstance(int lvl) {
        if (logWriter != null) {
            logWriter.setLogLevel(lvl);
            return logWriter;
        }
        logWriter = new LogWriter(lvl);
        return logWriter;
    }

    private LogWriter() {
        this.pentahoLogger.setAdditivity(false);
        this.pentahoLogger.setLevel(Level.ALL);
        layout = new Log4jKettleLayout();
        boolean consoleAppenderFound = false;
        Enumeration appenders = this.pentahoLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof ConsoleAppender)) continue;
            consoleAppenderFound = true;
            break;
        }
        if (!consoleAppenderFound) {
            PatternLayout patternLayout = new PatternLayout("%-5p %d{dd-MM HH:mm:ss,SSS} - %m%n");
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout);
            consoleAppender.setName(STRING_PENTAHO_DI_CONSOLE_APPENDER);
            this.pentahoLogger.addAppender((Appender)consoleAppender);
        }
    }

    private LogWriter(int lvl) {
        this();
        this.level = lvl;
        this.filter = null;
    }

    public static final LogWriter getInstance(String filename, boolean exact, int level) throws KettleException {
        if (logWriter != null) {
            logWriter.setLogLevel(level);
            if (LogWriter.logWriter.pentahoLogger.getAppender(LogWriter.createFileAppenderName(filename, exact)) == null) {
                LogWriter.logWriter.fileAppender = LogWriter.createFileAppender(filename, exact);
                logWriter.addAppender(LogWriter.logWriter.fileAppender);
            }
            return logWriter;
        }
        logWriter = new LogWriter(filename, exact, level);
        return logWriter;
    }

    public static final void closeAndRemoveFileAppender() {
        if (LogWriter.logWriter.fileAppender != null) {
            LogWriter.logWriter.fileAppender.close();
            LogWriter.logWriter.pentahoLogger.removeAppender((Appender)LogWriter.logWriter.fileAppender);
        }
    }

    private LogWriter(String filename, boolean exact, int level) {
        this();
        this.level = level;
        try {
            this.fileAppender = LogWriter.createFileAppender(filename, exact);
            this.addAppender(this.fileAppender);
        }
        catch (Exception e) {
            System.out.println("ERROR OPENING LOG FILE [" + filename + "] --> " + e.toString());
        }
    }

    public static final Log4jFileAppender createFileAppender(String filename, boolean exact) throws KettleFileException {
        try {
            FileObject file = !exact ? KettleVFS.createTempFile(filename, ".log", System.getProperty("java.io.tmpdir")) : KettleVFS.getFileObject(filename);
            Log4jFileAppender appender = new Log4jFileAppender(file);
            appender.setLayout(new Log4jKettleLayout(true));
            appender.setName(LogWriter.createFileAppenderName(filename, exact));
            return appender;
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to add Kettle file appender to Log4J", e);
        }
    }

    public static final Log4jFileAppender createFileAppender(String filename, boolean exact, boolean append) throws KettleFileException {
        try {
            FileObject file = !exact ? KettleVFS.createTempFile(filename, ".log", System.getProperty("java.io.tmpdir")) : KettleVFS.getFileObject(filename);
            Log4jFileAppender appender = new Log4jFileAppender(file, append);
            appender.setLayout(new Log4jKettleLayout(true));
            appender.setName(LogWriter.createFileAppenderName(filename, exact));
            return appender;
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to add Kettle file appender to Log4J", e);
        }
    }

    public static final String createFileAppenderName(String filename, boolean exact) {
        if (!exact) {
            return "<temp file> : " + filename;
        }
        return filename;
    }

    public static final Log4jStringAppender createStringAppender() {
        Log4jStringAppender appender = new Log4jStringAppender();
        appender.setLayout(new Log4jKettleLayout(true));
        return appender;
    }

    public static void setConsoleAppenderDebug() {
        Enumeration appenders = Logger.getLogger((String)STRING_PENTAHO_DI_LOGGER_NAME).getAllAppenders();
        while (appenders.hasMoreElements()) {
            Object appender = appenders.nextElement();
            if (!(appender instanceof ConsoleAppender) && !(appender instanceof Log4jConsoleAppender) || !(appender instanceof ConsoleAppender)) continue;
            ((ConsoleAppender)appender).setThreshold(Priority.DEBUG);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean close() {
        boolean retval = true;
        try {
            Logger logger = Logger.getLogger((String)STRING_PENTAHO_DI_LOGGER_NAME);
            Enumeration appenders = logger.getAllAppenders();
            while (appenders.hasMoreElements()) {
                Appender appender = (Appender)appenders.nextElement();
                appender.close();
            }
            this.pentahoLogger.removeAllAppenders();
            logWriter = null;
        }
        catch (Exception e) {
            retval = false;
        }
        return retval;
    }

    public void setLogLevel(int lvl) {
        this.level = lvl;
    }

    public void setLogLevel(String lvl) {
        this.level = LogWriter.getLogLevel(lvl);
    }

    public int getLogLevel() {
        return this.level;
    }

    public String getLogLevelDesc() {
        return logLevelDescription[this.level];
    }

    public String getLogLevelLongDesc() {
        return log_level_desc_long[this.level];
    }

    public void println(int lvl, String msg) {
        this.println(lvl, "General", msg, new Object[0]);
    }

    public void println(int lvl, String subj, String msg, Object ... args) {
        if (this.level == 0) {
            return;
        }
        if (this.level < lvl) {
            return;
        }
        String subject = subj;
        if (subject == null) {
            subject = "Kettle";
        }
        String string = msg = args.length <= 0 ? msg : MessageFormat.format(msg, args);
        if (lvl != 1 && !Const.isEmpty(this.filter) && subject.indexOf(this.filter) < 0 && msg.indexOf(this.filter) < 0) {
            return;
        }
        Log4jMessage message = new Log4jMessage(msg, subject, lvl);
        switch (lvl) {
            case 1: {
                this.pentahoLogger.error((Object)message);
                break;
            }
            case 5: 
            case 6: {
                this.pentahoLogger.debug((Object)message);
                break;
            }
            default: {
                this.pentahoLogger.info((Object)message);
            }
        }
    }

    public void logMinimal(String subject, String message, Object ... args) {
        this.println(2, subject, message, args);
    }

    public void logBasic(String subject, String message, Object ... args) {
        this.println(3, subject, message, args);
    }

    public void logDetailed(String subject, String message, Object ... args) {
        this.println(4, subject, message, args);
    }

    public void logDebug(String subject, String message, Object ... args) {
        this.println(5, subject, message, args);
    }

    public void logRowlevel(String subject, String message, Object ... args) {
        this.println(6, subject, message, args);
    }

    public void logError(String subject, String message, Object ... args) {
        this.println(1, subject, message, args);
    }

    public void logError(String subject, String message, Throwable e) {
        String stackTrace = Const.getStackTracker(e);
        this.println(1, subject, message, new Object[0]);
        this.println(1, subject, stackTrace, new Object[0]);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public static final int getLogLevel(String lvl) {
        int i;
        if (lvl == null) {
            return 1;
        }
        for (i = 0; i < logLevelDescription.length; ++i) {
            if (!logLevelDescription[i].equalsIgnoreCase(lvl)) continue;
            return i;
        }
        for (i = 0; i < log_level_desc_long.length; ++i) {
            if (!log_level_desc_long[i].equalsIgnoreCase(lvl)) continue;
            return i;
        }
        return 3;
    }

    public static final String getLogLevelDesc(int l) {
        if (l < 0 || l >= logLevelDescription.length) {
            return logLevelDescription[3];
        }
        return logLevelDescription[l];
    }

    public InputStream getFileInputStream() throws IOException {
        return KettleVFS.getInputStream(this.fileAppender.getFile());
    }

    public FileObject getFileAppenderFile() throws IOException {
        return this.fileAppender.getFile();
    }

    public FileInputStream getFileInputStream(String filename, boolean exact) throws IOException {
        Appender appender = this.pentahoLogger.getAppender(LogWriter.createFileAppenderName(filename, exact));
        if (appender == null) {
            throw new IOException("Unable to find appender for file: " + filename + " (exact=" + exact + ")");
        }
        return new FileInputStream(((Log4jFileAppender)appender).getFile().getName().getPathDecoded());
    }

    public boolean isBasic() {
        return this.level >= 3;
    }

    public boolean isDetailed() {
        return this.level >= 4;
    }

    public boolean isDebug() {
        return this.level >= 5;
    }

    public boolean isRowLevel() {
        return this.level >= 6;
    }

    public File getRealFilename() {
        return this.realFilename;
    }

    public void setRealFilename(File realFilename) {
        this.realFilename = realFilename;
    }

    public void addAppender(Appender appender) {
        this.pentahoLogger.addAppender(appender);
    }

    public void removeAppender(Appender appender) {
        this.pentahoLogger.removeAppender(appender);
    }

    public static void setLayout(Layout layout) {
        LogWriter.layout = layout;
        Enumeration appenders = LogWriter.logWriter.pentahoLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof Log4jConsoleAppender) && !(appender instanceof Log4jFileAppender) && !(appender instanceof Log4jStringAppender)) continue;
            appender.setLayout(layout);
        }
    }

    public static Layout getLayout() {
        return layout;
    }

    static {
        logLevelDescription = new String[]{"Nothing", "Error", "Minimal", "Basic", "Detailed", "Debug", "Rowlevel"};
        log_level_desc_long = new String[]{Messages.getString("LogWriter.Level.Nothing.LongDesc"), Messages.getString("LogWriter.Level.Error.LongDesc"), Messages.getString("LogWriter.Level.Minimal.LongDesc"), Messages.getString("LogWriter.Level.Basic.LongDesc"), Messages.getString("LogWriter.Level.Detailed.LongDesc"), Messages.getString("LogWriter.Level.Debug.LongDesc"), Messages.getString("LogWriter.Level.Rowlevel.LongDesc")};
    }
}

